/*
 * Decompiled with CFR 0.152.
 */
package codec.x509;

import codec.asn1.ASN1BitString;
import codec.asn1.ASN1Choice;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1GeneralizedTime;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1SequenceOf;
import codec.asn1.ASN1TaggedType;
import codec.asn1.ASN1Time;
import codec.asn1.ASN1Type;
import codec.asn1.ASN1UTCTime;
import codec.asn1.Constraint;
import codec.asn1.ConstraintException;
import codec.asn1.DERDecoder;
import codec.asn1.DEREncoder;
import codec.asn1.Decoder;
import codec.asn1.Encoder;
import codec.util.JCA;
import codec.x501.BadNameException;
import codec.x501.Name;
import codec.x509.AlgorithmIdentifier;
import codec.x509.CRLEntry;
import codec.x509.X509Extension;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.AbstractList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TimeZone;

public class X509Crl
extends X509CRL
implements ASN1Type {
    private ASN1Sequence CertificateList = new ASN1Sequence(3);
    private ASN1Sequence TBSCertList = null;
    private ASN1Integer version = null;
    private AlgorithmIdentifier signatureAlgorithm = null;
    private Name issuer = null;
    private ASN1Choice thisUpdate = null;
    private ASN1Choice nextUpdate = null;
    private ASN1SequenceOf revokedCertificates = null;
    private ASN1SequenceOf crlExtensions = null;
    private ASN1TaggedType crlExtensionsTag = null;
    private AlgorithmIdentifier signatureAlgorithm2 = null;
    private ASN1BitString signature = null;
    static /* synthetic */ Class class$codec$x509$CRLEntry;
    static /* synthetic */ Class class$codec$x509$X509Extension;

    public X509Crl() {
        this.TBSCertList = new ASN1Sequence(7);
        this.version = new ASN1Integer(1);
        this.version.setOptional(false);
        this.TBSCertList.add(this.version);
        this.signatureAlgorithm = new AlgorithmIdentifier();
        this.TBSCertList.add(this.signatureAlgorithm);
        this.issuer = new Name();
        this.TBSCertList.add(this.issuer);
        this.thisUpdate = new ASN1Choice();
        this.thisUpdate.addType(new ASN1UTCTime());
        this.thisUpdate.addType(new ASN1GeneralizedTime());
        this.TBSCertList.add(this.thisUpdate);
        this.nextUpdate = new ASN1Choice();
        this.nextUpdate.setOptional(true);
        this.nextUpdate.addType(new ASN1UTCTime());
        this.nextUpdate.addType(new ASN1GeneralizedTime());
        this.TBSCertList.add(this.nextUpdate);
        this.revokedCertificates = new ASN1SequenceOf(class$codec$x509$CRLEntry == null ? (class$codec$x509$CRLEntry = X509Crl.class$("codec.x509.CRLEntry")) : class$codec$x509$CRLEntry);
        this.revokedCertificates.setOptional(true);
        this.TBSCertList.add(this.revokedCertificates);
        this.crlExtensions = new ASN1SequenceOf(class$codec$x509$X509Extension == null ? (class$codec$x509$X509Extension = X509Crl.class$("codec.x509.X509Extension")) : class$codec$x509$X509Extension);
        this.crlExtensionsTag = new ASN1TaggedType(0, this.crlExtensions, true, true);
        this.TBSCertList.add(this.crlExtensionsTag);
        this.CertificateList.add(this.TBSCertList);
        this.signatureAlgorithm2 = new AlgorithmIdentifier();
        this.CertificateList.add(this.signatureAlgorithm);
        this.signature = new ASN1BitString();
        this.CertificateList.add(this.signature);
    }

    public X509Crl(Name issuer, Calendar now) {
        this();
        this.setIssuerDN(issuer);
        this.setThisUpdate(now);
    }

    public X509Crl(int i) {
        this.TBSCertList = new ASN1Sequence(6);
        this.version = new ASN1Integer(1);
        this.version.setOptional(false);
        this.TBSCertList.add(this.version);
        this.signatureAlgorithm = new AlgorithmIdentifier();
        this.TBSCertList.add(this.signatureAlgorithm);
        this.issuer = new Name();
        this.TBSCertList.add(this.issuer);
        this.thisUpdate = new ASN1Choice();
        this.thisUpdate.addType(new ASN1UTCTime());
        this.thisUpdate.addType(new ASN1GeneralizedTime());
        this.TBSCertList.add(this.thisUpdate);
        this.revokedCertificates = new ASN1SequenceOf(class$codec$x509$CRLEntry == null ? (class$codec$x509$CRLEntry = X509Crl.class$("codec.x509.CRLEntry")) : class$codec$x509$CRLEntry);
        this.revokedCertificates.setOptional(true);
        this.TBSCertList.add(this.revokedCertificates);
        this.crlExtensions = new ASN1SequenceOf(class$codec$x509$X509Extension == null ? (class$codec$x509$X509Extension = X509Crl.class$("codec.x509.X509Extension")) : class$codec$x509$X509Extension);
        this.crlExtensionsTag = new ASN1TaggedType(0, this.crlExtensions, true, true);
        this.TBSCertList.add(this.crlExtensionsTag);
        this.CertificateList.add(this.TBSCertList);
        this.signatureAlgorithm2 = new AlgorithmIdentifier();
        this.CertificateList.add(this.signatureAlgorithm);
        this.signature = new ASN1BitString();
        this.CertificateList.add(this.signature);
    }

    public X509Crl(Name issuer, Calendar now, boolean _nextUpdate) {
        this(1);
        this.setIssuerDN(issuer);
        this.setThisUpdate(now);
    }

    public X509Crl(InputStream is) throws ASN1Exception, IOException {
        this();
        this.decode(new DERDecoder(is));
    }

    public void setConstraint(Constraint c) {
        this.CertificateList.setConstraint(c);
    }

    public Constraint getConstraint() {
        return this.CertificateList.getConstraint();
    }

    public void addEntry(CRLEntry e) {
        this.revokedCertificates.add(e);
        this.revokedCertificates.setOptional(false);
    }

    public void addExtension(X509Extension ex) {
        if (ex == null) {
            throw new NullPointerException("Extension is null!");
        }
        System.out.println("CODEC : ADDING CRL EXTENSION");
        this.crlExtensions.add(ex);
        this.crlExtensionsTag.setOptional(false);
    }

    public void checkConstraints() throws ConstraintException {
        this.CertificateList.checkConstraints();
    }

    public boolean containsCertificate(BigInteger s) {
        boolean res = false;
        Iterator it = ((AbstractList)this.revokedCertificates).iterator();
        while (it.hasNext() && !res) {
            if (!((CRLEntry)it.next()).getSerialNumber().equals(s)) continue;
            res = true;
        }
        return res;
    }

    public void decode(Decoder dec) throws ASN1Exception, IOException {
        this.CertificateList.decode(dec);
    }

    public void encode(Encoder enc) throws ASN1Exception, IOException {
        this.CertificateList.encode(enc);
    }

    public Set getCriticalExtensionOIDs() {
        HashSet<String> res = new HashSet<String>();
        Iterator it = ((AbstractList)this.crlExtensions).iterator();
        while (it.hasNext()) {
            X509Extension theEx = (X509Extension)it.next();
            if (!theEx.isCritical()) continue;
            res.add(theEx.getOID().toString());
        }
        return res;
    }

    public byte[] getEncoded() throws CRLException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.CertificateList.encode(new DEREncoder(baos));
        }
        catch (Exception e) {
            throw new CRLException(e.getMessage());
        }
        return baos.toByteArray();
    }

    public Collection getExtensions() {
        return this.crlExtensions.getCollection();
    }

    public byte[] getExtensionValue(String ex) {
        byte[] res = null;
        Iterator it = ((AbstractList)this.crlExtensions).iterator();
        while (it.hasNext()) {
            X509Extension theEx = (X509Extension)it.next();
            if (!theEx.getOID().toString().equals(ex)) continue;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                theEx.encode(new DEREncoder(baos));
                res = baos.toByteArray();
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return res;
    }

    public Principal getIssuerDN() {
        return this.issuer;
    }

    public Date getNextUpdate() {
        if (this.nextUpdate.isOptional()) {
            return null;
        }
        ASN1Time a1t = (ASN1Time)this.nextUpdate.getInnerType();
        return a1t.getDate();
    }

    public Set getNonCriticalExtensionOIDs() {
        HashSet<String> res = new HashSet<String>();
        Iterator it = ((AbstractList)this.crlExtensions).iterator();
        while (it.hasNext()) {
            X509Extension theEx = (X509Extension)it.next();
            if (theEx.isCritical()) continue;
            res.add(theEx.getOID().toString());
        }
        return res;
    }

    public X509CRLEntry getRevokedCertificate(BigInteger serialNumber) {
        CRLEntry res = null;
        Iterator it = ((AbstractList)this.revokedCertificates).iterator();
        while (it.hasNext() && res == null) {
            CRLEntry cmp = (CRLEntry)it.next();
            if (!cmp.getSerialNumber().equals(serialNumber)) continue;
            res = cmp;
        }
        return res;
    }

    public Set getRevokedCertificates() {
        HashSet<CRLEntry> hs = new HashSet<CRLEntry>();
        Iterator it = ((AbstractList)this.revokedCertificates).iterator();
        while (it.hasNext()) {
            CRLEntry ce = (CRLEntry)it.next();
            hs.add(ce);
        }
        return hs;
    }

    public String getSigAlgName() {
        return JCA.getName(this.getSigAlgOID());
    }

    public String getSigAlgOID() {
        return this.signatureAlgorithm.getAlgorithmOID().toString();
    }

    public byte[] getSigAlgParams() {
        try {
            return this.signatureAlgorithm.getParameters().getEncoded();
        }
        catch (Exception e) {
            return null;
        }
    }

    public byte[] getSignature() {
        return this.signature.getBytes();
    }

    public int getTag() {
        return this.CertificateList.getTag();
    }

    public int getTagClass() {
        return this.CertificateList.getTagClass();
    }

    public byte[] getTBSCertList() throws CRLException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.TBSCertList.encode(new DEREncoder(baos));
        }
        catch (Exception e) {
            throw new CRLException(e.getMessage());
        }
        return baos.toByteArray();
    }

    public byte[] getTBSCertList(AlgorithmIdentifier sigalg) throws CRLException {
        this.setSignatureAlgorithm(sigalg);
        byte[] res = null;
        try {
            res = this.getTBSCertList();
        }
        catch (Exception e) {
            throw new CRLException(e.getMessage());
        }
        return res;
    }

    public Date getThisUpdate() {
        ASN1Time a1t = (ASN1Time)this.thisUpdate.getInnerType();
        return a1t.getDate();
    }

    public Object getValue() {
        return this.CertificateList.getValue();
    }

    public int getVersion() {
        return this.version.getBigInteger().intValue();
    }

    public boolean hasUnsupportedCriticalExtension() {
        boolean res = false;
        Set s = this.getCriticalExtensionOIDs();
        Iterator it = s.iterator();
        while (it.hasNext() && !res) {
            it.next();
        }
        return res;
    }

    public boolean isExplicit() {
        return this.CertificateList.isExplicit();
    }

    public boolean isOptional() {
        return this.CertificateList.isOptional();
    }

    public boolean isRevoked(Certificate crt) {
        boolean res = false;
        if (!(crt instanceof X509Certificate)) {
            return false;
        }
        try {
            BigInteger s = ((X509Certificate)crt).getSerialNumber();
            Iterator it = ((AbstractList)this.revokedCertificates).iterator();
            while (it.hasNext() && !res) {
                if (!((CRLEntry)it.next()).getSerialNumber().equals(s)) continue;
                res = true;
            }
        }
        catch (Exception i) {
            res = true;
            System.out.println("Hinweis: sicherheitshalber als revoziert betrachtet!");
        }
        return res;
    }

    public boolean isType(int eins, int zwei) {
        return this.CertificateList.isType(eins, zwei);
    }

    public void setExplicit(boolean ex) {
        this.CertificateList.setExplicit(ex);
    }

    public void setIssuerDN(Principal iss) {
        if (iss instanceof Name) {
            this.issuer = (Name)iss;
            this.TBSCertList.set(2, iss);
        } else {
            try {
                this.issuer = new Name(iss.toString(), -1);
            }
            catch (BadNameException e) {
                throw new RuntimeException("bad principal name:" + e.getMessage());
            }
        }
    }

    public void setNextUpdate(Calendar time) {
        ASN1Time akt_time = (ASN1Time)this.nextUpdate.getInnerType();
        if (akt_time == null) {
            akt_time = new ASN1UTCTime(time);
            this.nextUpdate.setInnerType(akt_time);
        }
        akt_time.setDate(time);
        this.nextUpdate.setOptional(false);
    }

    public void setNextUpdate(Date time) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(time);
        this.setNextUpdate(cal);
    }

    public void setOptional(boolean opt) {
        this.CertificateList.setOptional(opt);
    }

    public void setSignature(byte[] sig) {
        try {
            this.signature.setBits(sig, 0);
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
    }

    public void setSignatureAlgorithm(AlgorithmIdentifier sigalg) {
        this.signatureAlgorithm = sigalg;
        this.CertificateList.set(1, this.signatureAlgorithm);
        this.signatureAlgorithm2 = (AlgorithmIdentifier)sigalg.clone();
        this.TBSCertList.set(1, this.signatureAlgorithm2);
    }

    public void setThisUpdate(Calendar time) {
        ASN1Time akt_time = (ASN1Time)this.thisUpdate.getInnerType();
        if (akt_time == null) {
            akt_time = new ASN1UTCTime(time);
            this.thisUpdate.setInnerType(akt_time);
        }
        akt_time.setDate(time);
    }

    public void setThisUpdate(Date time) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(time);
        this.setThisUpdate(cal);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String offset) {
        String res = "";
        res = offset + "X.509 Certificate Revocation List (V";
        res = res + (this.version.getBigInteger().intValue() + 1) + "):";
        res = res + "\n" + offset + "issuer:" + this.getIssuerDN().toString();
        String thisupd = DateFormat.getDateTimeInstance(0, 0).format(this.getThisUpdate());
        res = res + "\n" + offset + "this update:" + thisupd;
        if (!this.nextUpdate.isOptional()) {
            String nextupd = DateFormat.getDateTimeInstance(0, 0).format(this.getNextUpdate());
            res = res + "\n" + offset + "next update:" + nextupd;
        }
        if (this.revokedCertificates.isEmpty()) {
            res = res + "\n" + offset + "no revoked certificates.";
        } else {
            res = res + "\n" + offset + "revoked certificates:";
            int i = 1;
            Iterator it = ((AbstractList)this.revokedCertificates).iterator();
            while (it.hasNext()) {
                CRLEntry ent = (CRLEntry)it.next();
                res = res + "\n" + offset + String.valueOf(i) + ":";
                res = res + ent.toString(offset + "  ");
                ++i;
            }
        }
        if (!this.crlExtensions.isEmpty()) {
            res = res + "\n" + offset + "CRL Extensions:";
            Iterator it = ((AbstractList)this.crlExtensions).iterator();
            while (it.hasNext()) {
                X509Extension ext = (X509Extension)it.next();
                res = res + "\n" + ext.toString(offset + " ");
            }
        }
        res = res + "\n" + offset + "signature algorithm:" + this.getSigAlgName();
        res = res + "\n" + offset + "signature:" + this.signature.toString();
        return res;
    }

    public void verify(PublicKey key) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(key, "");
    }

    public void verify(PublicKey key, String sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature theSig = null;
        String alg_oid = this.getSigAlgOID();
        String alg_name = this.getSigAlgName();
        try {
            theSig = !sigProvider.equals("") ? Signature.getInstance(alg_name, sigProvider) : Signature.getInstance(alg_name);
        }
        catch (NoSuchAlgorithmException nsae) {
            theSig = !sigProvider.equals("") ? Signature.getInstance(alg_oid, sigProvider) : Signature.getInstance(alg_oid);
        }
        theSig.initVerify(key);
        theSig.update(this.getTBSCertList());
        if (!theSig.verify(this.getSignature())) {
            throw new SignatureException("Invalid Signature!");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

