/*
 * Decompiled with CFR 0.152.
 */
package codec.pkcs8;

import codec.InconsistentStateException;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1Sequence;
import codec.asn1.DERDecoder;
import codec.pkcs8.PrivateKeyInfo;
import codec.x509.AlgorithmIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class EncryptedPrivateKeyInfo
extends ASN1Sequence {
    public static final String DEFAULT_PBE = "PBEWithMD5AndDES";
    public static final int DEFAULT_SALT = 8;
    public static final int DEFAULT_ITERATIONCOUNT = 64;
    protected ASN1OctetString encryptedData_;
    protected AlgorithmIdentifier algorithm_ = new AlgorithmIdentifier();
    protected SecureRandom random_;
    protected PBEParameterSpec pbeParamSpec_;
    static /* synthetic */ Class class$javax$crypto$spec$PBEParameterSpec;

    public EncryptedPrivateKeyInfo() {
        super(2);
        this.add(this.algorithm_);
        this.encryptedData_ = new ASN1OctetString();
        this.add(this.encryptedData_);
    }

    public void setPrivateKey(PrivateKey key, char[] passwd) throws GeneralSecurityException {
        this.setPrivateKey(key, passwd, DEFAULT_PBE);
    }

    public void setPrivateKey(PrivateKey key, char[] passwd, String algorithm) throws GeneralSecurityException {
        if (key == null || passwd == null || algorithm == null) {
            throw new NullPointerException("Some arg is null!");
        }
        if (this.random_ == null) {
            this.random_ = new SecureRandom();
        }
        byte[] salt = new byte[8];
        this.random_.nextBytes(salt);
        PBEParameterSpec pspec = new PBEParameterSpec(salt, 64);
        PBEKeySpec kspec = new PBEKeySpec(passwd);
        SecretKeyFactory factory = SecretKeyFactory.getInstance(algorithm);
        SecretKey pbekey = factory.generateSecret(kspec);
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(1, (Key)pbekey, pspec);
        byte[] buf = key.getEncoded();
        byte[] code = cipher.doFinal(buf);
        Arrays.fill(buf, (byte)0);
        AlgorithmParameters params = AlgorithmParameters.getInstance(algorithm);
        params.init(pspec);
        this.clear();
        this.algorithm_ = new AlgorithmIdentifier(algorithm, params);
        this.add(this.algorithm_);
        this.encryptedData_ = new ASN1OctetString(code);
        this.add(this.encryptedData_);
    }

    public PrivateKey getPrivateKey(char[] password) throws GeneralSecurityException {
        try {
            String name = this.algorithm_.getAlgorithmOID().toString();
            AlgorithmParameters params = this.algorithm_.getParameters();
            PBEParameterSpec pspec = (PBEParameterSpec)params.getParameterSpec(class$javax$crypto$spec$PBEParameterSpec == null ? (class$javax$crypto$spec$PBEParameterSpec = EncryptedPrivateKeyInfo.class$("javax.crypto.spec.PBEParameterSpec")) : class$javax$crypto$spec$PBEParameterSpec);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(name);
            KeySpec kspec = new PBEKeySpec(password);
            SecretKey secret = skf.generateSecret(kspec);
            Cipher cipher = Cipher.getInstance(name);
            cipher.init(2, (Key)secret, pspec);
            byte[] buf = cipher.doFinal(this.encryptedData_.getByteArray());
            kspec = new PKCS8EncodedKeySpec(buf);
            PrivateKeyInfo pki = new PrivateKeyInfo();
            DERDecoder dec = new DERDecoder(new ByteArrayInputStream(buf));
            pki.decode(dec);
            dec.close();
            AlgorithmIdentifier aid = pki.getAlgorithmIdentifier();
            name = aid.getAlgorithmOID().toString();
            KeyFactory kf = KeyFactory.getInstance(name);
            return kf.generatePrivate(kspec);
        }
        catch (ASN1Exception e) {
            throw new UnrecoverableKeyException(e.getMessage());
        }
        catch (IOException e) {
            throw new InconsistentStateException("Caught IOException!");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

