/*
 * Decompiled with CFR 0.152.
 */
package codec.pkcs12;

import codec.asn1.ASN1Integer;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1Sequence;
import codec.pkcs1.DigestInfo;
import java.io.Serializable;

public class MacData
extends ASN1Sequence
implements Serializable {
    protected DigestInfo mac_;
    protected ASN1OctetString macSalt_;
    protected ASN1Integer iter_ = new ASN1Integer(1);

    public MacData() {
        super(3);
        this.mac_ = new DigestInfo();
        this.add(this.mac_);
        this.macSalt_ = new ASN1OctetString();
        this.add(this.macSalt_);
        this.iter_ = new ASN1Integer();
        this.iter_.setOptional(true);
        this.add(this.iter_);
    }

    public MacData(DigestInfo digest, byte[] salt, int it) {
        super(3);
        this.mac_ = digest;
        this.add(this.mac_);
        this.macSalt_ = new ASN1OctetString(salt);
        this.add(this.macSalt_);
        this.iter_ = new ASN1Integer(it);
        if (it == 1) {
            this.iter_.setOptional(true);
        }
        this.add(this.iter_);
    }

    public int getIterationCount() {
        if (this.iter_.isOptional()) {
            return 1;
        }
        return this.iter_.getBigInteger().intValue();
    }

    public DigestInfo getMacData() {
        return this.mac_;
    }

    public byte[] getSalt() {
        return this.macSalt_.getByteArray();
    }
}

