/*
 * Decompiled with CFR 0.152.
 */
package codec.asn1;

import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1Permission;
import codec.asn1.ASN1Type;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class OIDRegistry {
    private static Set registries_ = Collections.synchronizedSet(new HashSet());
    private static OIDRegistry global_ = new OIDRegistry();
    private OIDRegistry parent_ = null;

    private OIDRegistry() {
    }

    public static final OIDRegistry getGlobalOIDRegistry() {
        return global_;
    }

    public static final void addOIDRegistry(OIDRegistry r) {
        if (r == null) {
            return;
        }
        AccessController.checkPermission(new ASN1Permission("OIDRegistry.add"));
        r.parent_ = null;
        registries_.add(r);
    }

    public static final void removeOIDRegistry(OIDRegistry r) {
        if (r == null) {
            return;
        }
        AccessController.checkPermission(new ASN1Permission("OIDRegistry.remove"));
        registries_.remove(r);
    }

    public OIDRegistry(OIDRegistry parent) {
        this.parent_ = parent;
    }

    public final ASN1Type getASN1Type(ASN1ObjectIdentifier oid) {
        ASN1Type o = this.getLocalASN1Type(oid);
        if (o == null && this.parent_ != null) {
            return this.parent_.getASN1Type(oid);
        }
        return o;
    }

    protected ASN1Type getLocalASN1Type(ASN1ObjectIdentifier oid) {
        Iterator i = registries_.iterator();
        while (i.hasNext()) {
            OIDRegistry r = (OIDRegistry)i.next();
            ASN1Type o = r.getASN1Type(oid);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    protected ASN1Type getLocalASN1Type(ASN1ObjectIdentifier oid, Map map) {
        if (oid == null || map == null) {
            throw new NullPointerException("oid or map");
        }
        Object o = map.get(oid);
        if (o == null) {
            return null;
        }
        try {
            Class<?> c;
            if (o instanceof String) {
                c = Class.forName((String)o);
                map.put(new ASN1ObjectIdentifier(oid.getOID()), c);
                o = c;
            }
            c = (Class<?>)o;
            return (ASN1Type)c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public static OIDRegistry getDefaultRegistry() {
        return OIDRegistry.getGlobalOIDRegistry();
    }

    public boolean equals(Object o) {
        return this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

