/*
 * Decompiled with CFR 0.152.
 */
package codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class UTF8InputStreamReader
extends Reader {
    protected int numbytes_ = 0;
    protected int hasExtra_ = 0;
    protected char extraCh_ = '\u0000';
    protected int byteptr_ = 0;
    protected InputStream ins_;
    protected byte[] bytebuf_;

    public UTF8InputStreamReader(InputStream i, int bufsize) {
        this.ins_ = i;
        this.bytebuf_ = new byte[bufsize];
    }

    public String getEncoding() {
        return "UTF8";
    }

    protected void checkOpen() throws IOException {
        if (this.ins_ == null) {
            throw new IOException("Stream closed");
        }
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n = this.translate();
            return n;
        }
    }

    /*
     * Unable to fully structure code
     */
    public int read(char[] cbuf, int off, int len) throws IOException {
        end = off + len;
        if (len < 0 || off < 0 || cbuf.length < off || end < 0 || cbuf.length < end) {
            throw new IndexOutOfBoundsException();
        }
        result = 0;
        var7_6 = this.lock;
        synchronized (var7_6) {
            this.checkOpen();
            if (len != 0) ** GOTO lbl16
            var8_7 = 0;
            return var8_7;
            while ((ch = this.translate()) >= 0) {
                cbuf[off++] = (char)ch;
                ++result;
                --len;
lbl16:
                // 2 sources

                if (len > 0) continue;
            }
        }
        return result == 0 ? -1 : result;
    }

    public String readLine() throws IOException {
        StringBuffer s = null;
        Object object = this.lock;
        synchronized (object) {
            this.checkOpen();
            while (true) {
                int ch;
                if ((ch = this.translate()) < 0) {
                    String string = s == null ? null : s.toString();
                    return string;
                }
                if (ch == 10) break;
                if (ch == 13) {
                    int ch2 = this.translate();
                    if (ch2 == 10 || ch2 < 0) break;
                    this.hasExtra_ = 1;
                    this.extraCh_ = (char)ch2;
                    break;
                }
                if (s == null) {
                    s = new StringBuffer(80);
                }
                s.append((char)ch);
            }
        }
        return s == null ? "" : s.toString();
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkOpen();
            try {
                boolean bl = this.hasExtra_ > 0 || this.numbytes_ > this.byteptr_ || this.ins_.available() > 0;
                return bl;
            }
            catch (IOException e1) {
                boolean bl = false;
                return bl;
            }
        }
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.ins_ != null) {
                this.ins_.close();
                this.ins_ = null;
                this.bytebuf_ = null;
            }
        }
    }

    private int morebyte() throws IOException {
        if (this.byteptr_ < this.numbytes_) {
            return 0xFF & this.bytebuf_[this.byteptr_++];
        }
        this.byteptr_ = 0;
        this.numbytes_ = this.ins_.read(this.bytebuf_);
        if (this.numbytes_ > 0) {
            return 0xFF & this.bytebuf_[this.byteptr_++];
        }
        this.numbytes_ = 0;
        return -1;
    }

    private int translate() throws IOException {
        if (this.hasExtra_ > 0) {
            this.hasExtra_ = 0;
            return this.extraCh_;
        }
        int char1 = this.morebyte();
        if (char1 < 0) {
            return char1;
        }
        if (0 == (char1 & 0x80)) {
            return char1;
        }
        switch (char1 >> 4) {
            case 12: 
            case 13: {
                int char2 = this.morebyte();
                if (char2 < 0) {
                    this.characterDecodingException();
                }
                if ((char2 & 0xC0) != 128) {
                    this.characterDecodingException();
                }
                return (char1 & 0x1F) << 6 | char2 & 0x3F;
            }
            case 14: {
                int char3;
                int char2 = this.morebyte();
                if (char2 < 0) {
                    this.characterDecodingException();
                }
                if ((char3 = this.morebyte()) < 0) {
                    this.characterDecodingException();
                }
                if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                    this.characterDecodingException();
                }
                return (char1 & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F;
            }
            case 15: {
                int char4;
                int char3;
                int char2 = this.morebyte();
                if (char2 < 0) {
                    this.characterDecodingException();
                }
                if ((char3 = this.morebyte()) < 0) {
                    this.characterDecodingException();
                }
                if ((char4 = this.morebyte()) < 0) {
                    this.characterDecodingException();
                }
                if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128 || (char4 & 0xC0) != 128) {
                    this.characterDecodingException();
                }
                int a4 = (char1 & 7) << 18 | (char2 & 0x3F) << 12 | (char3 & 0x3F) << 6 | char4 & 0x3F;
                this.hasExtra_ = 1;
                this.extraCh_ = (char)((a4 - 65536) % 1024 + 56320);
                return (char)((a4 - 65536) / 1024 + 55296);
            }
        }
        throw new IOException("Character decoding exception.");
    }

    protected void characterDecodingException() throws IOException {
        throw new IOException("Character decoding exception.");
    }
}

