/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns;

import com.notnoop.apns.ApnsDelegate;
import com.notnoop.apns.ApnsService;
import com.notnoop.apns.ReconnectPolicy;
import com.notnoop.apns.internal.AbstractApnsService;
import com.notnoop.apns.internal.ApnsConnection;
import com.notnoop.apns.internal.ApnsConnectionImpl;
import com.notnoop.apns.internal.ApnsFeedbackConnection;
import com.notnoop.apns.internal.ApnsPooledConnection;
import com.notnoop.apns.internal.ApnsServiceImpl;
import com.notnoop.apns.internal.BatchApnsService;
import com.notnoop.apns.internal.QueuedApnsService;
import com.notnoop.apns.internal.Utilities;
import com.notnoop.exceptions.InvalidSSLConfig;
import com.notnoop.exceptions.RuntimeIOException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.security.KeyStore;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class ApnsServiceBuilder {
    private static final String KEYSTORE_TYPE = "PKCS12";
    private static final String KEY_ALGORITHM = "sunx509";
    private SSLContext sslContext = null;
    private String gatewayHost;
    private int gatewaPort = -1;
    private String feedbackHost;
    private int feedbackPort;
    private int pooledMax = 1;
    private int cacheLength = 100;
    private boolean autoAdjustCacheLength = true;
    private ExecutorService executor = null;
    private ReconnectPolicy reconnectPolicy = ReconnectPolicy.Provided.NEVER.newObject();
    private boolean isQueued = false;
    private boolean isBatched = false;
    private int batchWaitTimeInSec;
    private int batchMaxWaitTimeInSec;
    private ThreadFactory batchThreadFactory;
    private ApnsDelegate delegate = ApnsDelegate.EMPTY;
    private Proxy proxy = null;
    private boolean errorDetection = true;

    public ApnsServiceBuilder withCert(String fileName, String password) throws RuntimeIOException, InvalidSSLConfig {
        ApnsServiceBuilder apnsServiceBuilder;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(fileName);
            apnsServiceBuilder = this.withCert(stream, password);
        }
        catch (FileNotFoundException e) {
            try {
                throw new RuntimeIOException(e);
            }
            catch (Throwable throwable) {
                Utilities.close(stream);
                throw throwable;
            }
        }
        Utilities.close(stream);
        return apnsServiceBuilder;
    }

    public ApnsServiceBuilder withCert(InputStream stream, String password) throws InvalidSSLConfig {
        this.assertPasswordNotEmpty(password);
        return this.withSSLContext(Utilities.newSSLContext(stream, password, KEYSTORE_TYPE, KEY_ALGORITHM));
    }

    public ApnsServiceBuilder withCert(KeyStore keyStore, String password) throws InvalidSSLConfig {
        this.assertPasswordNotEmpty(password);
        return this.withSSLContext(Utilities.newSSLContext(keyStore, password, KEY_ALGORITHM));
    }

    private void assertPasswordNotEmpty(String password) {
        if (password == null || password.length() == 0) {
            throw new IllegalArgumentException("Passwords must be specified.Oracle Java SDK does not support passwordless p12 certificates");
        }
    }

    public ApnsServiceBuilder withSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public ApnsServiceBuilder withGatewayDestination(String host, int port) {
        this.gatewayHost = host;
        this.gatewaPort = port;
        return this;
    }

    public ApnsServiceBuilder withFeedbackDestination(String host, int port) {
        this.feedbackHost = host;
        this.feedbackPort = port;
        return this;
    }

    public ApnsServiceBuilder withAppleDestination(boolean isProduction) {
        if (isProduction) {
            return this.withProductionDestination();
        }
        return this.withSandboxDestination();
    }

    public ApnsServiceBuilder withSandboxDestination() {
        return this.withGatewayDestination("gateway.sandbox.push.apple.com", 2195).withFeedbackDestination("feedback.sandbox.push.apple.com", 2196);
    }

    public ApnsServiceBuilder withProductionDestination() {
        return this.withGatewayDestination("gateway.push.apple.com", 2195).withFeedbackDestination("feedback.push.apple.com", 2196);
    }

    public ApnsServiceBuilder withReconnectPolicy(ReconnectPolicy rp) {
        this.reconnectPolicy = rp;
        return this;
    }

    public ApnsServiceBuilder withAutoAdjustCacheLength(boolean autoAdjustCacheLength) {
        this.autoAdjustCacheLength = autoAdjustCacheLength;
        return this;
    }

    public ApnsServiceBuilder withReconnectPolicy(ReconnectPolicy.Provided rp) {
        this.reconnectPolicy = rp.newObject();
        return this;
    }

    public ApnsServiceBuilder withSocksProxy(String host, int port) {
        Proxy proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(host, port));
        return this.withProxy(proxy);
    }

    public ApnsServiceBuilder withProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public ApnsServiceBuilder withCacheLength(int cacheLength) {
        this.cacheLength = cacheLength;
        return this;
    }

    @Deprecated
    public ApnsServiceBuilder withProxySocket(Socket proxySocket) {
        return this.withProxy(new Proxy(Proxy.Type.SOCKS, proxySocket.getRemoteSocketAddress()));
    }

    public ApnsServiceBuilder asPool(int maxConnections) {
        return this.asPool(Executors.newFixedThreadPool(maxConnections), maxConnections);
    }

    public ApnsServiceBuilder asPool(ExecutorService executor, int maxConnections) {
        this.pooledMax = maxConnections;
        this.executor = executor;
        return this;
    }

    public ApnsServiceBuilder asQueued() {
        this.isQueued = true;
        return this;
    }

    public ApnsServiceBuilder asBatched() {
        return this.asBatched(5, 10);
    }

    public ApnsServiceBuilder asBatched(int waitTimeInSec, int maxWaitTimeInSec) {
        return this.asBatched(waitTimeInSec, maxWaitTimeInSec, Executors.defaultThreadFactory());
    }

    public ApnsServiceBuilder asBatched(int waitTimeInSec, int maxWaitTimeInSec, ThreadFactory threadFactory) {
        this.isBatched = true;
        this.batchWaitTimeInSec = waitTimeInSec;
        this.batchMaxWaitTimeInSec = maxWaitTimeInSec;
        this.batchThreadFactory = threadFactory;
        return this;
    }

    public ApnsServiceBuilder withDelegate(ApnsDelegate delegate) {
        this.delegate = delegate == null ? ApnsDelegate.EMPTY : delegate;
        return this;
    }

    public ApnsServiceBuilder withNoErrorDetection() {
        this.errorDetection = false;
        return this;
    }

    public ApnsService build() {
        this.checkInitialization();
        SSLSocketFactory sslFactory = this.sslContext.getSocketFactory();
        ApnsFeedbackConnection feedback = new ApnsFeedbackConnection(sslFactory, this.feedbackHost, this.feedbackPort, this.proxy);
        ApnsConnection conn = new ApnsConnectionImpl(sslFactory, this.gatewayHost, this.gatewaPort, this.proxy, this.reconnectPolicy, this.delegate, this.errorDetection, this.cacheLength, this.autoAdjustCacheLength);
        if (this.pooledMax != 1) {
            conn = new ApnsPooledConnection(conn, this.pooledMax, this.executor);
        }
        AbstractApnsService service = new ApnsServiceImpl(conn, feedback);
        if (this.isQueued) {
            service = new QueuedApnsService(service);
        }
        if (this.isBatched) {
            service = new BatchApnsService(conn, feedback, this.batchWaitTimeInSec, this.batchMaxWaitTimeInSec, this.batchThreadFactory);
        }
        service.start();
        return service;
    }

    private void checkInitialization() {
        if (this.sslContext == null) {
            throw new IllegalStateException("SSL Certificates and attribute are not initialized\nUse .withCert() methods.");
        }
        if (this.gatewayHost == null || this.gatewaPort == -1) {
            throw new IllegalStateException("The Destination APNS server is not stated\nUse .withDestination(), withSandboxDestination(), or withProductionDestination().");
        }
    }
}

