/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.ec.keys;

import de.flexiprovider.api.exceptions.InvalidKeySpecException;
import de.flexiprovider.api.exceptions.InvalidParameterException;
import de.flexiprovider.api.exceptions.InvalidParameterSpecException;
import de.flexiprovider.api.keys.KeySpec;
import de.flexiprovider.common.exceptions.InvalidFormatException;
import de.flexiprovider.common.exceptions.InvalidPointException;
import de.flexiprovider.common.math.ellipticcurves.Point;
import de.flexiprovider.common.util.ByteUtils;
import de.flexiprovider.ec.parameters.CurveParams;

public final class ECPublicKeySpec
implements KeySpec {
    private Point mW;
    private byte[] mEncodedW;
    private CurveParams mParams;

    public ECPublicKeySpec(Point W, CurveParams params) throws InvalidParameterException {
        if (params == null) {
            throw new InvalidParameterException("EC domain parameters must not be null");
        }
        this.mW = W;
        this.mParams = params;
    }

    public ECPublicKeySpec(byte[] encodedW, CurveParams params) throws InvalidParameterSpecException {
        this.mEncodedW = ByteUtils.clone(encodedW);
        if (params != null) {
            this.setParams(params);
        }
    }

    public ECPublicKeySpec(ECPublicKeySpec other) {
        if (other.mW != null) {
            this.mW = (Point)other.mW.clone();
        }
        if (other.mEncodedW != null) {
            this.mEncodedW = ByteUtils.clone(other.mEncodedW);
        }
        this.mParams = other.mParams;
    }

    public Point getW() throws InvalidKeySpecException {
        if (this.mW == null) {
            throw new InvalidKeySpecException("No EC domain parameters defined for the public point");
        }
        return this.mW;
    }

    public byte[] getEncodedW() {
        if (this.mEncodedW != null) {
            return this.mEncodedW;
        }
        return this.mW.EC2OSP(0);
    }

    public CurveParams getParams() {
        return this.mParams;
    }

    public void setParams(CurveParams params) throws InvalidParameterSpecException {
        if (params == null) {
            if (this.mEncodedW != null) {
                return;
            }
            this.mEncodedW = this.mW.EC2OSP(0);
            this.mW = null;
        } else if (this.mParams == null) {
            try {
                this.mW = Point.OS2ECP(this.mEncodedW, params);
                this.mParams = params;
                this.mEncodedW = null;
            }
            catch (InvalidPointException ipe) {
                throw new InvalidParameterException("Unable to compute point object from encoded point and given EC domain parameters (caught InvalidPointException: " + ipe.getMessage() + ").");
            }
            catch (InvalidFormatException ife) {
                throw new InvalidParameterException("Unable to compute point object from encoded point and given EC domain parameters (caught InvalidFormatException: " + ife.getMessage() + ").");
            }
        } else {
            if (this.mParams.equals(params)) {
                return;
            }
            throw new InvalidParameterException("Illegally tried to change existing curve parameters.");
        }
    }
}

