/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.record;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.util.Clock;
import java.io.IOException;

public class RecordStatistics
implements DataSerializable {
    protected int hits = 0;
    protected long lastStoredTime = 0L;
    protected long lastUpdateTime = 0L;
    protected long lastAccessTime = 0L;
    protected long creationTime = 0L;
    protected long expirationTime = 0L;

    public RecordStatistics() {
        long now;
        this.lastAccessTime = now = Clock.currentTimeMillis();
        this.lastUpdateTime = now;
        this.creationTime = now;
    }

    public int getHits() {
        return this.hits;
    }

    public void setHits(int hits) {
        this.hits = hits;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    public void access() {
        this.lastAccessTime = Clock.currentTimeMillis();
        ++this.hits;
    }

    public void update() {
        this.lastUpdateTime = Clock.currentTimeMillis();
    }

    public void store() {
        this.lastStoredTime = Clock.currentTimeMillis();
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public long getLastStoredTime() {
        return this.lastStoredTime;
    }

    public void setLastStoredTime(long lastStoredTime) {
        this.lastStoredTime = lastStoredTime;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public long size() {
        return 44L;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.hits);
        out.writeLong(this.lastStoredTime);
        out.writeLong(this.lastUpdateTime);
        out.writeLong(this.lastAccessTime);
        out.writeLong(this.creationTime);
        out.writeLong(this.expirationTime);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.hits = in.readInt();
        this.lastStoredTime = in.readLong();
        this.lastUpdateTime = in.readLong();
        this.lastAccessTime = in.readLong();
        this.creationTime = in.readLong();
        this.expirationTime = in.readLong();
    }
}

