/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.TypeLibrary;
import lombok.core.TypeResolver;
import lombok.javac.JavacNode;

public class Javac {
    private Javac() {
    }

    public static boolean annotationTypeMatches(Class<? extends Annotation> type, JavacNode node) {
        if (node.getKind() != AST.Kind.ANNOTATION) {
            return false;
        }
        String typeName = ((JCTree.JCAnnotation)node.get()).annotationType.toString();
        TypeLibrary library = new TypeLibrary();
        library.addType(type.getName());
        TypeResolver resolver = new TypeResolver(library, node.getPackageDeclaration(), node.getImportStatements());
        Collection<String> typeMatches = resolver.findTypeMatches(node, typeName);
        for (String match : typeMatches) {
            if (!match.equals(type.getName())) continue;
            return true;
        }
        return false;
    }

    public static <A extends Annotation> AnnotationValues<A> createAnnotation(Class<A> type, final JavacNode node) {
        HashMap<String, AnnotationValues.AnnotationValue> values = new HashMap<String, AnnotationValues.AnnotationValue>();
        JCTree.JCAnnotation anno = (JCTree.JCAnnotation)node.get();
        java.util.List arguments = anno.getArguments();
        for (Method m : type.getDeclaredMethods()) {
            if (!Modifier.isPublic(m.getModifiers())) continue;
            String name = m.getName();
            ArrayList<String> raws = new ArrayList<String>();
            ArrayList<Object> guesses = new ArrayList<Object>();
            final ArrayList<JCDiagnostic.DiagnosticPosition> positions = new ArrayList<JCDiagnostic.DiagnosticPosition>();
            boolean isExplicit = false;
            for (JCTree.JCExpression arg : arguments) {
                JCTree.JCExpression rhs;
                String mName;
                if (arg instanceof JCTree.JCAssign) {
                    JCTree.JCAssign assign = (JCTree.JCAssign)arg;
                    mName = assign.lhs.toString();
                    rhs = assign.rhs;
                } else {
                    rhs = arg;
                    mName = "value";
                }
                if (!mName.equals(name)) continue;
                isExplicit = true;
                if (rhs instanceof JCTree.JCNewArray) {
                    List<JCTree.JCExpression> elems = ((JCTree.JCNewArray)rhs).elems;
                    for (JCTree.JCExpression inner : elems) {
                        raws.add(inner.toString());
                        guesses.add(Javac.calculateGuess(inner));
                        positions.add(inner.pos());
                    }
                    continue;
                }
                raws.add(rhs.toString());
                guesses.add(Javac.calculateGuess(rhs));
                positions.add(rhs.pos());
            }
            values.put(name, new AnnotationValues.AnnotationValue(node, raws, guesses, isExplicit){

                @Override
                public void setError(String message, int valueIdx) {
                    if (valueIdx < 0) {
                        node.addError(message);
                    } else {
                        node.addError(message, (JCDiagnostic.DiagnosticPosition)positions.get(valueIdx));
                    }
                }

                @Override
                public void setWarning(String message, int valueIdx) {
                    if (valueIdx < 0) {
                        node.addWarning(message);
                    } else {
                        node.addWarning(message, (JCDiagnostic.DiagnosticPosition)positions.get(valueIdx));
                    }
                }
            });
        }
        return new AnnotationValues<A>(type, values, node);
    }

    private static Object calculateGuess(JCTree.JCExpression expr) {
        if (expr instanceof JCTree.JCLiteral) {
            JCTree.JCLiteral lit = (JCTree.JCLiteral)expr;
            if (lit.getKind() == Tree.Kind.BOOLEAN_LITERAL) {
                return ((Number)lit.value).intValue() != 0;
            }
            return lit.value;
        }
        if (expr instanceof JCTree.JCIdent || expr instanceof JCTree.JCFieldAccess) {
            String x = expr.toString();
            if (x.endsWith(".class")) {
                x = x.substring(0, x.length() - 6);
            } else {
                int idx = x.lastIndexOf(46);
                if (idx > -1) {
                    x = x.substring(idx + 1);
                }
            }
            return x;
        }
        return null;
    }
}

