/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rsa;

import de.flexiprovider.api.exceptions.BadPaddingException;
import de.flexiprovider.api.exceptions.IllegalBlockSizeException;
import de.flexiprovider.core.rsa.RSA_PKCS1_v1_5;

public class UnlimitedLengthRSA
extends RSA_PKCS1_v1_5 {
    public static final String NAME = "UnlimitedLengthRSA";

    protected byte[] messageDecrypt(byte[] input) throws IllegalBlockSizeException, BadPaddingException {
        int runs;
        if (input.length == this.cipherTextSize) {
            return super.messageDecrypt(input);
        }
        byte[] rv = null;
        if (input.length % this.cipherTextSize != 0) {
            throw new IllegalBlockSizeException("not enough bytes of ciphertext");
        }
        int i = runs = input.length / this.cipherTextSize;
        while (i > 0) {
            byte[] tmp;
            int splitter = i * this.cipherTextSize;
            if (i == runs) {
                tmp = new byte[this.cipherTextSize];
                System.arraycopy(input, splitter - this.cipherTextSize, tmp, 0, this.cipherTextSize);
                tmp = super.messageDecrypt(tmp);
                rv = new byte[(runs - 1) * this.maxPlainTextSize + tmp.length];
                System.arraycopy(tmp, 0, rv, rv.length - tmp.length, tmp.length);
            } else {
                tmp = new byte[this.cipherTextSize];
                System.arraycopy(input, splitter - this.cipherTextSize, tmp, 0, this.cipherTextSize);
                System.arraycopy(super.messageDecrypt(tmp), 0, rv, (i - 1) * this.maxPlainTextSize, this.maxPlainTextSize);
            }
            --i;
        }
        return rv;
    }

    protected byte[] messageEncrypt(byte[] input) throws BadPaddingException {
        if (input.length <= this.maxPlainTextSize) {
            return super.messageEncrypt(input);
        }
        int remainder = input.length % this.maxPlainTextSize;
        int runs = input.length / this.maxPlainTextSize;
        byte[] rv = new byte[(runs + (remainder == 0 ? 0 : 1)) * this.cipherTextSize];
        if (remainder != 0) {
            byte[] tmp = new byte[remainder];
            System.arraycopy(input, input.length - remainder, tmp, 0, remainder);
            tmp = super.messageEncrypt(tmp);
            System.arraycopy(tmp, 0, rv, runs * this.cipherTextSize, this.cipherTextSize);
        }
        int i = runs;
        while (i > 0) {
            int splitter = i * this.maxPlainTextSize;
            byte[] tmp = new byte[this.maxPlainTextSize];
            System.arraycopy(input, splitter - this.maxPlainTextSize, tmp, 0, this.maxPlainTextSize);
            tmp = super.messageEncrypt(tmp);
            System.arraycopy(tmp, 0, rv, (i - 1) * this.cipherTextSize, this.cipherTextSize);
            --i;
        }
        return rv;
    }

    public String getName() {
        return NAME;
    }

    protected void checkLength(int inLength) throws IllegalBlockSizeException {
        if (inLength <= 0) {
            throw new IllegalBlockSizeException("Negative input length");
        }
        if (this.opMode == 2 && inLength % this.cipherTextSize != 0) {
            throw new IllegalBlockSizeException("Illegal ciphertext length (expected " + this.cipherTextSize + " bytes, was " + inLength + " bytes).");
        }
    }
}

