/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.md;

import de.flexiprovider.common.util.LittleEndianConversions;
import de.flexiprovider.core.md.MDFamilyDigest;

public final class RIPEMD256
extends MDFamilyDigest {
    public static final String ALG_NAME = "RIPEMD256";
    public static final String OID = "1.3.36.3.2.3";
    private static final int[] initState = new int[]{1732584193, -271733879, -1732584194, 271733878, 1985229328, -19088744, -1985229329, 19088743};
    private static final int RIPEMD256_DIGEST_LENGTH = 32;
    private static final int[] KL = new int[]{0, 1518500249, 1859775393, -1894007588};
    private static final int[] KR = new int[]{1352829926, 1548603684, 1836072691, 0};
    private static final int[][] SL = new int[][]{{11, 14, 15, 12, 5, 8, 7, 9, 11, 13, 14, 15, 6, 7, 9, 8}, {7, 6, 8, 13, 11, 9, 7, 15, 7, 12, 15, 9, 11, 7, 13, 12}, {11, 13, 6, 7, 14, 9, 13, 15, 14, 8, 13, 6, 5, 12, 7, 5}, {11, 12, 14, 15, 14, 15, 9, 8, 9, 14, 5, 6, 8, 6, 5, 12}};
    private static final int[][] SR = new int[][]{{8, 9, 9, 11, 13, 15, 15, 5, 7, 7, 8, 11, 14, 14, 12, 6}, {9, 13, 15, 7, 12, 8, 9, 11, 7, 7, 12, 7, 6, 15, 13, 11}, {9, 7, 15, 11, 8, 6, 6, 14, 12, 13, 5, 14, 13, 13, 7, 5}, {15, 5, 8, 11, 14, 14, 6, 14, 6, 9, 12, 9, 12, 5, 15, 8}};

    public RIPEMD256() {
        super(32);
    }

    public void reset() {
        this.initMessageDigest(initState);
    }

    public synchronized byte[] digest() {
        byte[] digest = new byte[32];
        this.padMessageDigest();
        int i = 0;
        while (i < 8) {
            LittleEndianConversions.I2OSP(this.state[i], digest, 4 * i);
            ++i;
        }
        this.reset();
        return digest;
    }

    protected synchronized void processBlock() {
        int[] aL = new int[4];
        int[] aR = new int[4];
        int t = 0;
        System.arraycopy(this.state, 0, aL, 0, 4);
        System.arraycopy(this.state, 4, aR, 0, 4);
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 16) {
                t = MDFamilyDigest.rotateLeft(aL[0] + RIPEMD256.F(i, aL[1], aL[2], aL[3]) + this.x[RIPEMD256.selWordL(i, j)] + KL[i], SL[i][j]);
                aL[0] = aL[3];
                aL[3] = aL[2];
                aL[2] = aL[1];
                aL[1] = t;
                t = MDFamilyDigest.rotateLeft(aR[0] + RIPEMD256.F(3 - i, aR[1], aR[2], aR[3]) + this.x[RIPEMD256.selWordR(i, j)] + KR[i], SR[i][j]);
                aR[0] = aR[3];
                aR[3] = aR[2];
                aR[2] = aR[1];
                aR[1] = t;
                ++j;
            }
            t = aL[i];
            aL[i] = aR[i];
            aR[i] = t;
            ++i;
        }
        int k = 0;
        while (k < 4) {
            this.state[k] = this.state[k] + aL[k];
            this.state[k + 4] = this.state[k + 4] + aR[k];
            ++k;
        }
    }

    private static int selWordL(int i, int j) {
        int[] ro = new int[]{7, 4, 13, 1, 10, 6, 15, 3, 12, 0, 9, 5, 2, 14, 11, 8};
        if (i == 0) {
            return j;
        }
        int a = ro[j];
        int k = 1;
        while (k < i) {
            a = ro[a];
            ++k;
        }
        return a;
    }

    private static int selWordR(int i, int j) {
        int p = 9 * j + 5 & 0xF;
        return RIPEMD256.selWordL(i, p);
    }

    private static int F(int i, int u, int v, int w) {
        switch (i) {
            case 0: {
                return u ^ v ^ w;
            }
            case 1: {
                return u & v | ~u & w;
            }
            case 2: {
                return (u | ~v) ^ w;
            }
            case 3: {
                return u & w | v & ~w;
            }
        }
        return 0;
    }
}

