/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.md;

import de.flexiprovider.common.util.LittleEndianConversions;
import de.flexiprovider.core.md.MDFamilyDigest;

public final class MD4
extends MDFamilyDigest {
    public static final String ALG_NAME = "MD4";
    public static final String OID = "1.2.840.113549.2.4";
    private static final int[] initState = new int[]{1732584193, -271733879, -1732584194, 271733878};
    private static final int MD4_DIGEST_LENGTH = 16;
    private static final int S11 = 3;
    private static final int S12 = 7;
    private static final int S13 = 11;
    private static final int S14 = 19;
    private static final int S21 = 3;
    private static final int S22 = 5;
    private static final int S23 = 9;
    private static final int S24 = 13;
    private static final int S31 = 3;
    private static final int S32 = 9;
    private static final int S33 = 11;
    private static final int S34 = 15;

    public MD4() {
        super(16);
    }

    public void reset() {
        this.initMessageDigest(initState);
    }

    public synchronized byte[] digest() {
        byte[] digest = new byte[16];
        this.padMessageDigest();
        LittleEndianConversions.I2OSP(this.state[0], digest, 0);
        LittleEndianConversions.I2OSP(this.state[1], digest, 4);
        LittleEndianConversions.I2OSP(this.state[2], digest, 8);
        LittleEndianConversions.I2OSP(this.state[3], digest, 12);
        this.reset();
        return digest;
    }

    protected synchronized void processBlock() {
        int a = this.state[0];
        int b = this.state[1];
        int c = this.state[2];
        int d = this.state[3];
        a = MD4.FF(a, b, c, d, this.x[0], 3);
        d = MD4.FF(d, a, b, c, this.x[1], 7);
        c = MD4.FF(c, d, a, b, this.x[2], 11);
        b = MD4.FF(b, c, d, a, this.x[3], 19);
        a = MD4.FF(a, b, c, d, this.x[4], 3);
        d = MD4.FF(d, a, b, c, this.x[5], 7);
        c = MD4.FF(c, d, a, b, this.x[6], 11);
        b = MD4.FF(b, c, d, a, this.x[7], 19);
        a = MD4.FF(a, b, c, d, this.x[8], 3);
        d = MD4.FF(d, a, b, c, this.x[9], 7);
        c = MD4.FF(c, d, a, b, this.x[10], 11);
        b = MD4.FF(b, c, d, a, this.x[11], 19);
        a = MD4.FF(a, b, c, d, this.x[12], 3);
        d = MD4.FF(d, a, b, c, this.x[13], 7);
        c = MD4.FF(c, d, a, b, this.x[14], 11);
        b = MD4.FF(b, c, d, a, this.x[15], 19);
        a = MD4.GG(a, b, c, d, this.x[0], 3);
        d = MD4.GG(d, a, b, c, this.x[4], 5);
        c = MD4.GG(c, d, a, b, this.x[8], 9);
        b = MD4.GG(b, c, d, a, this.x[12], 13);
        a = MD4.GG(a, b, c, d, this.x[1], 3);
        d = MD4.GG(d, a, b, c, this.x[5], 5);
        c = MD4.GG(c, d, a, b, this.x[9], 9);
        b = MD4.GG(b, c, d, a, this.x[13], 13);
        a = MD4.GG(a, b, c, d, this.x[2], 3);
        d = MD4.GG(d, a, b, c, this.x[6], 5);
        c = MD4.GG(c, d, a, b, this.x[10], 9);
        b = MD4.GG(b, c, d, a, this.x[14], 13);
        a = MD4.GG(a, b, c, d, this.x[3], 3);
        d = MD4.GG(d, a, b, c, this.x[7], 5);
        c = MD4.GG(c, d, a, b, this.x[11], 9);
        b = MD4.GG(b, c, d, a, this.x[15], 13);
        a = MD4.HH(a, b, c, d, this.x[0], 3);
        d = MD4.HH(d, a, b, c, this.x[8], 9);
        c = MD4.HH(c, d, a, b, this.x[4], 11);
        b = MD4.HH(b, c, d, a, this.x[12], 15);
        a = MD4.HH(a, b, c, d, this.x[2], 3);
        d = MD4.HH(d, a, b, c, this.x[10], 9);
        c = MD4.HH(c, d, a, b, this.x[6], 11);
        b = MD4.HH(b, c, d, a, this.x[14], 15);
        a = MD4.HH(a, b, c, d, this.x[1], 3);
        d = MD4.HH(d, a, b, c, this.x[9], 9);
        c = MD4.HH(c, d, a, b, this.x[5], 11);
        b = MD4.HH(b, c, d, a, this.x[13], 15);
        a = MD4.HH(a, b, c, d, this.x[3], 3);
        d = MD4.HH(d, a, b, c, this.x[11], 9);
        c = MD4.HH(c, d, a, b, this.x[7], 11);
        b = MD4.HH(b, c, d, a, this.x[15], 15);
        this.state[0] = this.state[0] + a;
        this.state[1] = this.state[1] + b;
        this.state[2] = this.state[2] + c;
        this.state[3] = this.state[3] + d;
    }

    private static int F(int x, int y, int z) {
        return x & y | ~x & z;
    }

    private static int G(int x, int y, int z) {
        return x & y | x & z | y & z;
    }

    private static int H(int x, int y, int z) {
        return x ^ y ^ z;
    }

    private static int FF(int a, int b, int c, int d, int x, int s) {
        a += MD4.F(b, c, d) + x;
        a = MDFamilyDigest.rotateLeft(a, s);
        return a;
    }

    private static int GG(int a, int b, int c, int d, int x, int s) {
        a += MD4.G(b, c, d) + x + 1518500249;
        a = MDFamilyDigest.rotateLeft(a, s);
        return a;
    }

    private static int HH(int a, int b, int c, int d, int x, int s) {
        a += MD4.H(b, c, d) + x + 1859775393;
        a = MDFamilyDigest.rotateLeft(a, s);
        return a;
    }
}

