/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.kdf;

import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.util.ByteUtils;

public class PBKDF2ParameterSpec
implements AlgorithmParameterSpec {
    public static final String DEFAULT_PRF_OID = "1.3.6.1.5.5.8.1.2";
    private byte[] salt = null;
    private int iterationCount = 1000;
    private int keySize;

    public PBKDF2ParameterSpec(byte[] salt, int iterationCount, int keySize) {
        this.salt = ByteUtils.clone(salt);
        this.iterationCount = iterationCount;
        this.keySize = keySize;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public String toString() {
        String result = "salt             : " + ByteUtils.toHexString(this.salt);
        result = result + "\niteration count: " + this.iterationCount;
        result = result + "\nkey size       : " + this.keySize;
        result = result + "\nprf OID        : 1.3.6.1.5.5.8.1.2";
        return result;
    }
}

