/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.kdf;

import de.flexiprovider.api.KeyDerivation;
import de.flexiprovider.api.MessageDigest;
import de.flexiprovider.api.exceptions.DigestException;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.util.BigEndianConversions;
import de.flexiprovider.common.util.ByteUtils;
import de.flexiprovider.core.kdf.KDFParameterSpec;
import de.flexiprovider.core.md.SHA1;

public class KDF2
extends KeyDerivation {
    private MessageDigest md = new SHA1();
    private byte[] z;
    private byte[] sharedInfo;

    public void init(byte[] secret, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (secret == null) {
            throw new InvalidKeyException("null");
        }
        this.z = ByteUtils.clone(secret);
        if (params != null) {
            if (!(params instanceof KDFParameterSpec)) {
                throw new InvalidAlgorithmParameterException("unsupported type");
            }
            this.sharedInfo = ((KDFParameterSpec)params).getSharedInfo();
        }
    }

    public byte[] deriveKey(int keySize) {
        if (keySize < 0) {
            return null;
        }
        int mdLength = this.md.getDigestLength();
        int d = keySize / mdLength;
        int t = keySize % mdLength;
        byte[] result = new byte[keySize];
        int ctr = 1;
        try {
            int i = 0;
            while (i < d) {
                byte[] ctrBytes = BigEndianConversions.I2OSP(ctr);
                this.md.update(this.z);
                this.md.update(ctrBytes);
                this.md.update(this.sharedInfo);
                this.md.digest(result, i * mdLength, mdLength);
                ++i;
                ++ctr;
            }
        }
        catch (DigestException e) {
            throw new RuntimeException("internal error");
        }
        if (t != 0) {
            byte[] ctrBytes = BigEndianConversions.I2OSP(ctr);
            this.md.update(this.z);
            this.md.update(ctrBytes);
            this.md.update(this.sharedInfo);
            byte[] last = this.md.digest();
            System.arraycopy(last, 0, result, d * mdLength, t);
        }
        return result;
    }
}

