/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.elgamal.semanticallysecure;

import codec.CorruptedCodeException;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import codec.pkcs8.PrivateKeyInfo;
import codec.x509.SubjectPublicKeyInfo;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.InvalidKeySpecException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.KeyFactory;
import de.flexiprovider.api.keys.KeySpec;
import de.flexiprovider.api.keys.PrivateKey;
import de.flexiprovider.api.keys.PublicKey;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.core.elgamal.semanticallysecure.SSVElGamalPrivateKey;
import de.flexiprovider.core.elgamal.semanticallysecure.SSVElGamalPrivateKeySpec;
import de.flexiprovider.core.elgamal.semanticallysecure.SSVElGamalPublicKey;
import de.flexiprovider.core.elgamal.semanticallysecure.SSVElGamalPublicKeySpec;
import de.flexiprovider.pki.PKCS8EncodedKeySpec;
import de.flexiprovider.pki.X509EncodedKeySpec;

public class SSVElGamalKeyFactory
extends KeyFactory {
    static /* synthetic */ Class class$de$flexiprovider$pki$X509EncodedKeySpec;
    static /* synthetic */ Class class$de$flexiprovider$core$elgamal$semanticallysecure$SSVElGamalPublicKeySpec;
    static /* synthetic */ Class class$de$flexiprovider$pki$PKCS8EncodedKeySpec;
    static /* synthetic */ Class class$de$flexiprovider$core$elgamal$semanticallysecure$SSVElGamalPrivateKeySpec;

    public PrivateKey generatePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof SSVElGamalPrivateKeySpec) {
            return new SSVElGamalPrivateKey((SSVElGamalPrivateKeySpec)keySpec);
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            byte[] enc = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
            PrivateKeyInfo pki = new PrivateKeyInfo();
            try {
                ASN1Tools.derDecode(enc, (ASN1Type)pki);
            }
            catch (Exception ce) {
                throw new InvalidKeySpecException("Unable to decode PKCS8EncodedKeySpec.");
            }
            try {
                ASN1Sequence encPrivKey = (ASN1Sequence)pki.getDecodedRawKey();
                FlexiBigInt modulusp = ASN1Tools.getFlexiBigInt((ASN1Integer)encPrivKey.get(0));
                FlexiBigInt modulusq = ASN1Tools.getFlexiBigInt((ASN1Integer)encPrivKey.get(1));
                FlexiBigInt generator = ASN1Tools.getFlexiBigInt((ASN1Integer)encPrivKey.get(2));
                FlexiBigInt publicA = ASN1Tools.getFlexiBigInt((ASN1Integer)encPrivKey.get(3));
                FlexiBigInt a = ASN1Tools.getFlexiBigInt((ASN1Integer)encPrivKey.get(4));
                return new SSVElGamalPrivateKey(modulusp, modulusq, generator, publicA, a);
            }
            catch (CorruptedCodeException cce) {
                throw new InvalidKeySpecException("Unable to decode PKCS8EncodedKeySpec.");
            }
        }
        throw new InvalidKeySpecException("Unknown key specification: " + keySpec + ".");
    }

    public PublicKey generatePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof SSVElGamalPublicKeySpec) {
            return new SSVElGamalPublicKey((SSVElGamalPublicKeySpec)keySpec);
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            byte[] enc = ((X509EncodedKeySpec)keySpec).getEncoded();
            SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo();
            try {
                ASN1Tools.derDecode(enc, (ASN1Type)spki);
            }
            catch (Exception ce) {
                throw new InvalidKeySpecException("Unable to decode X509EncodedKeySpec.");
            }
            try {
                ASN1Sequence encPubKey = (ASN1Sequence)spki.getDecodedRawKey();
                FlexiBigInt modulusp = ASN1Tools.getFlexiBigInt((ASN1Integer)encPubKey.get(0));
                FlexiBigInt modulusq = ASN1Tools.getFlexiBigInt((ASN1Integer)encPubKey.get(1));
                FlexiBigInt generator = ASN1Tools.getFlexiBigInt((ASN1Integer)encPubKey.get(2));
                FlexiBigInt publicA = ASN1Tools.getFlexiBigInt((ASN1Integer)encPubKey.get(3));
                return new SSVElGamalPublicKey(modulusp, modulusq, generator, publicA);
            }
            catch (CorruptedCodeException cce) {
                throw new InvalidKeySpecException("Unable to decode X509EncodedKeySpec.");
            }
        }
        throw new InvalidKeySpecException("Unknown key specification: " + keySpec + ".");
    }

    public KeySpec getKeySpec(Key key, Class keySpec) throws InvalidKeySpecException {
        if (key instanceof SSVElGamalPublicKey) {
            if ((class$de$flexiprovider$pki$X509EncodedKeySpec == null ? (class$de$flexiprovider$pki$X509EncodedKeySpec = SSVElGamalKeyFactory.class$("de.flexiprovider.pki.X509EncodedKeySpec")) : class$de$flexiprovider$pki$X509EncodedKeySpec).isAssignableFrom(keySpec)) {
                return new X509EncodedKeySpec(key.getEncoded());
            }
            if ((class$de$flexiprovider$core$elgamal$semanticallysecure$SSVElGamalPublicKeySpec == null ? (class$de$flexiprovider$core$elgamal$semanticallysecure$SSVElGamalPublicKeySpec = SSVElGamalKeyFactory.class$("de.flexiprovider.core.elgamal.semanticallysecure.SSVElGamalPublicKeySpec")) : class$de$flexiprovider$core$elgamal$semanticallysecure$SSVElGamalPublicKeySpec).isAssignableFrom(keySpec)) {
                SSVElGamalPublicKey elGamalPubKey = (SSVElGamalPublicKey)key;
                return new SSVElGamalPublicKeySpec(elGamalPubKey.getModulusP(), elGamalPubKey.getModulusQ(), elGamalPubKey.getGenerator(), elGamalPubKey.getPublicA());
            }
        } else if (key instanceof SSVElGamalPrivateKey) {
            if ((class$de$flexiprovider$pki$PKCS8EncodedKeySpec == null ? (class$de$flexiprovider$pki$PKCS8EncodedKeySpec = SSVElGamalKeyFactory.class$("de.flexiprovider.pki.PKCS8EncodedKeySpec")) : class$de$flexiprovider$pki$PKCS8EncodedKeySpec).isAssignableFrom(keySpec)) {
                return new PKCS8EncodedKeySpec(key.getEncoded());
            }
            if ((class$de$flexiprovider$core$elgamal$semanticallysecure$SSVElGamalPrivateKeySpec == null ? (class$de$flexiprovider$core$elgamal$semanticallysecure$SSVElGamalPrivateKeySpec = SSVElGamalKeyFactory.class$("de.flexiprovider.core.elgamal.semanticallysecure.SSVElGamalPrivateKeySpec")) : class$de$flexiprovider$core$elgamal$semanticallysecure$SSVElGamalPrivateKeySpec).isAssignableFrom(keySpec)) {
                SSVElGamalPrivateKey elGamalPrivKey = (SSVElGamalPrivateKey)key;
                return new SSVElGamalPrivateKeySpec(elGamalPrivKey.getModulusP(), elGamalPrivKey.getModulusQ(), elGamalPrivKey.getGenerator(), elGamalPrivKey.getPublicA(), elGamalPrivKey.getA());
            }
        } else {
            throw new InvalidKeySpecException("Unsupported key type: " + key.getClass() + ".");
        }
        throw new InvalidKeySpecException("Unknown key specification: " + keySpec + ".");
    }

    public Key translateKey(Key key) throws InvalidKeyException {
        if (key instanceof SSVElGamalPublicKey || key instanceof SSVElGamalPrivateKey) {
            return key;
        }
        throw new InvalidKeyException("Unsupported key type.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

