/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.math.polynomials;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1SequenceOf;
import codec.asn1.DERDecoder;
import codec.asn1.DEREncoder;
import codec.asn1.Decoder;
import codec.asn1.Encoder;
import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.util.ASN1Tools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class GFP64Polynomial {
    private long[] f;
    private long[] poly;
    private int degree;
    private long p;
    private SecureRandom generator;
    static /* synthetic */ Class class$codec$asn1$ASN1Integer;

    public GFP64Polynomial(byte[] encoded) throws ASN1Exception, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(encoded);
        DERDecoder decoder = new DERDecoder((InputStream)in);
        ASN1Sequence gfpSequence = new ASN1Sequence(3);
        gfpSequence.add(new ASN1SequenceOf(class$codec$asn1$ASN1Integer == null ? (class$codec$asn1$ASN1Integer = GFP64Polynomial.class$("codec.asn1.ASN1Integer")) : class$codec$asn1$ASN1Integer));
        gfpSequence.add(new ASN1Integer());
        gfpSequence.add(new ASN1SequenceOf(class$codec$asn1$ASN1Integer == null ? (class$codec$asn1$ASN1Integer = GFP64Polynomial.class$("codec.asn1.ASN1Integer")) : class$codec$asn1$ASN1Integer));
        gfpSequence.decode((Decoder)decoder);
        in.close();
        ASN1SequenceOf asn1F = (ASN1SequenceOf)gfpSequence.get(0);
        ASN1Integer asn1P = (ASN1Integer)gfpSequence.get(1);
        ASN1SequenceOf asn1Poly = (ASN1SequenceOf)gfpSequence.get(2);
        long[] poly = new long[asn1Poly.size()];
        int i = poly.length - 1;
        while (i >= 0) {
            poly[i] = ASN1Tools.getFlexiBigInt((ASN1Integer)asn1Poly.get(i)).intValue();
            --i;
        }
        this.poly = poly;
        long[] f = new long[asn1F.size()];
        int i2 = this.degree = f.length - 1;
        while (i2 >= 0) {
            f[i2] = ASN1Tools.getFlexiBigInt((ASN1Integer)asn1F.get(i2)).intValue();
            --i2;
        }
        this.f = f;
        this.p = ASN1Tools.getFlexiBigInt(asn1P).intValue();
        this.generator = Registry.getSecureRandom();
    }

    public GFP64Polynomial(long[] f, long p, long[] poly) {
        this.f = f;
        this.degree = f.length - 1;
        this.p = p;
        this.poly = this.reduce(poly);
        this.generator = Registry.getSecureRandom();
    }

    public GFP64Polynomial(long[] f, long p, SecureRandom gen) {
        this.f = f;
        this.degree = f.length - 1;
        this.p = p;
        this.generator = Registry.getSecureRandom();
    }

    public GFP64Polynomial add(GFP64Polynomial gfp) {
        if (!this.paramEqual(gfp)) {
            return null;
        }
        long[] a = this.poly;
        long[] b = gfp.getPoly();
        if (a.length < b.length) {
            a = b;
            b = this.poly;
        }
        long[] result = new long[a.length];
        int i = a.length - 1;
        while (i >= 0) {
            result[i] = a[i];
            if (i < b.length) {
                result[i] = (result[i] + b[i]) % this.p;
            }
            --i;
        }
        return new GFP64Polynomial(this.f, this.p, this.reduce(result));
    }

    public void addToThis(GFP64Polynomial gfp) {
        this.poly = this.add(gfp).getPoly();
    }

    public boolean arrEqual(long[] arr1, long[] arr2) {
        if (arr1.length != arr2.length) {
            return false;
        }
        int i = arr1.length - 1;
        while (i >= 0) {
            if (arr1[i] != arr2[i]) {
                return false;
            }
            --i;
        }
        return true;
    }

    private long[] compress(long[] a) {
        return this.compress(a, this.p);
    }

    private long[] compress(long[] a, long p) {
        int i = a.length;
        while (i > 0) {
            if (a[i - 1] > p / 2L) {
                int n = i - 1;
                a[n] = a[n] - p;
            }
            --i;
        }
        return a;
    }

    public long[] getCompressed() {
        return this.compress(this.poly);
    }

    public boolean equals(Object obj) {
        if (obj.getClass().equals(this.getClass())) {
            GFP64Polynomial gfp = (GFP64Polynomial)obj;
            return this.p == gfp.getP() && this.arrEqual(this.f, gfp.getF()) && this.arrEqual(this.poly, gfp.getPoly());
        }
        return false;
    }

    private boolean fullEquals(GFP64Polynomial gfp) {
        return this.p == gfp.getP() && this.arrEqual(this.f, gfp.getF()) && this.arrEqual(this.poly, gfp.getPoly()) && this.generator.equals(gfp.getRandomizer());
    }

    public GFP64Polynomial generatePoly() {
        return this.generatePoly(0L);
    }

    public GFP64Polynomial generatePoly(long limit) {
        return this.generatePoly(limit, false);
    }

    public GFP64Polynomial generatePoly(long limit, boolean negative) {
        if (limit == 0L || limit > this.p) {
            limit = this.p;
        }
        long[] resPoly = new long[this.degree];
        int i = this.degree;
        while (i > 0) {
            resPoly[i - 1] = negative ? this.nextLong(limit * 2L - 1L) : this.nextLong(limit);
            --i;
        }
        if (negative) {
            return new GFP64Polynomial(this.f, this.p, this.compress(resPoly, limit * 2L - 1L));
        }
        return new GFP64Polynomial(this.f, this.p, this.reduceZeros(resPoly));
    }

    public byte[] getEncoded() throws ASN1Exception, IOException {
        ASN1Sequence gfpSequence = new ASN1Sequence(3);
        ASN1Integer asn1P = ASN1Tools.createInteger(new FlexiBigInt("" + this.p));
        ASN1SequenceOf asn1Poly = new ASN1SequenceOf(class$codec$asn1$ASN1Integer == null ? (class$codec$asn1$ASN1Integer = GFP64Polynomial.class$("codec.asn1.ASN1Integer")) : class$codec$asn1$ASN1Integer);
        ASN1SequenceOf asn1F = new ASN1SequenceOf(class$codec$asn1$ASN1Integer == null ? (class$codec$asn1$ASN1Integer = GFP64Polynomial.class$("codec.asn1.ASN1Integer")) : class$codec$asn1$ASN1Integer);
        int i = 0;
        while (i < this.poly.length) {
            asn1Poly.add(ASN1Tools.createInteger(new FlexiBigInt("" + this.poly[i])));
            ++i;
        }
        int i2 = 0;
        while (i2 < this.f.length) {
            asn1F.add(ASN1Tools.createInteger(new FlexiBigInt("" + this.f[i2])));
            ++i2;
        }
        gfpSequence.add(asn1F);
        gfpSequence.add(asn1P);
        gfpSequence.add(asn1Poly);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        gfpSequence.encode((Encoder)new DEREncoder((OutputStream)baos));
        byte[] res = baos.toByteArray();
        baos.flush();
        baos.close();
        return res;
    }

    public long[] getF() {
        return this.f;
    }

    public long getP() {
        return this.p;
    }

    public long[] getPoly() {
        return this.poly;
    }

    public SecureRandom getRandomizer() {
        return this.generator;
    }

    private long[] mod(long[] poly) {
        int i = poly.length;
        while (i > 0) {
            poly[i - 1] = poly[i - 1] < 0L ? poly[i - 1] % this.p + this.p : poly[i - 1] % this.p;
            --i;
        }
        return poly;
    }

    private long modMultiply(long p, long q) {
        return 0L;
    }

    public GFP64Polynomial multiply(GFP64Polynomial gfp) {
        if (!this.paramEqual(gfp)) {
            return null;
        }
        long[] a = this.poly;
        long[] z = gfp.getPoly();
        int degree = a.length + z.length - 1;
        long[] result = new long[degree];
        a = this.compress(a);
        z = this.compress(z);
        int i = a.length - 1;
        while (i >= 0) {
            int j = z.length - 1;
            while (j >= 0) {
                long l = a[i];
                long k = z[j];
                k = l * k % this.p;
                result[i + j] = ((long)((int)k) + result[i + j]) % this.p;
                --j;
            }
            --i;
        }
        return new GFP64Polynomial(this.f, this.p, this.reduce(result));
    }

    public Vector multiply(Vector k) {
        Vector<GFP64Polynomial> result = new Vector<GFP64Polynomial>();
        result.setSize(k.size());
        int i = k.size() - 1;
        while (i >= 0) {
            GFP64Polynomial next = (GFP64Polynomial)k.elementAt(i);
            result.setElementAt(this.multiply(next), i);
            --i;
        }
        return result;
    }

    public void multiplyToThis(GFP64Polynomial gfp) {
        this.poly = this.multiply(gfp).getPoly();
    }

    private long nextLong(long limit) {
        if (limit > Integer.MAX_VALUE) {
            return (long)(this.generator.nextInt() * this.generator.nextInt()) % limit;
        }
        return this.generator.nextInt((int)limit);
    }

    public boolean paramEqual(GFP64Polynomial gfp) {
        return this.p == gfp.getP() && this.arrEqual(this.f, gfp.getF());
    }

    public void print() {
        System.out.println("printing GFP");
        System.out.println("p: " + this.getP());
        System.out.println("f: " + this.printPoly(this.getF()));
        System.out.println("poly: " + this.printPoly(this.mod(this.getPoly())));
    }

    private String printPoly(long[] arr) {
        String result = "{";
        int i = arr.length - 1;
        while (i > 0) {
            result = result + arr[i] + ", ";
            --i;
        }
        result = result + arr[0] + "}";
        return result;
    }

    private long[] reduce(long[] z) {
        if ((z = this.reduceZeros(this.mod(z))).length < this.f.length) {
            return z;
        }
        int exp = z.length - this.f.length;
        long v = (-z[z.length - 1] + this.p) % this.p;
        int zSize = z.length - 1;
        long[] newZ = new long[zSize];
        int i = zSize;
        while (i > 0) {
            if (i <= exp) {
                newZ[i - 1] = z[i - 1];
            } else {
                FlexiBigInt l = new FlexiBigInt("" + this.f[i - exp - 1]);
                l.multiply(new FlexiBigInt("" + v)).mod(new FlexiBigInt("" + this.p));
                newZ[i - 1] = (l.longValue() + z[i - 1]) % this.p;
            }
            --i;
        }
        return this.reduce(newZ);
    }

    private long[] reduceZeros(long[] z) {
        int zSize = z.length;
        int i = z.length;
        while (i > 0) {
            if (z[i - 1] != 0L) break;
            --zSize;
            --i;
        }
        if (zSize == z.length) {
            return z;
        }
        long[] newZ = new long[zSize];
        System.arraycopy(z, 0, newZ, 0, zSize);
        return newZ;
    }

    public GFP64Polynomial subtract(GFP64Polynomial gfp) {
        if (!this.paramEqual(gfp)) {
            return null;
        }
        long[] b = gfp.getPoly();
        long[] a = this.poly;
        long[] result = new long[Math.max(a.length, b.length)];
        int i = result.length - 1;
        while (i >= 0) {
            result[i] = i < b.length && i < a.length ? (a[i] - b[i]) % this.p : (i < b.length ? -b[i] : a[i]);
            --i;
        }
        return new GFP64Polynomial(this.f, this.p, this.reduce(result));
    }

    public void subtractFromThis(GFP64Polynomial gfp) {
        this.poly = this.subtract(gfp).getPoly();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

