/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.math.polynomials;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1SequenceOf;
import codec.asn1.DERDecoder;
import codec.asn1.DEREncoder;
import codec.asn1.Decoder;
import codec.asn1.Encoder;
import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.common.util.IntUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class GFP32Polynomial {
    private int[] f;
    private int[] poly;
    private int degree;
    private int p;
    private SecureRandom generator;
    static /* synthetic */ Class class$codec$asn1$ASN1Integer;

    public GFP32Polynomial(byte[] encoded) throws ASN1Exception, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(encoded);
        DERDecoder decoder = new DERDecoder((InputStream)in);
        ASN1Sequence gfpSequence = new ASN1Sequence(3);
        gfpSequence.add(new ASN1SequenceOf(class$codec$asn1$ASN1Integer == null ? (class$codec$asn1$ASN1Integer = GFP32Polynomial.class$("codec.asn1.ASN1Integer")) : class$codec$asn1$ASN1Integer));
        gfpSequence.add(new ASN1Integer());
        gfpSequence.add(new ASN1SequenceOf(class$codec$asn1$ASN1Integer == null ? (class$codec$asn1$ASN1Integer = GFP32Polynomial.class$("codec.asn1.ASN1Integer")) : class$codec$asn1$ASN1Integer));
        gfpSequence.decode((Decoder)decoder);
        in.close();
        ASN1SequenceOf asn1F = (ASN1SequenceOf)gfpSequence.get(0);
        ASN1Integer asn1P = (ASN1Integer)gfpSequence.get(1);
        ASN1SequenceOf asn1Poly = (ASN1SequenceOf)gfpSequence.get(2);
        int[] poly = new int[asn1Poly.size()];
        int i = poly.length - 1;
        while (i >= 0) {
            poly[i] = ASN1Tools.getFlexiBigInt((ASN1Integer)asn1Poly.get(i)).intValue();
            --i;
        }
        this.poly = poly;
        int[] f = new int[asn1F.size()];
        int i2 = this.degree = f.length - 1;
        while (i2 >= 0) {
            f[i2] = ASN1Tools.getFlexiBigInt((ASN1Integer)asn1F.get(i2)).intValue();
            --i2;
        }
        this.f = f;
        this.p = ASN1Tools.getFlexiBigInt(asn1P).intValue();
        this.generator = Registry.getSecureRandom();
    }

    public GFP32Polynomial(int[] f, int p, int[] poly) {
        this.f = f;
        this.degree = f.length - 1;
        this.p = p;
        this.poly = this.reduce(poly);
        this.generator = Registry.getSecureRandom();
    }

    public GFP32Polynomial(int[] f, int p, SecureRandom gen) {
        this.f = f;
        this.degree = f.length - 1;
        this.p = p;
        this.generator = Registry.getSecureRandom();
    }

    public GFP32Polynomial add(GFP32Polynomial gfp) {
        if (!this.paramEqual(gfp)) {
            return null;
        }
        int[] a = this.poly;
        int[] b = gfp.getPoly();
        if (a.length < b.length) {
            a = b;
            b = this.poly;
        }
        int[] result = new int[a.length];
        int i = a.length - 1;
        while (i >= 0) {
            result[i] = a[i];
            if (i < b.length) {
                result[i] = (result[i] + b[i]) % this.p;
            }
            --i;
        }
        return new GFP32Polynomial(this.f, this.p, this.reduce(result));
    }

    public void addToThis(GFP32Polynomial gfp) {
        this.poly = this.add(gfp).getPoly();
    }

    private int[] compress(int[] a) {
        return this.compress(a, this.p);
    }

    private int[] compress(int[] a, int p) {
        int i = a.length;
        while (i > 0) {
            if (a[i - 1] > p / 2) {
                int n = i - 1;
                a[n] = a[n] - p;
            }
            --i;
        }
        return a;
    }

    public int[] compressThis() {
        return this.compress(this.poly);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof GFP32Polynomial)) {
            return false;
        }
        GFP32Polynomial otherPol = (GFP32Polynomial)other;
        return this.p == otherPol.p && IntUtils.equals(this.f, otherPol.f) && IntUtils.equals(this.compressThis(), otherPol.compressThis());
    }

    private boolean fullEquals(GFP32Polynomial gfp) {
        return this.p == gfp.getP() && IntUtils.equals(this.f, gfp.getF()) && IntUtils.equals(this.poly, gfp.getPoly()) && this.generator.equals(gfp.getRandomizer());
    }

    public GFP32Polynomial generatePoly() {
        return this.generatePoly(0);
    }

    public GFP32Polynomial generatePoly(int limit) {
        return this.generatePoly(limit, false);
    }

    public GFP32Polynomial generatePoly(int limit, boolean negative) {
        if (limit == 0 || limit > this.p) {
            limit = this.p;
        }
        int[] resPoly = new int[this.degree];
        int i = this.degree;
        while (i > 0) {
            resPoly[i - 1] = negative ? this.generator.nextInt(limit * 2 - 1) : this.generator.nextInt(limit);
            --i;
        }
        if (negative) {
            return new GFP32Polynomial(this.f, this.p, this.compress(resPoly, limit * 2 - 1));
        }
        return new GFP32Polynomial(this.f, this.p, this.reduceZeros(resPoly));
    }

    public byte[] getEncoded() throws ASN1Exception, IOException {
        ASN1Sequence gfpSequence = new ASN1Sequence(3);
        ASN1Integer asn1P = new ASN1Integer(this.p);
        ASN1SequenceOf asn1Poly = new ASN1SequenceOf(class$codec$asn1$ASN1Integer == null ? (class$codec$asn1$ASN1Integer = GFP32Polynomial.class$("codec.asn1.ASN1Integer")) : class$codec$asn1$ASN1Integer);
        ASN1SequenceOf asn1F = new ASN1SequenceOf(class$codec$asn1$ASN1Integer == null ? (class$codec$asn1$ASN1Integer = GFP32Polynomial.class$("codec.asn1.ASN1Integer")) : class$codec$asn1$ASN1Integer);
        int i = 0;
        while (i < this.poly.length) {
            asn1Poly.add(new ASN1Integer(this.poly[i]));
            ++i;
        }
        int i2 = 0;
        while (i2 < this.f.length) {
            asn1F.add(new ASN1Integer(this.f[i2]));
            ++i2;
        }
        gfpSequence.add(asn1F);
        gfpSequence.add(asn1P);
        gfpSequence.add(asn1Poly);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        gfpSequence.encode((Encoder)new DEREncoder((OutputStream)baos));
        byte[] res = baos.toByteArray();
        baos.flush();
        baos.close();
        return res;
    }

    public int[] getF() {
        return this.f;
    }

    public int getP() {
        return this.p;
    }

    public int[] getPoly() {
        return this.poly;
    }

    public SecureRandom getRandomizer() {
        return this.generator;
    }

    private int[] mod(int[] poly) {
        int i = poly.length;
        while (i > 0) {
            poly[i - 1] = poly[i - 1] < 0 ? poly[i - 1] % this.p + this.p : poly[i - 1] % this.p;
            --i;
        }
        return poly;
    }

    public GFP32Polynomial multiply(GFP32Polynomial gfp) {
        int[] a = this.poly;
        int[] z = gfp.getPoly();
        int degree = a.length + z.length - 1;
        int[] result = new int[degree];
        a = this.compress(a);
        z = this.compress(z);
        int i = a.length - 1;
        while (i >= 0) {
            int j = z.length - 1;
            while (j >= 0) {
                long l = a[i];
                long k = z[j];
                k = l * k % (long)this.p;
                result[i + j] = ((int)k + result[i + j]) % this.p;
                --j;
            }
            --i;
        }
        return new GFP32Polynomial(this.f, this.p, this.reduce(result));
    }

    public Vector multiply(Vector k) {
        Vector<GFP32Polynomial> result = new Vector<GFP32Polynomial>();
        result.setSize(k.size());
        int i = k.size() - 1;
        while (i >= 0) {
            GFP32Polynomial next = (GFP32Polynomial)k.elementAt(i);
            result.setElementAt(this.multiply(next), i);
            --i;
        }
        return result;
    }

    public void multiplyToThis(GFP32Polynomial gfp) {
        this.poly = this.multiply(gfp).getPoly();
    }

    public boolean paramEqual(GFP32Polynomial gfp) {
        return this.p == gfp.p && IntUtils.equals(this.f, gfp.f);
    }

    public void print() {
        System.out.println("printing GFP");
        System.out.println("p: " + this.getP());
        System.out.println("f: " + this.printPoly(this.getF()));
        System.out.println("poly: " + this.printPoly(this.mod(this.getPoly())));
    }

    private String printPoly(int[] arr) {
        String result = "{";
        int i = arr.length - 1;
        while (i > 0) {
            result = result + arr[i] + ", ";
            --i;
        }
        result = result + arr[0] + "}";
        return result;
    }

    private int[] reduce(int[] z) {
        if ((z = this.reduceZeros(this.mod(z))).length < this.f.length) {
            return z;
        }
        int exp = z.length - this.f.length;
        long v = (-z[z.length - 1] + this.p) % this.p;
        int zSize = z.length - 1;
        int[] newZ = new int[zSize];
        int i = zSize;
        while (i > 0) {
            if (i <= exp) {
                newZ[i - 1] = z[i - 1];
            } else {
                long l = this.f[i - exp - 1];
                long k = l * v % (long)this.p;
                newZ[i - 1] = ((int)k + z[i - 1]) % this.p;
            }
            --i;
        }
        return this.reduce(newZ);
    }

    private int[] reduceZeros(int[] z) {
        int zSize = z.length;
        int i = z.length;
        while (i > 0) {
            if (z[i - 1] != 0) break;
            --zSize;
            --i;
        }
        if (zSize == z.length) {
            return z;
        }
        int[] newZ = new int[zSize];
        System.arraycopy(z, 0, newZ, 0, zSize);
        return newZ;
    }

    public GFP32Polynomial subtract(GFP32Polynomial gfp) {
        if (!this.paramEqual(gfp)) {
            return null;
        }
        int[] b = gfp.getPoly();
        int[] a = this.poly;
        int[] result = new int[Math.max(a.length, b.length)];
        int i = result.length - 1;
        while (i >= 0) {
            result[i] = i < b.length && i < a.length ? (a[i] - b[i]) % this.p : (i < b.length ? -b[i] : a[i]);
            --i;
        }
        return new GFP32Polynomial(this.f, this.p, this.reduce(result));
    }

    public void subtractFromThis(GFP32Polynomial gfp) {
        this.poly = this.subtract(gfp).getPoly();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

