/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.api;

import de.flexiprovider.api.exceptions.RegistrationException;
import java.security.Provider;
import java.util.Hashtable;

public abstract class FlexiProvider
extends Provider {
    protected static final int CIPHER = 0;
    protected static final int MAC = 1;
    protected static final int MESSAGE_DIGEST = 2;
    protected static final int SECURE_RANDOM = 3;
    protected static final int SIGNATURE = 4;
    protected static final int ALG_PARAMS = 5;
    protected static final int ALG_PARAM_GENERATOR = 6;
    protected static final int SECRET_KEY_GENERATOR = 7;
    protected static final int KEY_PAIR_GENERATOR = 8;
    protected static final int SECRET_KEY_FACTORY = 9;
    protected static final int KEY_FACTORY = 10;
    protected static final int KEY_AGREEMENT = 11;
    private static final String[] prefixes = new String[]{"Cipher.", "Mac.", "MessageDigest.", "SecureRandom.", "Signature.", "AlgorithmParameters.", "AlgorithmParameterGenerator.", "KeyGenerator.", "KeyPairGenerator.", "SecretKeyFactory.", "KeyFactory.", "KeyAgreement."};
    private static final Class[] algClasses = new Class[]{class$javax$crypto$CipherSpi == null ? (class$javax$crypto$CipherSpi = FlexiProvider.class$("javax.crypto.CipherSpi")) : class$javax$crypto$CipherSpi, class$javax$crypto$MacSpi == null ? (class$javax$crypto$MacSpi = FlexiProvider.class$("javax.crypto.MacSpi")) : class$javax$crypto$MacSpi, class$java$security$MessageDigestSpi == null ? (class$java$security$MessageDigestSpi = FlexiProvider.class$("java.security.MessageDigestSpi")) : class$java$security$MessageDigestSpi, class$java$security$SecureRandomSpi == null ? (class$java$security$SecureRandomSpi = FlexiProvider.class$("java.security.SecureRandomSpi")) : class$java$security$SecureRandomSpi, class$java$security$SignatureSpi == null ? (class$java$security$SignatureSpi = FlexiProvider.class$("java.security.SignatureSpi")) : class$java$security$SignatureSpi, class$java$security$AlgorithmParametersSpi == null ? (class$java$security$AlgorithmParametersSpi = FlexiProvider.class$("java.security.AlgorithmParametersSpi")) : class$java$security$AlgorithmParametersSpi, class$java$security$AlgorithmParameterGeneratorSpi == null ? (class$java$security$AlgorithmParameterGeneratorSpi = FlexiProvider.class$("java.security.AlgorithmParameterGeneratorSpi")) : class$java$security$AlgorithmParameterGeneratorSpi, class$javax$crypto$KeyGeneratorSpi == null ? (class$javax$crypto$KeyGeneratorSpi = FlexiProvider.class$("javax.crypto.KeyGeneratorSpi")) : class$javax$crypto$KeyGeneratorSpi, class$java$security$KeyPairGeneratorSpi == null ? (class$java$security$KeyPairGeneratorSpi = FlexiProvider.class$("java.security.KeyPairGeneratorSpi")) : class$java$security$KeyPairGeneratorSpi, class$javax$crypto$SecretKeyFactorySpi == null ? (class$javax$crypto$SecretKeyFactorySpi = FlexiProvider.class$("javax.crypto.SecretKeyFactorySpi")) : class$javax$crypto$SecretKeyFactorySpi, class$java$security$KeyFactorySpi == null ? (class$java$security$KeyFactorySpi = FlexiProvider.class$("java.security.KeyFactorySpi")) : class$java$security$KeyFactorySpi, class$javax$crypto$KeyAgreementSpi == null ? (class$javax$crypto$KeyAgreementSpi = FlexiProvider.class$("javax.crypto.KeyAgreementSpi")) : class$javax$crypto$KeyAgreementSpi};
    static /* synthetic */ Class class$javax$crypto$CipherSpi;
    static /* synthetic */ Class class$javax$crypto$MacSpi;
    static /* synthetic */ Class class$java$security$MessageDigestSpi;
    static /* synthetic */ Class class$java$security$SecureRandomSpi;
    static /* synthetic */ Class class$java$security$SignatureSpi;
    static /* synthetic */ Class class$java$security$AlgorithmParametersSpi;
    static /* synthetic */ Class class$java$security$AlgorithmParameterGeneratorSpi;
    static /* synthetic */ Class class$javax$crypto$KeyGeneratorSpi;
    static /* synthetic */ Class class$java$security$KeyPairGeneratorSpi;
    static /* synthetic */ Class class$javax$crypto$SecretKeyFactorySpi;
    static /* synthetic */ Class class$java$security$KeyFactorySpi;
    static /* synthetic */ Class class$javax$crypto$KeyAgreementSpi;

    protected FlexiProvider(String name, double version, String info) {
        super(name, version, info);
    }

    protected void add(int type, Class algClass, String algName) throws RegistrationException {
        this.add(type, algClass, new String[]{algName});
    }

    protected void add(int type, Class algClass, String[] algNames) throws RegistrationException {
        String prefix = FlexiProvider.getPrefix(type);
        if (prefix == null || algClass == null || algNames == null || algNames.length == 0) {
            return;
        }
        Class expClass = algClasses[type];
        if (!expClass.isAssignableFrom(algClass)) {
            throw new RegistrationException("expected and actual algorithm types do not match");
        }
        this.put(prefix + algNames[0], algClass.getName());
        int i = 1;
        while (i < algNames.length) {
            this.put("Alg.Alias." + prefix + algNames[i], algNames[0]);
            ++i;
        }
    }

    protected void addReverseOID(int type, String algName, String oid) throws RegistrationException {
        String prefix = FlexiProvider.getPrefix(type);
        if (prefix == null) {
            return;
        }
        Object alg = ((Hashtable)this).get(prefix + algName);
        if (alg == null) {
            throw new RegistrationException("no such algorithm: " + algName);
        }
        this.put("Alg.Alias." + prefix + "OID." + oid, algName);
    }

    private static String getPrefix(int type) {
        if (type > prefixes.length) {
            return null;
        }
        return prefixes[type];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

