/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.saferplus;

import de.flexiprovider.api.BlockCipher;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeySpec;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.saferplus.SAFERPlusKey;

public class SAFERPlus
extends BlockCipher {
    public static final String ALG_NAME = "SAFER+";
    private static final int blockSize = 16;
    private static final int[] firstSet = new int[]{0, 3, 4, 7, 8, 11, 12, 15};
    private static final int[] secondSet = new int[]{1, 2, 5, 6, 9, 10, 13, 14};
    private static int[] expTab = new int[257];
    private static int[] logTab = new int[257];
    private int[] actualBlock = new int[16];
    private int[] userKey;
    private int[] keyReg;
    private int[][] subKeys;
    private int[] tmpBlock = new int[16];
    private static int[][] bias = new int[33][16];
    private static int[][] matrixM = new int[][]{{2, 1, 1, 1, 4, 2, 1, 1, 2, 2, 4, 2, 4, 4, 16, 8}, {2, 1, 1, 1, 4, 2, 1, 1, 1, 1, 2, 1, 2, 2, 8, 4}, {1, 1, 4, 2, 2, 2, 4, 2, 16, 8, 4, 4, 2, 1, 1, 1}, {1, 1, 4, 2, 1, 1, 2, 1, 8, 4, 2, 2, 2, 1, 1, 1}, {16, 8, 2, 2, 4, 2, 4, 4, 1, 1, 4, 2, 1, 1, 2, 1}, {8, 4, 1, 1, 2, 1, 2, 2, 1, 1, 4, 2, 1, 1, 2, 1}, {2, 2, 4, 2, 4, 4, 16, 8, 2, 1, 1, 1, 4, 2, 1, 1}, {1, 1, 2, 1, 2, 2, 8, 4, 2, 1, 1, 1, 4, 2, 1, 1}, {4, 2, 4, 4, 16, 8, 2, 2, 1, 1, 2, 1, 1, 1, 4, 2}, {2, 1, 2, 2, 8, 4, 1, 1, 1, 1, 2, 1, 1, 1, 4, 2}, {4, 4, 16, 8, 1, 1, 2, 1, 4, 2, 1, 1, 4, 2, 2, 2}, {2, 2, 8, 4, 1, 1, 2, 1, 4, 2, 1, 1, 2, 1, 1, 1}, {1, 1, 2, 1, 1, 1, 4, 2, 4, 4, 16, 8, 2, 2, 4, 2}, {1, 1, 2, 1, 1, 1, 4, 2, 2, 2, 8, 4, 1, 1, 2, 1}, {4, 2, 1, 1, 2, 1, 1, 1, 4, 2, 2, 2, 16, 8, 4, 4}, {4, 2, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 8, 4, 2, 2}};
    private static int[][] matrixInvM = new int[][]{{2, -4, 1, -2, 1, -1, 2, -2, 1, -1, 1, -1, 4, -8, 1, -2}, {-2, 4, -2, 4, -1, 1, -4, 4, -1, 1, -2, 2, -8, 16, -1, 2}, {1, -2, 1, -2, 2, -2, 1, -1, 1, -1, 1, -1, 2, -4, 4, -8}, {-2, 4, -1, 2, -4, 4, -1, 1, -2, 2, -1, 1, -2, 4, -8, 16}, {1, -2, 2, -2, 1, -1, 1, -1, 1, -1, 4, -8, 1, -2, 2, -4}, {-1, 2, -4, 4, -1, 1, -2, 2, -1, 1, -8, 16, -2, 4, -2, 4}, {4, -8, 1, -1, 1, -1, 1, -1, 2, -2, 2, -4, 1, -2, 1, -2}, {-8, 16, -1, 1, -2, 2, -1, 1, -4, 4, -2, 4, -1, 2, -2, 4}, {2, -2, 1, -1, 1, -2, 2, -4, 4, -8, 1, -2, 1, -1, 1, -1}, {-4, 4, -1, 1, -2, 4, -2, 4, -8, 16, -1, 2, -2, 2, -1, 1}, {1, -1, 1, -1, 1, -2, 4, -8, 2, -4, 1, -2, 1, -1, 2, -2}, {-1, 1, -2, 2, -1, 2, -8, 16, -2, 4, -2, 4, -1, 1, -4, 4}, {1, -1, 2, -4, 4, -8, 1, -2, 1, -2, 1, -1, 2, -2, 1, -1}, {-2, 2, -2, 4, -8, 16, -1, 2, -2, 4, -1, 1, -4, 4, -1, 1}, {1, -1, 4, -8, 2, -4, 1, -2, 1, -2, 2, -2, 1, -1, 1, -1}, {-1, 1, -8, 16, -2, 4, -2, 4, -1, 2, -4, 4, -1, 1, -2, 2}};

    public SAFERPlus() {
        this.makeExpTab();
        this.makeLogTab();
        this.fillBias();
    }

    public String getName() {
        return ALG_NAME;
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        if (!(key instanceof SAFERPlusKey) && !(key instanceof SecretKeySpec)) {
            throw new InvalidKeyException("not a SAFER+ key.");
        }
        int keyLen = key.getEncoded().length;
        if (keyLen != 16 && keyLen != 24 && keyLen != 32) {
            throw new InvalidKeyException("key size not valid for SAFER+.");
        }
        return keyLen << 3;
    }

    public int getCipherBlockSize() {
        return 16;
    }

    protected void initCipherEncrypt(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException {
        if (!(key instanceof SAFERPlusKey)) {
            throw new InvalidKeyException("not a SAFER+ key.");
        }
        byte[] tmpArray = key.getEncoded();
        this.userKey = new int[tmpArray.length];
        int i = 0;
        while (i < tmpArray.length) {
            this.userKey[i] = tmpArray[i] + 256 & 0xFF;
            ++i;
        }
        this.createSubKeys(this.userKey.length + 1);
    }

    protected void initCipherDecrypt(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException {
        this.initCipherEncrypt(key, params);
    }

    protected void singleBlockEncrypt(byte[] in, int inOffset, byte[] out, int outOffset) {
        int round = 1;
        int maxRounds = this.userKey.length >> 1;
        int i = 0;
        while (i < 16) {
            this.actualBlock[i] = in[inOffset + i] & 0xFF;
            ++i;
        }
        while (round <= maxRounds) {
            this.mod2Trans(firstSet, (round << 1) - 2);
            this.mod256Add(secondSet, (round << 1) - 2);
            this.powerTrans(firstSet);
            this.logTrans(secondSet);
            this.mod256Add(firstSet, (round << 1) - 1);
            this.mod2Trans(secondSet, (round << 1) - 1);
            this.matrixTrans();
            ++round;
        }
        this.mod2Trans(firstSet, maxRounds << 1);
        this.mod256Add(secondSet, maxRounds << 1);
        int i2 = 0;
        while (i2 < 16) {
            out[outOffset + i2] = (byte)this.actualBlock[i2];
            ++i2;
        }
    }

    protected void singleBlockDecrypt(byte[] in, int inOffset, byte[] out, int outOffset) {
        int round = 1;
        this.actualBlock = new int[16];
        int maxRounds = this.userKey.length >> 1;
        int i = 0;
        while (i < 16) {
            this.actualBlock[i] = in[inOffset + i] & 0xFF;
            ++i;
        }
        this.mod2Trans(firstSet, maxRounds << 1);
        this.mod256Sub(secondSet, maxRounds << 1);
        while (round <= maxRounds) {
            this.invMatrixTrans();
            this.mod256Sub(firstSet, (maxRounds - round << 1) + 1);
            this.mod2Trans(secondSet, (maxRounds - round << 1) + 1);
            this.logTrans(firstSet);
            this.powerTrans(secondSet);
            this.mod2Trans(firstSet, maxRounds - round << 1);
            this.mod256Sub(secondSet, maxRounds - round << 1);
            ++round;
        }
        int i2 = 0;
        while (i2 < 16) {
            out[outOffset + i2] = (byte)this.actualBlock[i2];
            ++i2;
        }
    }

    private void makeExpTab() {
        SAFERPlus.expTab[0] = 1;
        int i = 1;
        while (i < 256) {
            SAFERPlus.expTab[i] = 45 * expTab[i - 1] % 257;
            ++i;
        }
        SAFERPlus.expTab[128] = 0;
    }

    private void makeLogTab() {
        int i = 0;
        while (i < 256) {
            SAFERPlus.logTab[SAFERPlus.expTab[i]] = i;
            ++i;
        }
    }

    private void fillBias() {
        int j;
        int i = 2;
        while (i <= 17) {
            j = 1;
            while (j <= 16) {
                SAFERPlus.bias[i - 1][j - 1] = expTab[expTab[17 * i + j & 0xFF]];
                ++j;
            }
            ++i;
        }
        i = 18;
        while (i <= 33) {
            j = 1;
            while (j <= 16) {
                SAFERPlus.bias[i - 1][j - 1] = expTab[17 * i + j & 0xFF];
                ++j;
            }
            ++i;
        }
    }

    private void createSubKeys(int length) {
        this.keyReg = new int[length];
        this.subKeys = new int[length][16];
        int parity = 0;
        int i = 0;
        while (i < 16) {
            this.subKeys[0][i] = this.userKey[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < length - 1) {
            this.keyReg[i2] = this.userKey[i2];
            parity ^= this.userKey[i2];
            ++i2;
        }
        this.keyReg[length - 1] = parity;
        this.bitRotate(length);
        int j = 1;
        while (j < length) {
            int i3 = 0;
            while (i3 < 16) {
                this.subKeys[j][i3] = bias[j][i3] + this.keyReg[(j + i3) % length] & 0xFF;
                ++i3;
            }
            this.bitRotate(length);
            ++j;
        }
    }

    private void bitRotate(int l) {
        int highMask = 1792;
        int i = 0;
        while (i < l) {
            int n = i;
            this.keyReg[n] = this.keyReg[n] << 3;
            int lowByte = (highMask & this.keyReg[i]) >>> 8;
            this.keyReg[i] = (lowByte | this.keyReg[i]) & 0xFF;
            ++i;
        }
    }

    private void mod2Trans(int[] indexSet, int keyNum) {
        int i = 0;
        while (i < 8) {
            int n = indexSet[i];
            this.actualBlock[n] = this.actualBlock[n] ^ this.subKeys[keyNum][indexSet[i]];
            ++i;
        }
    }

    private void mod256Add(int[] indexSet, int keyNum) {
        int i = 0;
        while (i < 8) {
            this.actualBlock[indexSet[i]] = this.actualBlock[indexSet[i]] + this.subKeys[keyNum][indexSet[i]] & 0xFF;
            ++i;
        }
    }

    private void mod256Sub(int[] indexSet, int keyNum) {
        int i = 0;
        while (i < 8) {
            this.actualBlock[indexSet[i]] = this.actualBlock[indexSet[i]] - this.subKeys[keyNum][indexSet[i]] & 0xFF;
            ++i;
        }
    }

    private void powerTrans(int[] set) {
        int i = 0;
        while (i < 8) {
            this.actualBlock[set[i]] = expTab[this.actualBlock[set[i]]];
            ++i;
        }
    }

    private void logTrans(int[] set) {
        int i = 0;
        while (i < 8) {
            this.actualBlock[set[i]] = logTab[this.actualBlock[set[i]]];
            ++i;
        }
    }

    private void invMatrixTrans() {
        int i = 0;
        while (i < 16) {
            this.tmpBlock[i] = 0;
            int j = 0;
            while (j < 16) {
                int n = i;
                this.tmpBlock[n] = this.tmpBlock[n] + matrixInvM[i][j] * this.actualBlock[j];
                ++j;
            }
            int n = i++;
            this.tmpBlock[n] = this.tmpBlock[n] & 0xFF;
        }
        i = 0;
        while (i < 16) {
            this.actualBlock[i] = this.tmpBlock[i];
            ++i;
        }
    }

    private void matrixTrans() {
        int i = 0;
        while (i < 16) {
            this.tmpBlock[i] = 0;
            int j = 0;
            while (j < 16) {
                int n = i;
                this.tmpBlock[n] = this.tmpBlock[n] + matrixM[i][j] * this.actualBlock[j];
                ++j;
            }
            int n = i++;
            this.tmpBlock[n] = this.tmpBlock[n] & 0xFF;
        }
        i = 0;
        while (i < 16) {
            this.actualBlock[i] = this.tmpBlock[i];
            ++i;
        }
    }
}

