/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rsa;

import de.flexiprovider.api.AsymmetricBlockCipher;
import de.flexiprovider.api.MessageDigest;
import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.InvalidParameterException;
import de.flexiprovider.api.exceptions.InvalidParameterSpecException;
import de.flexiprovider.api.exceptions.NoSuchAlgorithmException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.api.parameters.AlgorithmParameters;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.core.rsa.PKCS1Exception;
import de.flexiprovider.core.rsa.PKCS1Operations;
import de.flexiprovider.core.rsa.RSAOAEPParameterSpec;
import de.flexiprovider.core.rsa.RSAOAEPParameters;
import de.flexiprovider.core.rsa.interfaces.RSAPrivateCrtKey;
import de.flexiprovider.core.rsa.interfaces.RSAPrivateKey;
import de.flexiprovider.core.rsa.interfaces.RSAPublicKey;
import java.io.IOException;

public class RSA_PKCS1_v2_1
extends AsymmetricBlockCipher {
    public static final String OID = "1.2.840.113549.1.1.7";
    private SecureRandom sr;
    private RSAPublicKey pubKey;
    private RSAPrivateKey privKey;
    private MessageDigest md;

    public String getName() {
        return "RSA_PKCS1_v2_1";
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        if (key instanceof RSAPrivateKey) {
            return ((RSAPrivateKey)key).getN().bitLength();
        }
        if (key instanceof RSAPublicKey) {
            return ((RSAPublicKey)key).getN().bitLength();
        }
        throw new InvalidKeyException("RSA_PKCS1_v2_1: engineGetKeySize() - the key is not suitable for RSA the algorithm!");
    }

    protected void initCipherEncrypt(Key key, AlgorithmParameterSpec params, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof RSAPublicKey)) {
            throw new InvalidKeyException("RSA_PKCS1_v2_1: initEncrypt - RSASSA-OAEP needs an RSAPublicKey for encrypting data.");
        }
        if (params == null) {
            this.initParams(new RSAOAEPParameterSpec());
        } else if (params instanceof RSAOAEPParameterSpec) {
            this.initParams((RSAOAEPParameterSpec)params);
        } else {
            throw new InvalidParameterException("RSA_PKCS1_v2_1: initEncrypt - Invalid parameter specifaction!");
        }
        this.pubKey = (RSAPublicKey)key;
        this.privKey = null;
        this.sr = secureRandom;
        this.cipherTextSize = this.pubKey.getN().bitLength() + 7 >> 3;
        this.maxPlainTextSize = this.cipherTextSize - (this.md.getDigestLength() << 1) - 2;
        if (this.maxPlainTextSize <= 0) {
            throw new InvalidParameterException("RSA_PKCS1_v2_1: initEncrypt - Please use larger modulus!");
        }
    }

    protected void initCipherDecrypt(Key key, AlgorithmParameterSpec params) throws InvalidKeyException {
        if (params == null) {
            this.initParams(new RSAOAEPParameterSpec());
        } else if (params instanceof RSAOAEPParameterSpec) {
            this.initParams((RSAOAEPParameterSpec)params);
        } else {
            throw new InvalidParameterException("RSA_PKCS1_v2_1: initDecrypt - Invalid parameter specifaction!");
        }
        if (!(key instanceof RSAPrivateCrtKey) && !(key instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("RSA_PKCS1_v2_1: initDecrypt - RSASSA-OAEP needs a RSAPublicKey for encrypting data.");
        }
        this.privKey = (RSAPrivateKey)key;
        this.pubKey = null;
        this.sr = Registry.getSecureRandom();
        this.cipherTextSize = this.privKey.getN().bitLength() + 7 >> 3;
        this.maxPlainTextSize = this.cipherTextSize - (this.md.getDigestLength() << 1) - 2;
        if (this.maxPlainTextSize <= 0) {
            throw new InvalidParameterException("RSA_PKCS1_v2_1: initDecrypt - Please use larger modulus!");
        }
    }

    private void initParams(RSAOAEPParameterSpec paramSpec) {
        byte[] paramBytes;
        String mdOID = paramSpec.getMD();
        try {
            this.md = Registry.getMessageDigest(mdOID);
            RSAOAEPParameters params = new RSAOAEPParameters();
            ((AlgorithmParameters)params).init(paramSpec);
            paramBytes = ((AlgorithmParameters)params).getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("did not find message digest '" + mdOID + "'");
        }
        catch (InvalidParameterSpecException e) {
            throw new RuntimeException("internal error");
        }
        catch (IOException e) {
            throw new RuntimeException("internal error");
        }
        this.md.update(paramBytes);
    }

    protected byte[] messageEncrypt(byte[] input) {
        byte[] C = null;
        byte[] EM = null;
        byte[] M = input;
        FlexiBigInt c = null;
        FlexiBigInt m = null;
        try {
            EM = PKCS1Operations.EME_OAEP_ENCODE(M, null, this.cipherTextSize, this.md, this.sr);
            m = PKCS1Operations.OS2IP(EM);
            c = PKCS1Operations.RSAEP(this.pubKey, m);
            C = PKCS1Operations.I2OSP(c, this.cipherTextSize);
        }
        catch (PKCS1Exception pkcs1e) {
            throw new RuntimeException("RSA_PKCS1_v2_1: messageEncryptInternal error occured during PKCS#1 / RSASSA-OAEP encryption.");
        }
        return C;
    }

    protected byte[] messageDecrypt(byte[] input) {
        if (input.length != this.cipherTextSize) {
            throw new RuntimeException("RSA_PKCS1_v2_1: messageDecrypt - decryption error");
        }
        if (this.cipherTextSize < (this.md.getDigestLength() << 1) + 2) {
            new RuntimeException("RSA_PKCS1_v2_1: messageDecrypt - decryption error");
        }
        byte[] EM = null;
        byte[] M = null;
        FlexiBigInt c = PKCS1Operations.OS2IP(input);
        FlexiBigInt m = null;
        try {
            m = PKCS1Operations.RSADP(this.privKey, c);
            EM = PKCS1Operations.I2OSP(m, this.cipherTextSize);
            M = PKCS1Operations.EME_OAEP_DECODE(EM, null, this.cipherTextSize, this.md);
        }
        catch (PKCS1Exception ex) {
            throw new RuntimeException("RSA_PKCS1_v2_1: PKCS1Exception - " + ex.getMessage());
        }
        return M;
    }
}

