/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rsa;

import codec.asn1.ASN1Null;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.core.rsa.RSAPrivateKeySpec;

public class RSAPrivateKey
extends de.flexiprovider.core.rsa.interfaces.RSAPrivateKey {
    private FlexiBigInt n;
    private FlexiBigInt d;

    protected RSAPrivateKey(FlexiBigInt n, FlexiBigInt d) {
        this.n = n;
        this.d = d;
    }

    protected RSAPrivateKey(RSAPrivateKeySpec keySpec) {
        this(keySpec.getN(), keySpec.getD());
    }

    public FlexiBigInt getN() {
        return this.n;
    }

    public FlexiBigInt getD() {
        return this.d;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof RSAPrivateKey)) {
            return false;
        }
        RSAPrivateKey otherKey = (RSAPrivateKey)other;
        return this.n.equals(otherKey.n) && this.d.equals(otherKey.d);
    }

    public int hashCode() {
        return this.n.hashCode() + this.d.hashCode();
    }

    public String toString() {
        return "n = 0x" + this.n.toString(16) + "\n" + "d = 0x" + this.d.toString(16) + "\n";
    }

    protected ASN1ObjectIdentifier getOID() {
        return new ASN1ObjectIdentifier("1.2.840.113549.1.1.1");
    }

    protected ASN1Type getAlgParams() {
        return new ASN1Null();
    }

    protected byte[] getKeyData() {
        ASN1Sequence keyData = new ASN1Sequence();
        keyData.add(ASN1Tools.createInteger(this.n));
        keyData.add(ASN1Tools.createInteger(this.d));
        return ASN1Tools.derEncode((ASN1Type)keyData);
    }
}

