/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.mprsa;

import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.core.mprsa.MpRSAPrivateKey;
import de.flexiprovider.core.mprsa.RSAOtherPrimeInfo;
import de.flexiprovider.core.rsa.PKCS1Exception;
import de.flexiprovider.core.rsa.interfaces.RSAPublicKey;

public final class MpRSAOperations {
    private static final PKCS1Exception encryptionError = new PKCS1Exception("encryption error");
    private static final PKCS1Exception decryptionError = new PKCS1Exception("decryption error");

    private MpRSAOperations() {
    }

    static FlexiBigInt MpRSAEP(RSAPublicKey pubKey, FlexiBigInt m) throws PKCS1Exception {
        FlexiBigInt n = pubKey.getN();
        FlexiBigInt e = pubKey.getE();
        if (m.compareTo(n) > 0 || m.signum() < 0) {
            throw encryptionError;
        }
        if (e.equals(FlexiBigInt.valueOf(3L))) {
            return m.multiply(m).mod(n).multiply(m).mod(n);
        }
        return m.modPow(e, n);
    }

    static FlexiBigInt MpRSADP(MpRSAPrivateKey privKey, FlexiBigInt c) throws PKCS1Exception {
        FlexiBigInt n = privKey.getN();
        FlexiBigInt p = privKey.getP();
        FlexiBigInt q = privKey.getQ();
        FlexiBigInt dP = privKey.getDp();
        FlexiBigInt dQ = privKey.getDq();
        FlexiBigInt qInv = privKey.getCRTCoeff();
        if (c.compareTo(n) > 0 || c.signum() < 0) {
            throw decryptionError;
        }
        if (privKey.getOtherPrimeInfo() == null) {
            throw decryptionError;
        }
        RSAOtherPrimeInfo[] otherP = privKey.getOtherPrimeInfo();
        int k = otherP.length;
        FlexiBigInt m1 = c.remainder(p).modPow(dP, p);
        FlexiBigInt m2 = c.remainder(q).modPow(dQ, q);
        FlexiBigInt h = qInv.multiply(m1.subtract(m2)).mod(p);
        FlexiBigInt m = h.multiply(q).add(m2);
        FlexiBigInt R = p.multiply(q);
        int i = 0;
        while (i < k) {
            FlexiBigInt ri = otherP[i].getPrime();
            FlexiBigInt mdi = otherP[i].getExponent();
            FlexiBigInt ti = otherP[i].getCrtCoefficient();
            mdi = c.remainder(ri).modPow(mdi, ri);
            h = ti.multiply(mdi.subtract(m)).mod(ri);
            m = h.multiply(R).add(m);
            R = R.multiply(ri);
            ++i;
        }
        return m;
    }
}

