/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.elgamal;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.keys.KeyPair;
import de.flexiprovider.api.keys.KeyPairGenerator;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.math.IntegerFunctions;
import de.flexiprovider.core.elgamal.ElGamalKeyGenParameterSpec;
import de.flexiprovider.core.elgamal.ElGamalPrivateKey;
import de.flexiprovider.core.elgamal.ElGamalPublicKey;

public class ElGamalKeyPairGenerator
extends KeyPairGenerator {
    public static final String OID = "1.3.14.7.2.1.1";
    private static final int CERTAINTY = 80;
    private static final FlexiBigInt TWO = FlexiBigInt.valueOf(2L);
    private static final FlexiBigInt MINUSONE = FlexiBigInt.valueOf(-1L);
    private int keySize = 1024;
    private SecureRandom random;
    private boolean initialized;

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        ElGamalKeyGenParameterSpec elGamalParams;
        if (params == null) {
            elGamalParams = new ElGamalKeyGenParameterSpec();
        } else if (params instanceof ElGamalKeyGenParameterSpec) {
            elGamalParams = (ElGamalKeyGenParameterSpec)params;
        } else {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        this.keySize = elGamalParams.getKeySize();
        this.random = random != null ? random : Registry.getSecureRandom();
        this.initialized = true;
    }

    public void initialize(int keySize, SecureRandom random) {
        ElGamalKeyGenParameterSpec params = new ElGamalKeyGenParameterSpec(keySize);
        try {
            this.initialize(params, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    private void initializeDefault() {
        ElGamalKeyGenParameterSpec defaultParams = new ElGamalKeyGenParameterSpec();
        try {
            this.initialize(defaultParams, Registry.getSecureRandom());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public KeyPair genKeyPair() {
        FlexiBigInt a;
        FlexiBigInt g;
        FlexiBigInt gPowQ;
        FlexiBigInt gPowTwo;
        FlexiBigInt two2GermainPrime;
        FlexiBigInt germainPrime;
        FlexiBigInt strongPrime;
        if (!this.initialized) {
            this.initializeDefault();
        }
        while (!((strongPrime = (germainPrime = new FlexiBigInt(this.keySize - 1, this.random)).shiftLeft(1).add(FlexiBigInt.ONE)).bitLength() == this.keySize && IntegerFunctions.passesSmallPrimeTest(germainPrime) && IntegerFunctions.passesSmallPrimeTest(strongPrime) && germainPrime.isProbablePrime(80) && ((two2GermainPrime = TWO.modPow(germainPrime, strongPrime)).equals(FlexiBigInt.ONE) || two2GermainPrime.subtract(strongPrime).equals(MINUSONE)) && germainPrime.isProbablePrime(80))) {
        }
        FlexiBigInt p = strongPrime;
        FlexiBigInt q = germainPrime;
        do {
            g = new FlexiBigInt(this.keySize - 1, this.random);
            gPowTwo = g.modPow(TWO, p);
            gPowQ = g.modPow(q, p);
        } while (gPowTwo.equals(FlexiBigInt.ONE) || gPowQ.equals(FlexiBigInt.ONE) || g.equals(FlexiBigInt.ZERO));
        FlexiBigInt pMinusOne = p.subtract(FlexiBigInt.ONE);
        while ((a = new FlexiBigInt(this.keySize, this.random)).compareTo(pMinusOne) >= 0) {
        }
        FlexiBigInt A = g.modPow(a, p);
        ElGamalPublicKey pub = new ElGamalPublicKey(p, g, A);
        ElGamalPrivateKey priv = new ElGamalPrivateKey(p, g, A, a);
        return new KeyPair(pub, priv);
    }
}

