/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.dsa;

import codec.asn1.ASN1Integer;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1Type;
import de.flexiprovider.api.exceptions.InvalidParameterSpecException;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.core.dsa.DSAParameterSpec;
import de.flexiprovider.core.dsa.DSAParameters;
import de.flexiprovider.core.dsa.DSAPrivateKeySpec;
import de.flexiprovider.core.dsa.interfaces.DSAParams;

public class DSAPrivateKey
extends de.flexiprovider.core.dsa.interfaces.DSAPrivateKey {
    private FlexiBigInt x;
    private DSAParams params;

    protected DSAPrivateKey(FlexiBigInt x, DSAParams params) {
        this.x = x;
        this.params = params;
    }

    protected DSAPrivateKey(DSAPrivateKeySpec keySpec) {
        this(keySpec.getValueX(), new DSAParameterSpec(keySpec.getPrimeP(), keySpec.getPrimeQ(), keySpec.getBaseG()));
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public DSAParams getParameters() {
        return this.params;
    }

    public FlexiBigInt getValueX() {
        return this.x;
    }

    public String toString() {
        String out = "private x: 0x" + this.x.toString(16) + "\n" + "p:         0x" + this.params.getPrimeP().toString(16) + "\n" + "q:         0x" + this.params.getPrimeQ().toString(16) + "\n" + "g:         0x" + this.params.getBaseG().toString(16) + "\n";
        return out;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DSAPrivateKey)) {
            return false;
        }
        DSAPrivateKey otherKey = (DSAPrivateKey)obj;
        boolean value = this.x.equals(otherKey.x);
        value &= this.params.getBaseG().equals(otherKey.params.getBaseG());
        value &= this.params.getPrimeP().equals(otherKey.params.getPrimeP());
        return value &= this.params.getPrimeQ().equals(otherKey.params.getPrimeQ());
    }

    public int hashCode() {
        return this.x.hashCode() + this.params.getBaseG().hashCode() + this.params.getPrimeP().hashCode() + this.params.getPrimeQ().hashCode();
    }

    protected ASN1ObjectIdentifier getOID() {
        return new ASN1ObjectIdentifier("1.2.840.10040.4.1");
    }

    protected ASN1Type getAlgParams() {
        DSAParameters dsaParams = new DSAParameters();
        DSAParameterSpec dsaParamSpec = new DSAParameterSpec(this.params.getPrimeP(), this.params.getPrimeQ(), this.params.getBaseG());
        try {
            dsaParams.init(dsaParamSpec);
        }
        catch (InvalidParameterSpecException e) {
            throw new RuntimeException("internal error");
        }
        return dsaParams.getASN1Parameters();
    }

    protected byte[] getKeyData() {
        ASN1Integer keyData = new ASN1Integer(this.x.toByteArray());
        return ASN1Tools.derEncode((ASN1Type)keyData);
    }
}

