/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.dsa;

import de.flexiprovider.api.exceptions.InvalidParameterException;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;

public class DSAParamGenParameterSpec
implements AlgorithmParameterSpec {
    public static final int DEFAULT_L = 1024;
    public static final int DEFAULT_N = 160;
    private int L;
    private int N;

    public DSAParamGenParameterSpec() {
        this(1024, 160);
    }

    public DSAParamGenParameterSpec(int keySize) throws InvalidParameterException {
        if (keySize == 1024) {
            this.L = 1024;
            this.N = 160;
        } else if (keySize == 2048) {
            this.L = keySize;
            this.N = 224;
        } else if (keySize == 3072) {
            this.L = keySize;
            this.N = 256;
        } else {
            throw new InvalidParameterException("key size must either 1024 or 2048");
        }
    }

    public DSAParamGenParameterSpec(int L, int N) throws InvalidParameterException {
        if (L < 1) {
            throw new InvalidParameterException("L must be positive");
        }
        this.L = L;
        if (N < 1) {
            throw new InvalidParameterException("N must be positive");
        }
        this.N = N;
    }

    public int getL() {
        return this.L;
    }

    public int getN() {
        return this.N;
    }
}

