/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.dsa;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.keys.KeyPair;
import de.flexiprovider.api.parameters.AlgorithmParameterGenerator;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.core.dsa.DSAParamGenParameterSpec;
import de.flexiprovider.core.dsa.DSAParameterGenerator;
import de.flexiprovider.core.dsa.DSAPrivateKey;
import de.flexiprovider.core.dsa.DSAPublicKey;
import de.flexiprovider.core.dsa.interfaces.DSAParams;

public class DSAKeyPairGenerator
extends de.flexiprovider.core.dsa.interfaces.DSAKeyPairGenerator {
    private DSAParams params;
    private SecureRandom random;
    private boolean initialized;

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        SecureRandom secureRandom = this.random = random != null ? random : Registry.getSecureRandom();
        if (params == null) {
            this.initialize(1024, this.random);
            return;
        }
        if (!(params instanceof DSAParams)) {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        this.params = (DSAParams)((Object)params);
        this.initialized = true;
    }

    public void initialize(int keySize, SecureRandom random) {
        DSAParamGenParameterSpec genParams = new DSAParamGenParameterSpec(keySize);
        DSAParameterGenerator paramGenerator = new DSAParameterGenerator();
        try {
            ((AlgorithmParameterGenerator)paramGenerator).init(genParams, random);
            AlgorithmParameterSpec dsaParams = ((AlgorithmParameterGenerator)paramGenerator).generateParameters();
            this.initialize(dsaParams, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    private void initializeDefault() {
        this.initialize(1024, Registry.getSecureRandom());
    }

    public KeyPair genKeyPair() {
        FlexiBigInt x;
        if (!this.initialized) {
            this.initializeDefault();
        }
        FlexiBigInt p = this.params.getPrimeP();
        FlexiBigInt q = this.params.getPrimeQ();
        FlexiBigInt g = this.params.getBaseG();
        int N = q.bitLength();
        while ((x = new FlexiBigInt(N, this.random)).compareTo(FlexiBigInt.ZERO) == 0 || x.compareTo(q) >= 0) {
        }
        FlexiBigInt y = g.modPow(x, p);
        DSAPublicKey pubKey = new DSAPublicKey(y, this.params);
        DSAPrivateKey privKey = new DSAPrivateKey(x, this.params);
        return new KeyPair(pubKey, privKey);
    }
}

