/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.camellia;

import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.common.util.ByteUtils;

public class CamelliaKey
implements SecretKey {
    private byte[] keyBytes;

    protected CamelliaKey(byte[] keyBytes) {
        this.keyBytes = ByteUtils.clone(keyBytes);
    }

    public String getAlgorithm() {
        return "Camellia";
    }

    public String getFormat() {
        return "RAW";
    }

    public byte[] getEncoded() {
        return ByteUtils.clone(this.keyBytes);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof CamelliaKey)) {
            return false;
        }
        CamelliaKey otherKey = (CamelliaKey)other;
        return ByteUtils.equals(this.keyBytes, otherKey.keyBytes);
    }

    public int hashCode() {
        int result = 1;
        int i = 0;
        while (i < this.keyBytes.length) {
            result = 31 * result + this.keyBytes[i];
            ++i;
        }
        return result;
    }
}

