/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.api;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.SignatureException;
import de.flexiprovider.api.keys.PrivateKey;
import de.flexiprovider.api.keys.PublicKey;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.util.JavaSecureRandomWrapper;
import java.security.InvalidParameterException;
import java.security.SignatureSpi;

public abstract class Signature
extends SignatureSpi {
    protected final Object engineGetParameter(String param) throws InvalidParameterException {
        return null;
    }

    protected final void engineSetParameter(String param, Object value) throws InvalidParameterException {
    }

    protected final void engineInitSign(java.security.PrivateKey privateKey) throws java.security.InvalidKeyException {
        if (privateKey == null || !(privateKey instanceof PrivateKey)) {
            throw new java.security.InvalidKeyException();
        }
        this.initSign((PrivateKey)privateKey);
    }

    protected final void engineInitSign(java.security.PrivateKey privateKey, java.security.SecureRandom javaRand) throws java.security.InvalidKeyException {
        if (privateKey == null || !(privateKey instanceof PrivateKey)) {
            throw new java.security.InvalidKeyException();
        }
        JavaSecureRandomWrapper flexiRand = new JavaSecureRandomWrapper(javaRand);
        this.initSign((PrivateKey)privateKey, flexiRand);
    }

    protected final void engineInitVerify(java.security.PublicKey publicKey) throws java.security.InvalidKeyException {
        if (publicKey == null || !(publicKey instanceof PublicKey)) {
            throw new java.security.InvalidKeyException();
        }
        this.initVerify((PublicKey)publicKey);
    }

    protected void engineSetParameter(java.security.spec.AlgorithmParameterSpec params) throws java.security.InvalidAlgorithmParameterException {
        if (params != null && !(params instanceof AlgorithmParameterSpec)) {
            throw new java.security.InvalidAlgorithmParameterException();
        }
        this.setParameters((AlgorithmParameterSpec)params);
    }

    protected final void engineUpdate(byte b) throws java.security.SignatureException {
        this.update(b);
    }

    protected final void engineUpdate(byte[] b, int off, int len) throws java.security.SignatureException {
        this.update(b, off, len);
    }

    protected final byte[] engineSign() throws java.security.SignatureException {
        return this.sign();
    }

    protected final boolean engineVerify(byte[] sigBytes) throws java.security.SignatureException {
        return this.verify(sigBytes);
    }

    protected final boolean engineVerify(byte[] sigBytes, int offset, int length) throws java.security.SignatureException {
        return this.verify(sigBytes, offset, length);
    }

    public final void initSign(PrivateKey privKey) throws InvalidKeyException {
        this.initSign(privKey, Registry.getSecureRandom());
    }

    public abstract void initSign(PrivateKey var1, SecureRandom var2) throws InvalidKeyException;

    public abstract void initVerify(PublicKey var1) throws InvalidKeyException;

    public abstract void setParameters(AlgorithmParameterSpec var1) throws InvalidAlgorithmParameterException;

    public abstract void update(byte var1) throws SignatureException;

    public final void update(byte[] input) throws SignatureException {
        this.update(input, 0, input.length);
    }

    public abstract void update(byte[] var1, int var2, int var3) throws SignatureException;

    public abstract byte[] sign() throws SignatureException;

    public final byte[] sign(byte[] input) throws SignatureException {
        this.update(input);
        return this.sign();
    }

    public abstract boolean verify(byte[] var1) throws SignatureException;

    public final boolean verify(byte[] input, byte[] signature) throws SignatureException {
        this.update(input);
        return this.verify(signature);
    }

    public final boolean verify(byte[] signature, int sigOff, int sigLen) throws SignatureException {
        byte[] sig = new byte[sigLen];
        System.arraycopy(signature, sigOff, sig, 0, sigLen);
        return this.verify(sig);
    }

    public final boolean verify(byte[] input, byte[] signature, int sigOff, int sigLen) throws SignatureException {
        this.update(input);
        return this.verify(signature, sigOff, sigLen);
    }
}

