<?

class Users extends MY_Model {
	
	private $assets = array('products', 'transactions', 'landevices', 'gatewayclients');
	private $roles = array(ADMIN,OPERATOR);

	function __construct() {
		parent::__construct();

	}

	function get($where = null, $offset = null, $singleRow = false, $countOnly = false) {
		$this->db-> from($this->getTableNameByDB('user').' u') 
			-> join('product p', 'u.product_id = p.product_id');
		if ($singleRow) {
			$select = 'u.*, r.name as role, p.name as product, s.name as ssoservice';
		} else if (!$countOnly) {
			$select = 'u.id, u.username, u.email, u.deleted, u.added_date, '.
      			'u.firstname, u.lastname, p.name as product';
			$groupBy = 'u.id, u.username, u.email, u.deleted, u.added_date, '.
      			'u.firstname, u.lastname, p.name';
		}

		if (!$singleRow && !$countOnly) {
			$withoutDeleted = !$this -> session -> userdata('user_show_deleted_devices');
			$this->db->select('COUNT(distinct ld.landevice_id) as landdevices_num, '.
				'COUNT(distinct gc.gateway_client_id)  as gatewayclients_num', false)
			-> join('landevice ld', 'u.id = ld.user_id'.($withoutDeleted ? ' AND ld.deleted = 0' : ''), 'left') 
			-> join('gatewayclient gc', 'u.id = gc.user_id'.($withoutDeleted ? ' AND gc.deleted = 0' : ''), 'left')
			-> group_by($groupBy)
			-> order_by("u.added_date", "desc"); 
		}
				
		if (!$countOnly) {
			$this -> db -> select($select) 
				-> join('userrole ur', 'u.id = ur.user_id', 'left') 
				-> join('role r', 'ur.role_id = r.id', 'left') 
				-> join('ssoservice s', 'u.ssoservice_id = s.ssoservice_id', 'left');
		}
		$result = $this->getResult($where, $offset, $singleRow, $countOnly);
		if ($singleRow && $result) {
			$result['status'] = $this->getStatus($result);
			$result['log_conf'] = $this->getTextByDB($result['log_conf']);
			$result['deleted_date'] = $this->getDateByDB($result['deleted_date']);
		}
		return $result;
	}

	function prepareRow(&$row) {
		$row['added_date'] = $this->getDateByDB($row['added_date']);
	}

	function getById($user_id) {
		return $this -> get(array('u.id' => $user_id), null, true);
	}

	function getByUsername($username, $deleted = 0) {
		return $this -> get(array('u.username' => $username, 'u.deleted' => $deleted), null, true);
	}
	
	function getSearchConditions () {
		$where = array();
		if ($this -> session -> userdata('search_user_username')) {
			$this -> db -> like('u.username', $this -> session -> userdata('search_user_username'), 'after');
		}
		if ($this -> session -> userdata('search_user_email')) {
			$this -> db -> like('u.email', $this -> session -> userdata('search_user_email'), 'after');
		}
		if ($this -> session -> userdata('search_user_name')) {
			$this -> db -> like('u.firstname', $this -> session -> userdata('search_user_name'), 'after');
			$this -> db -> or_like('u.lastname', $this -> session -> userdata('search_user_name'), 'after');
		}
		if ($this -> session -> userdata('search_user_createdFrom')) {
			$date = $this->setDateByDB($this -> session -> userdata('search_user_createdFrom'),false);
			$where['u.added_date > '] = $date;
		}
		if ($this -> session -> userdata('search_user_createdTo')) {
			$date = $this->setDateByDB($this -> session -> userdata('search_user_createdTo'),false);
			$where['u.added_date < '] = $date;
		}
		if ($this -> session -> userdata('search_user_product')) {
			$where['u.product_id'] = $this -> session -> userdata('search_user_product');
		}
		if (!$this -> session -> userdata('search_user_deleted')) {
			$where['u.deleted'] = false;
		}
		if (!$this -> session -> userdata('search_user_non_activated')) {
			$this -> db -> where('u.activation_code IS NULL',null,false);
		}
		return $where;
	}
	
	function getInfo ($user_id) {
		$withoutDeleted = !$this -> session -> userdata('user_show_deleted_devices');
		$user = $this->getById($user_id);
		foreach ($this->assets as $asset) {
			$this->load->model($asset);
			$user[$asset] = $this->$asset->getByUser($user_id, $withoutDeleted);
		}
		return $user;
	}

	function getLastDeletedNr ($username) {
		$this->db->select_max('deleted', 'last_deleted_nr')
			->where('username', $username);
		$result = $this->db->get($this->getTableNameByDB('user'))->row_array();
		return $result['last_deleted_nr'] ? $result['last_deleted_nr'] : 0;
	}
	
	function getStatus ($user) {
		if ($user['activation_code'])
			return STATUS_NOT_ACTIVATED;
		else if ($user['deleted'])
			return STATUS_DELETED;
		else
			return STATUS_CONFIRMED;
			
	}

	function login($username, $password) {
		$user = $this -> getByUsername($username);
		$ok = false;
		$msg = '';
		if (!$user)
			$msg = 'User not exists';
		else if (!in_array($user['role'], $this->roles))
			$msg = 'Only admin and operator can log in';
		else if ($response = $this->rest->login($username, $password)) {
			$status = $response -> body -> status;
			if ($status == STATUS_OK) {
				$user['JSESSIONID'] = $response -> body -> sessionId;
				$this -> setUserData($user);
				$msg = 'You have been logged in.';
				$ok = true;
			} else if ($status == STATUS_FAILED) {
				$msg = 'Log in failed. Incorrect login or password';
			} else {
				$msg = 'Log in failed. Reason: '.$this->getErrorMsg($status);
			}
		}
		return $this->checkResult($ok, $msg);
	}

	function logout($msg = '') {
		$ok = false;
		$msg = '';
		if ($response = $this->rest->logout()) {
			if ($response -> body -> status == STATUS_OK) {
				$msg = 'Log out success';
				$ok = true;
			} else
				$msg .= 'Log out failed';	
		}
		$result = $this->checkResult($ok, $msg);
		$this->clearSession();
		return $result;
	}
	
	function loginAs ($user) {
		$ok = false;
		$msg = '';
		if ($response = $this->rest->loginAs($user['id'])) {
			if ($response -> body -> status == STATUS_OK) {
				$ok = true;
			} else
				$msg .= 'Login as failed';	
		}
		if ($this->checkResult($ok, $msg)) {
			$jSessionId = $this->session->userdata('JSESSIONID');
			setcookie('JSESSIONID',$jSessionId,0,'/app','');
			setcookie('JSESSIONID',$jSessionId,0,'/app','',false,true);
			return $jSessionId;
		} else {
			return null;
		}
	}
	
	function changePassAsAdmin($user_id, $password) {
		$ok = false;
		$msg = '';
		if ($response = $this->rest->changePassAsAdmin($user_id, $password)) {
			$status = $response -> body -> status;
			if ($status == STATUS_OK) {
				$msg = 'User password has been sucessfully changed';
				$ok = true;
			} else {
				$msg = 'User password change as admin failed. Reason: '.$this->getErrorMsg($status);
			}
		}
		return $this->checkResult($ok, $msg);
	}

	function verify() {
		$user = null;
		if ($this -> session -> userdata('id') && in_array($this -> session -> userdata('role'), $this->roles)) {
			$data = array (
				'u.id' => $this -> session -> userdata('id'), 
				'u.username' => $this -> session -> userdata('username'), 
				'u.email' => $this -> session -> userdata('email'), 
				'u.firstname' => $this -> session -> userdata('firstname'), 
				'u.lastname' => $this -> session -> userdata('lastname'), 
				'r.name' => $this -> session -> userdata('role'), 
				'u.deleted' => 0
			);
			$user = $this -> get($data, null, true);
		} else if (!$this -> session -> userdata('id')) {
			return false;
		}
		if (!$user) {
			$this -> logout('Unauthorized access. User log out.');
			return false;
		} else {
			return true;
		}
	}
	
	function check($user_id) {
		$user = null;
		if ($user_id) {
			$user = $this->getInfo($user_id);
			if (!$user) {
				$this->session->set_flashdata('error', 'Selected user not found.');
			}
		} else {
			$this->session->set_flashdata('error', 'No user selected.');
		}
		return $user;
	}

	function setUserData($user) {
		$this->clearSession();
		$user_data = array();
		$user_data['id'] = $user['id'];
		$user_data['username'] = $user['username'];
		$user_data['JSESSIONID'] = $user['JSESSIONID'];
		$user_data['email'] = $user['email'];
		$user_data['firstname'] = $user['firstname'];
		$user_data['lastname'] = $user['lastname'];
		$user_data['product'] = $user['product'];
		$user_data['role'] = $user['role'];
		$this -> session -> set_userdata($user_data);
		
		$cookie = array(
		    'name'   => 'JSESSIONID',
		    'value'  => $user['JSESSIONID'],
		    'expire' => '0',
			'path'   => '/',
		);
		
		if ($this->config->item('protocol') == PROTOCOL_SECURE)
			$cookie['secure'] = true;
		set_cookie($cookie);
	}
	
	function update($user_id, $data) {
		$this->db->where('id', $user_id);
		$this->db->update($this->getTableNameByDB('user'), $data);
	}
	
	function delete($user) {
		$data = array(
			'deleted' => $this->getLastDeletedNr($user['username'])+1,
			'deleted_date' => now()
		);
		$this->update($user['id'], $data);
		$this->session->set_flashdata('message', 'User account deleted.');
	}
	
	function undelete($user) {
		$data = array(
			'deleted' => 0,
			'deleted_date' => null
		);
		$this->update($user['id'], $data);
		$this->session->set_flashdata('message', 'User account undeleted.');
	}

	function activate($user) {
		$data = array(
			'activation_code' => null
		);
		$this->update($user['id'], $data);
		$this->session->set_flashdata('message', 'User account activated.');
	}

	function edit ($user, $data) {
		$this->db->update($this->getTableNameByDB('user'), $data, array('id' => $user['id']));
		$this->session->set_flashdata('message', 'User data edited.');
	}
	
	function purge($user_id) {
		$this->db->trans_start();
		$this->load->model('landevices');
		$landevices = $this->landevices->getByUser($user_id, false);
		
		$tables = array('landeviceproductlog','event');
		if (!NEW_DATABASE_STRUCTURE)
			$tables[] = 'landeviceparam';
		foreach ($landevices as $landevice) {
			$this->db->where_in('landevice_id',$landevice['landevice_id'])
				->delete($tables);
		}
		
		$tables = array('userproductlog','userrole','transaction','landevice','gatewayclient');
		$this->db->where('user_id',$user_id)
			->delete($tables);
		
		$this->db->delete($this->getTableNameByDB('user'), array('id' => $user_id));
		$this->session->set_flashdata('message', 'User account deleted permanently.');
		$this->db->trans_complete();
	}
}
