<?

class Productfeatures extends MY_Model
{
	
    function __construct()
    {
        parent::__construct();
    }
	
	function get($where = null, $offset = null, $singleRow = false, $countOnly = false) {
		$this->db->from('productfeature pf')
			->join('feature f','f.feature_id = pf.feature_id')
			-> order_by("f.feature_code"); 
		$result = $this->getResult($where, $offset, $singleRow, $countOnly);
		return $result;
	}
	
	function check($productfeature_id) {
		$productfeature = null;
		if ($productfeature_id) {
			$productfeature = $this->get(array('productfeature_id' => $productfeature_id), null, true);
			if (!$productfeature) {
				$this->session->set_flashdata('error', 'Selected product feature not found.');
			}
		} else {
			$this->session->set_flashdata('error', 'No product feature selected.');
		}
		return $productfeature;
	}
	
	function add ($data) {
		$this->db->insert('productfeature', $data);
		$this->session->set_flashdata('message', 'Product feature added.');
	}
	
	function edit ($productfeature, $data) {
		$this->db->update('productfeature', $data, array('productfeature_id' => $productfeature['productfeature_id']));
		$this->session->set_flashdata('message', 'Product feature edited.');
	}
	function delete ($product) {
			$this->db->delete('productfeature', array('productfeature_id' => $product['productfeature_id']));
			$this->session->set_flashdata('message', 'Product feature deleted.');
	}
	
	function getFeatures($where = null, $offset = null, $singleRow = false, $countOnly = false) {
		$this->db->from('feature f')
			-> order_by("f.feature_code"); 
		$result = $this->getResult($where, $offset, $singleRow, $countOnly);
		return $result;
	}
	
	function getFeaturesDropdown($withBlank = true) {
		$result = $this->getFeatures();
		$features = array();
		if ($withBlank)
			$features[''] = '';
		foreach ($result as $feature) {
			$features[$feature['feature_id']] = $feature['feature_code'];
		}
		return $features;
	}
}
