<?

class Parameters extends MY_Model
{
	
    function __construct()
    {
        parent::__construct();
    }
	
	function get($where = null, $offset = null, $singleRow = false, $countOnly = false) {
		$this->db->from('parameter p')
			-> order_by("p.code"); 
		$result = $this->getResult($where, $offset, $singleRow, $countOnly);
		return $result;
	}
	
	function check($parameter_id) {
		$parameter = null;
		if ($parameter_id) {
			$parameter = $this->get(array('parameter_id' => $parameter_id), null, true);
			if (!$parameter) {
				$this->session->set_flashdata('error', 'Selected parameter not found.');
			}
		} else {
			$this->session->set_flashdata('error', 'No parameter selected.');
		}
		return $parameter;
	}
	
	function add ($data) {
		$this->db->insert('parameter', $data);
		$this->session->set_flashdata('message', 'Parameter added.');
	}
	
	function edit ($parameter, $data) {
		$this->db->update('parameter', $data, array('parameter_id' => $parameter['parameter_id']));
		$this->session->set_flashdata('message', 'Parameter edited.');
	}
	function delete ($parameter) {
		$this->db->delete('parameter', array('parameter_id' => $parameter['parameter_id']));
		$this->session->set_flashdata('message', 'Parameter deleted.');
	}
}
