<?

class Gatewayclientsessions extends Devices_Model
{
	
    function __construct()
    {
        parent::__construct();
    }
	
	function get ($where = null, $offset = null, $singleRow = false, $countOnly = false) {
		$this->db->select('gcs.*, gc.user_id, u.username')
			->from('gatewayclientsession gcs')
			->join('gatewayclient gc','gcs.mac = gc.mac and gc.deleted = 0','left')
			->join($this->getTableNameByDB('user').' u','gc.user_id = u.id','left')
			->order_by("gcs.connected_date", "desc"); 
		$result = $this->getResult($where, $offset, $singleRow, $countOnly);
		return $result;
	}
	
	function prepareRow(&$row) {
		$row['connected_date'] = $this->getDateByDB($row['connected_date']);
		$row['last_alive'] = $this->getDateByDB($row['last_alive']);
	}
	
	function getSearchConditions () {
		$where = array();
		if ($this -> session -> userdata('search_server_mac')) {
			$this -> db -> like('gcs.mac', $this -> session -> userdata('search_server_mac'), 'after');
		}
		if ($this -> session -> userdata('search_server_public_ip')) {
			$this -> db -> like('gcs.public_ip', $this -> session -> userdata('search_server_public_ip'), 'after');
		}
		return $where;
	}
	
	function getById ($mac) {
		$where = array('gcs.mac' => $mac);
		return $this->get($where, null, true);
	}
	function getURL($session,$data) {
		$data['mac'] = $session['mac'];
		return parent::getURL($data);
	}
}
