<?php
abstract class MY_Controller extends CI_Controller
{
	protected $unauthorized;
	protected $requireRestAuthorization;
	protected $requireRole;
	protected $search_criteria;
	protected $model;
	protected $controller;
	protected $fields;
	protected $index = null;
	protected $ajaxRedirect = null;
	
   function __construct()
   {
      parent::__construct();
	  if (isset($this->model))
	  		$this->load->model($this->model);
	  if (!$this->_isAuthorized()) {
	  		$this->users->clearSession();
			if ($this->input->is_ajax_request())
				$this->ajaxRedirect = 'user/login';
			else
				redirect('user/login');
	  }
	  $role = isset($this->requireRole) && array_key_exists($this->router->method,$this->requireRole) ? $this->requireRole[$this->router->method] : null;
	  if ($role && $this -> session -> userdata('role') != $role) {
	  		$this->session->set_flashdata('error', 'This function required '.$role.' role.');
		  	if ($this->input->is_ajax_request())
				$this->ajaxRedirect = $_SERVER['HTTP_REFERER'];
			else
				redirect($_SERVER['HTTP_REFERER']);
	  }
   }
   
   function _isAuthorized () {
		$authorized = (isset($this->unauthorized) && in_array($this->router->method,$this->unauthorized) 
			|| $this->users->verify());
		if ($authorized) {
			if (isset($this->requireRestAuthorization) && in_array($this->router->method,$this->requireRestAuthorization))
				return $this->rest->ensureLogedIn();
			else {
				return true;
			}
		} else {
			return false;
		}
		
   }
   
   function _prepareAndShow ($object_id, $function = null, $validation = null, $data = null, $deleted = null) {
    	$model = $this->model;
		$controller = $this->controller;
		if ($object_id == null || $object = $this->$model->check($object_id, $deleted)) {
			if (!$function || ($validation && !$this->form_validation->run($validation))) {
				$data['object'] = $object_id ? $object : $data;
				$data['content'] = $this->load->view("$controller/show", $data, true);
				$this->load->view('index', $data);
			} else {
				if ($object_id != null) {
					$this->$model->$function($object,$data);
				} else {
					$this->$model->$function($data);
				}
				redirect("$controller/index");
			}
		} else {
			if ($this->index)
				redirect($this->index);
			else
				redirect("$controller/index");
		}
	}
   
   function _ajax ($object_id, $function, $validation = null, $data = null) {
   		if ($this->ajaxRedirect) {
   			$data['json'] = '{"redirect":"'.$this->ajaxRedirect.'"}';
   		} else {
	    	$model = $this->model;
			$controller = $this->controller;
			$status = 0;
			if ($object_id == null || $object = $this->$model->check($object_id)) {
				if ($validation && !$this->form_validation->run($validation)) {
					$response = validation_errors();
				} else {
					$response = $object_id != null ? $this->$model->$function($object,$data) : $model->$function($data);
					if ($response !== null) {
						$status = 1;
						if (is_string($response)) {
							preg_match_all('/<html.*?>(.*?)<\/html>/is', $response, $match);
							if ($match[1])
								$response = $match[1];
						}
						$response = json_encode($response);
					} else {
						$response = $this->session->userdata('flash:new:error');
						$this->session->unset_userdata('flash:new:error');
					}
				}	
			} else {
				$response = 'Invalid id';
			}
			if (!$status)
				$response = '"'.$response.'"';
			$data['json'] = '{"status":'.$status.', "response":'.$response.'}';
		}
        $this->load->view('templates/json', $data);
	}
	
	function _show($object_id = 0, $deleted = null) {
		$this->_prepareAndShow($object_id, null, null, null, $deleted);
	}
	
	function _add($validation = null, $additional = null) {
		$data = $this->_getDataFromPost();
		if ($additional) {
			$data = array_merge($additional, $data);
		}
		$this->_prepareAndShow(null, 'add', $validation, $data);
	}
	
	function _edit($object_id = 0, $validation = null) {
		$data = $this->_getDataFromPost();
		$this->_prepareAndShow($object_id, 'edit', $validation, $data);
	}
   
   function _clearSearch() {
		foreach ($this->search_criteria as $field)
			$this->session->unset_userdata('search_'.$this->controller."_$field");
	}
   
   function _getDataFromPost() {
   		$data = array();
		foreach ($this->fields as $field) {
			$data[$field] = $this->input->post($field);
		}
		return $data;
   }
   
   function _index($offset = 0, $countAll = false) {
   		$model = $this->model;
		$controller = $this->controller;
		if(!is_numeric($offset)) {
			$this->_clearSearch();
			$offset = 0;
		}
		$num = $this->$model->count();
		
		$config['base_url'] = $url = $this->config->item('base_url')."$controller/index";
		$config['total_rows'] = $num;
		$this->pagination->initialize($config);
		if ($countAll) {
			if(!is_numeric($offset))
				$data['countAll'] = $num;
			else
				$data['countAll'] = $this->$model->countAll();
		}
		$data['count'] = $num;
		$data['objects'] = $this->$model->getAll($offset);
		$data['content'] = $this->load->view("$controller/index", $data, true);
		$this->load->view('index', $data);
	}
	
	function _search($offset = 0, $countAll = false) {
		if($this->input->post('submit')) {
			$this->_clearSearch();
			foreach ($this->search_criteria as $field)
				if($this->input->post('search_'.$this->controller."_$field"))
					$this->session->set_userdata('search_'.$this->controller."_$field", $this->input->post('search_'.$this->controller."_$field"));
		}
		$this->_index($offset,$countAll);
	}
}
