<?

class Landevice extends MY_Controller {
	
	protected $model = 'landevices';
	protected $controller = 'landevice';
	protected $fields = array('product_id', 'valid_to');
	protected $index = 'device/index';
	protected $requireRestAuthorization = array('checkConfigStatus', 'reconfigure', 'upgradeFirmware','getURL', 'delete');

    function __construct()
    {
        parent::__construct();
    }
	
	function index() {
		redirect('device/index');
	}
	
	function show($device_id = 0, $deleted = null) {
		$this->_prepareAndShow($device_id);
	}
	
	function edit($device_id = 0) {
		$this->_edit($device_id);
	}
	
	function delete ($device_id = 0) {
		if ($device = $this->landevices->check($device_id)) {
			$this->landevices->delete($device);
		}
		redirect('device/index');
	}
	
	function checkConfigStatus($device_id = 0) {
		$this->_prepareAndShow($device_id, 'checkConfigStatus');
	}

	function reconfigure($device_id = 0) {
		$this->_prepareAndShow($device_id, 'reconfigure');
	}

	function upgradeFirmware ($device_id = 0) {
		$this->_ajax($device_id, 'upgradeFirmware');
	}
	
	function getURL($device_id = 0) {
		$data['method'] = $this->input->post('method');
		$data['queryString'] = $this->input->post('queryString');
		$data['body'] = $this->input->post('body');
		$this->_ajax($device_id, 'getURL', 'getURL', $data);
	}
}