<?

class Gatewayclient extends MY_Controller {
	
	protected $model = 'gatewayclients';
	protected $controller = 'gatewayclient';
	protected $fields = array('log_conf');
	protected $index = 'device/index';
	protected $requireRestAuthorization = array('restart', 'upgrade', 'executeScript');

    function __construct()
    {
        parent::__construct();
		$this->load->model('landevices');
    }
	
	function index() {
		redirect('device/index');
	}
	
	function show($device_id = 0) {
		$this->_prepareAndShow($device_id);
	}
	
	function edit($device_id = 0) {
		$this->_edit($device_id);
	}
	
	function restart($device_id = 0) {
		$this->_prepareAndShow($device_id, 'restart');
	}
	
	function upgrade($device_id = 0) {
		$this->_prepareAndShow($device_id, 'upgrade');
	}
	
	function executeScript($device_id = 0) {
		$data['script'] = $this->input->post('script');
		$this->_ajax($device_id, 'executeScript', null, $data);
	}

}