-- MySQL dump 10.13  Distrib 5.5.8, for osx10.6 (i386)
--
-- Host: localhost    Database: aladdin_computex
-- ------------------------------------------------------
-- Server version	5.5.8

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `application`
--

DROP TABLE IF EXISTS `application`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `application` (
  `application_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) NOT NULL,
  `code` text NOT NULL,
  `devicetype` varchar(45) NOT NULL,
  PRIMARY KEY (`application_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application`
--

LOCK TABLES `application` WRITE;
/*!40000 ALTER TABLE `application` DISABLE KEYS */;
/*!40000 ALTER TABLE `application` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `debuglog`
--

DROP TABLE IF EXISTS `debuglog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `debuglog` (
  `debuglog_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `logger_name` varchar(45) DEFAULT NULL,
  `log_level` varchar(45) DEFAULT NULL,
  `ndc` varchar(45) DEFAULT NULL,
  `message` text,
  `thread` varchar(255) DEFAULT NULL,
  `timestamp` datetime DEFAULT NULL,
  `file_` varchar(255) DEFAULT NULL,
  `line` int(11) DEFAULT NULL,
  `jsession_id` varchar(255) DEFAULT NULL,
  `username` varchar(45) DEFAULT NULL,
  `mac` varchar(17) DEFAULT NULL,
  PRIMARY KEY (`debuglog_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `debuglog`
--

LOCK TABLES `debuglog` WRITE;
/*!40000 ALTER TABLE `debuglog` DISABLE KEYS */;
/*!40000 ALTER TABLE `debuglog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `devicedesc`
--

DROP TABLE IF EXISTS `devicedesc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `devicedesc` (
  `devicedesc_id` int(11) NOT NULL AUTO_INCREMENT,
  `class` varchar(45) NOT NULL,
  `make` varchar(100) NOT NULL,
  `model` varchar(100) NOT NULL,
  `driverclass` varchar(100) NOT NULL,
  `firmware_version` varchar(20) DEFAULT NULL,
  `firmware_file` varchar(255) DEFAULT NULL,
  `drivercode` text,
  PRIMARY KEY (`devicedesc_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `devicedesc`
--

LOCK TABLES `devicedesc` WRITE;
/*!40000 ALTER TABLE `devicedesc` DISABLE KEYS */;
INSERT INTO `devicedesc` VALUES (1,'camera','Askey','generic','CameraAskeyGeneric',NULL,NULL,NULL),(2,'camera','Askey','QBee Camera','CameraAskeyGeneric',NULL,NULL,NULL),(3,'switch','Askey','QBee WiFiSwitch','',NULL,NULL,NULL),(4,'gateway','Askey','QBee Gateway','NAS',NULL,NULL,NULL);
/*!40000 ALTER TABLE `devicedesc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dyndns`
--

DROP TABLE IF EXISTS `dyndns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dyndns` (
  `dyndns_id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_name` varchar(255) NOT NULL,
  `ha_id` varchar(255) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  PRIMARY KEY (`dyndns_id`),
  UNIQUE KEY `dyndns_ha_id_unique` (`ha_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dyndns`
--

LOCK TABLES `dyndns` WRITE;
/*!40000 ALTER TABLE `dyndns` DISABLE KEYS */;
/*!40000 ALTER TABLE `dyndns` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emailtemplate`
--

DROP TABLE IF EXISTS `emailtemplate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emailtemplate` (
  `emailtemplate_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `emailcode` varchar(64) NOT NULL,
  `language` varchar(2) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `body` text NOT NULL,
  `body_html` text,
  PRIMARY KEY (`emailtemplate_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emailtemplate`
--

LOCK TABLES `emailtemplate` WRITE;
/*!40000 ALTER TABLE `emailtemplate` DISABLE KEYS */;
/*!40000 ALTER TABLE `emailtemplate` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `event` (
  `event_id` int(11) NOT NULL AUTO_INCREMENT,
  `landevice_id` int(11) unsigned NOT NULL,
  `date_event` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `date_start_requested` timestamp NULL DEFAULT NULL,
  `date_started` timestamp NULL DEFAULT NULL,
  `date_stopped` timestamp NULL DEFAULT NULL,
  `date_stop_requested` timestamp NULL DEFAULT NULL,
  `eventtrigger` enum('MOTION','MANUAL','AUDIO') NOT NULL,
  `image_file_size` int(11) DEFAULT NULL,
  `video_file_size` int(11) DEFAULT NULL,
  `deleted_video` tinyint(1) NOT NULL DEFAULT '0',
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_video_date` datetime DEFAULT NULL,
  PRIMARY KEY (`event_id`),
  KEY `event__landedevice_id_fkey` (`landevice_id`),
  CONSTRAINT `event__landedevice_id_fkey` FOREIGN KEY (`landevice_id`) REFERENCES `landevice` (`landevice_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event`
--

LOCK TABLES `event` WRITE;
/*!40000 ALTER TABLE `event` DISABLE KEYS */;
/*!40000 ALTER TABLE `event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eventlog`
--

DROP TABLE IF EXISTS `eventlog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `eventlog` (
  `event_id` int(11) NOT NULL AUTO_INCREMENT,
  `source` enum('GC','LD','VIEWER') DEFAULT NULL,
  `source_mac` varchar(255) DEFAULT NULL,
  `source_ip` varchar(32) DEFAULT NULL,
  `event_type` varchar(45) NOT NULL,
  `timestamp` datetime NOT NULL,
  `status` varchar(45) DEFAULT NULL,
  `description` varchar(2000) DEFAULT NULL,
  PRIMARY KEY (`event_id`),
  KEY `idx_timestamp` (`timestamp`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eventlog`
--

LOCK TABLES `eventlog` WRITE;
/*!40000 ALTER TABLE `eventlog` DISABLE KEYS */;
/*!40000 ALTER TABLE `eventlog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eventnotification`
--

DROP TABLE IF EXISTS `eventnotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `eventnotification` (
  `eventnotification_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `landevice_id` int(11) unsigned NOT NULL,
  `notification_type` enum('APNS','C2DM') NOT NULL,
  `token` varchar(256) NOT NULL,
  PRIMARY KEY (`eventnotification_id`),
  KEY `eventnotification__landevice_id_fkey` (`landevice_id`),
  KEY `eventnotification_landevice_id_fkey` (`landevice_id`),
  CONSTRAINT `eventnotification_landevice_id_fkey` FOREIGN KEY (`landevice_id`) REFERENCES `landevice` (`landevice_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eventnotification`
--

LOCK TABLES `eventnotification` WRITE;
/*!40000 ALTER TABLE `eventnotification` DISABLE KEYS */;
/*!40000 ALTER TABLE `eventnotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `feature`
--

DROP TABLE IF EXISTS `feature`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `feature` (
  `feature_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `feature_code` varchar(45) NOT NULL,
  `feature_name` varchar(45) NOT NULL,
  PRIMARY KEY (`feature_id`),
  UNIQUE KEY `feature_code_UNIQUE` (`feature_code`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `feature`
--

LOCK TABLES `feature` WRITE;
/*!40000 ALTER TABLE `feature` DISABLE KEYS */;
INSERT INTO `feature` VALUES (1,'ALARM','Alarm'),(2,'ALARM_SMS','SMS alarm'),(3,'VIDEORECORDING','Videorecording'),(4,'ALARM_VIDEORECORDING','Alarm videorecording'),(5,'STORAGE_QUOTA_SIZE','Storage quota size'),(6,'VALIDITY','Validity'),(7,'MAX_DEVICE_COUNT','Max device count'),(8,'LANDEVICE_FREE_PERIOD','Device free period'),(9,'LANDEVICE_CHARGING_PERIOD','Device charging period'),(10,'CURRENCY','Currency'),(11,'AMOUNT','Amount'),(12,'CHARGING','Payment is on'),(13,'ACTIVATION_METHOD','Activation method'),(14,'STORAGE_QUOTA_COUNT','Storage quota count'),(15,'MAC_BASED_ACTIVATION','Mac based activation'),(16,'LANDEVICE_VALIDITY','Device validity period'),(17,'LANDEVICE_VALIDITY_END_ACTION',' '),(18,'VALIDITY_EXPIRY_SOON_EMAIL_TEMPLATE','Email template for validity expiry approach'),(19,'VALIDITY_EXPIRED_EMAIL_TEMPLATE','Email template for validity expired'),(20,'PRODUCT_BASIC','Basic product ID'),(21,'PRODUCT_TRIAL','Trial product ID'),(22,'PRODUCT_PREMIUM','Premium product ID'),(23,'AUTOMATIC_TRIAL','Automatic trial'),(24,'PRODUCT_WELCOME_EMAIL_TEMPLATE','PRODUCT_WELCOME_EMAIL_TEMPLATE'),(25,'PAYMENT_CONFIRMATION_NEW_EMAIL_TEMPLATE','PAYMENT_CONFIRMATION_NEW_EMAIL_TEMPLATE'),(26,'PAYMENT_CONFIRMATION_CONT_EMAIL_TEMPLATE','PAYMENT_CONFIRMATION_CONT_EMAIL_TEMPLATE'),(27,'MAX_VIDEO_QUALITY','Max video quality'),(28,'PANTILT','Pan/Titl suppport'),(29,'CAMERALED','Illumination'),(30,'PRIVACYBUTTON','Privacy button'),(31,'PLAYBACK','Events playback');
/*!40000 ALTER TABLE `feature` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gateway_client_version`
--

DROP TABLE IF EXISTS `gateway_client_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gateway_client_version` (
  `gateway_client_version_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mac_prefix` varchar(255) NOT NULL,
  `min_version` varchar(255) NOT NULL,
  PRIMARY KEY (`gateway_client_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gateway_client_version`
--

LOCK TABLES `gateway_client_version` WRITE;
/*!40000 ALTER TABLE `gateway_client_version` DISABLE KEYS */;
/*!40000 ALTER TABLE `gateway_client_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gatewayclient`
--

DROP TABLE IF EXISTS `gatewayclient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gatewayclient` (
  `gateway_client_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `mac` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `serial_number` varchar(255) DEFAULT NULL,
  `activation_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modification_date` timestamp NULL DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `device_type` int(11) DEFAULT NULL,
  `log_conf` text,
  `upnp_port` int(11) DEFAULT '0',
  `upnp_reason` varchar(100) DEFAULT 'none',
  `version` varchar(20) DEFAULT NULL,
  `build_no` int(11) DEFAULT NULL,
  `connected_date` timestamp NULL DEFAULT NULL,
  `disconnected_date` timestamp NULL DEFAULT NULL,
  `upnp_address` varchar(256) DEFAULT NULL,
  `domain_record_id` int(11) DEFAULT NULL,
  `local_address_dns` varchar(256) DEFAULT NULL,
  `local_domain_record_id` int(11) DEFAULT NULL,
  `force_reboot` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`gateway_client_id`),
  KEY `gatewayclient__user_id_fkey` (`user_id`),
  KEY `gatewayclient_mac_key` (`mac`),
  CONSTRAINT `gatewayclient__user_id_fkey` FOREIGN KEY (`user_id`) REFERENCES `user_` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gatewayclient`
--

LOCK TABLES `gatewayclient` WRITE;
/*!40000 ALTER TABLE `gatewayclient` DISABLE KEYS */;
/*!40000 ALTER TABLE `gatewayclient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gatewayclientsession`
--

DROP TABLE IF EXISTS `gatewayclientsession`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gatewayclientsession` (
  `gateway_client_session_id` int(11) NOT NULL AUTO_INCREMENT,
  `public_ip` varchar(15) NOT NULL,
  `mac` varchar(255) NOT NULL,
  `connected_date` datetime NOT NULL,
  `version` varchar(20) DEFAULT NULL,
  `build_no` int(11) DEFAULT NULL,
  `last_alive` datetime NOT NULL,
  `encrypted` tinyint(1) NOT NULL,
  `server_url` varchar(512) DEFAULT NULL,
  PRIMARY KEY (`gateway_client_session_id`),
  UNIQUE KEY `mac_2` (`mac`),
  UNIQUE KEY `mac_uniue` (`mac`),
  KEY `mac` (`mac`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gatewayclientsession`
--

LOCK TABLES `gatewayclientsession` WRITE;
/*!40000 ALTER TABLE `gatewayclientsession` DISABLE KEYS */;
INSERT INTO `gatewayclientsession` VALUES (6,'10.8.5.92','00:02:D1:1B:9F:0E','2015-06-18 09:52:48','3.9',440,'2015-06-18 09:52:48',1,'http://127.0.0.1:7403');
/*!40000 ALTER TABLE `gatewayclientsession` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `landevice`
--

DROP TABLE IF EXISTS `landevice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `landevice` (
  `landevice_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_client_id` int(11) unsigned NOT NULL,
  `devicedesc_id` int(11) NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `name` varchar(100) NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `location` varchar(200) DEFAULT NULL,
  `added_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_date` timestamp NULL DEFAULT NULL,
  `deleted_date` timestamp NULL DEFAULT NULL,
  `mac` varchar(255) DEFAULT NULL,
  `ip_address` varchar(15) NOT NULL,
  `port` int(11) NOT NULL,
  `user_` varchar(100) DEFAULT NULL,
  `pass` varchar(100) NOT NULL,
  `version` varchar(45) DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `configuration_status` varchar(45) DEFAULT NULL,
  `valid_to` date NOT NULL,
  `upgrade_date` datetime DEFAULT NULL,
  `upgrade_status` varchar(10) DEFAULT NULL,
  `model` varchar(100) DEFAULT NULL,
  `video_encoding` enum('MJPEG','MPEG4','H264') NOT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `product_date` date DEFAULT NULL,
  `trial_product_date` date DEFAULT NULL,
  `params` text,
  `token` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`landevice_id`),
  UNIQUE KEY `landevice_token_uniqu` (`token`),
  KEY `landevice__gateway_client_id_fkey` (`gateway_client_id`),
  KEY `landevice__devicedesc_id_fkey` (`devicedesc_id`),
  KEY `landevice__user_id_fkey` (`user_id`),
  KEY `landevice_product_id_fkey` (`product_id`),
  CONSTRAINT `landevice_product_id_fkey` FOREIGN KEY (`product_id`) REFERENCES `product` (`product_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `landevice__devicedesc_id_fkey` FOREIGN KEY (`devicedesc_id`) REFERENCES `devicedesc` (`devicedesc_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `landevice__gateway_client_id_fkey` FOREIGN KEY (`gateway_client_id`) REFERENCES `gatewayclient` (`gateway_client_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `landevice__user_id_fkey` FOREIGN KEY (`user_id`) REFERENCES `user_` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `landevice`
--

LOCK TABLES `landevice` WRITE;
/*!40000 ALTER TABLE `landevice` DISABLE KEYS */;
/*!40000 ALTER TABLE `landevice` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `landeviceproductlog`
--

DROP TABLE IF EXISTS `landeviceproductlog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `landeviceproductlog` (
  `landeviceproductlog_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `landevice_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`landeviceproductlog_id`),
  KEY `landeviceproductlog_landevice_id_fkey` (`landevice_id`),
  KEY `landeviceproductlog_product_id_fkey` (`product_id`),
  CONSTRAINT `landeviceproductlog_landevice_id_fkey` FOREIGN KEY (`landevice_id`) REFERENCES `landevice` (`landevice_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `landeviceproductlog_product_id_fkey` FOREIGN KEY (`product_id`) REFERENCES `product` (`product_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `landeviceproductlog`
--

LOCK TABLES `landeviceproductlog` WRITE;
/*!40000 ALTER TABLE `landeviceproductlog` DISABLE KEYS */;
/*!40000 ALTER TABLE `landeviceproductlog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `message`
--

DROP TABLE IF EXISTS `message`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `message` (
  `message_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `text` varchar(2000) NOT NULL,
  `url` varchar(255) DEFAULT NULL,
  `lang` varchar(2) NOT NULL,
  `min_version` varchar(10) DEFAULT NULL,
  `max_version` varchar(10) NOT NULL,
  `platform` varchar(10) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`message_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `message`
--

LOCK TABLES `message` WRITE;
/*!40000 ALTER TABLE `message` DISABLE KEYS */;
/*!40000 ALTER TABLE `message` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notificationtoken`
--

DROP TABLE IF EXISTS `notificationtoken`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notificationtoken` (
  `notificationtoken_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `type` varchar(5) COLLATE utf8_bin NOT NULL,
  `recipient` varchar(255) COLLATE utf8_bin NOT NULL,
  `token` varchar(45) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`notificationtoken_id`),
  UNIQUE KEY `token_UNIQUE` (`token`),
  KEY `notificationtoken_userid_fkey` (`user_id`),
  CONSTRAINT `notificationtoken_userid_fkey` FOREIGN KEY (`user_id`) REFERENCES `user_` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notificationtoken`
--

LOCK TABLES `notificationtoken` WRITE;
/*!40000 ALTER TABLE `notificationtoken` DISABLE KEYS */;
/*!40000 ALTER TABLE `notificationtoken` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `parameter`
--

DROP TABLE IF EXISTS `parameter`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `parameter` (
  `parameter_id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(64) NOT NULL,
  `value` varchar(400) DEFAULT NULL,
  PRIMARY KEY (`parameter_id`),
  UNIQUE KEY `code_UNIQUE` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `parameter`
--

LOCK TABLES `parameter` WRITE;
/*!40000 ALTER TABLE `parameter` DISABLE KEYS */;
INSERT INTO `parameter` VALUES (1,'apns.certificatePass','test1234ABC'),(2,'apns.devMode','OFF'),(3,'autoUniqueFullName','OFF'),(4,'conv.options.jpg','-ss 0 -vcodec mjpeg -vframes 1 -s %RESOLUTION% -f image2'),(5,'conv.options.mp4','-ss 0 -vcodec libx264 -s 640x480 -flags +loop -crf 24 -bt 256k -refs 1 -coder 0 -me_range 16 -subq 5 -partitions +parti4x4+parti8x8+partp8x8 -g 250 -keyint_min 25 -level 30 -qmin 10 -qmax 51 -trellis 2 -sc_threshold 40 -i_qfactor 0.71 -vf yadif -deinterlace -strict -2 -ab 32k'),(6,'conv.options.mp4_audio','-vcodec copy -strict -2 -ab 32k'),(7,'device.registerToManyAccounts','ON'),(8,'devicedriver.name','NAS'),(9,'dnsimple.domain','aladdin-system.com'),(10,'dnsimple.endpoint','https://api.dnsimple.com/v1'),(11,'dnsimple.token','02c15039f6365d808f7b556e8b86c331'),(12,'gatewayClient.dnsGate','dnsimple'),(13,'gatewayClient.localDomainAddressDns','on'),(14,'gatewayClient.upnpAddressDns','on'),(15,'gdclient.forcereboot.maxversion','2.7'),(16,'gdclient.scriptsdir.minversion','3.3'),(17,'gdserver.addresses','http://localhost:7403'),(18,'ice.enable','ON'),(19,'ice.relayIp','relay.remote-nas.com'),(20,'ice.relayPort','1443'),(21,'ice.relayPortTLS','443'),(22,'ice.stunaddr','91.214.169.223'),(23,'ice.stunport','34780'),(24,'ice.turnaddr','192.168.0.5'),(25,'ice.turnpassword','test'),(26,'ice.turnport','0'),(27,'ice.turnusername','test'),(28,'invalidSession.enabled','OFF'),(29,'invalidSession.lockPeriod.minutes','1'),(30,'invalidSession.maxAttemptCount','5'),(31,'invalidSession.untrackedUrls','/app/hm/user/register;/app/hm/user/authenticate;/app/hm/user/login;/app/hm/version;/app/hm/dyndns/verify;/app/hm/dyndns;/app/hm/dyndns/set'),(32,'lanDevice.autoCorrectConfig','ON'),(33,'lanDevice.disableRootPassGeneration','ON'),(34,'lanDevice.eventMaxDuration','900'),(35,'lanDevice.noCameraIpCheck','ON'),(36,'lanDevice.recordingMaxTotalDuration','7200'),(37,'lanDevice.verifyIpAddressCyclicPeriod','1h'),(38,'lanDevice.verifyIpAddressWhenGCConnecedPeriod','4h'),(39,'registration.noFirstAndLastName','ON'),(40,'userAuthentication.lockPeriod','600000'),(41,'userAuthentication.maxAttemptCount','30'),(42,'userAuthentication.oneSessionMode','OFF'),(43,'userAuthentication.passwordExpirationInterval.days','0'),(44,'registration.phoneNumberRequired','ON'),(45,'productManagement.defaultProductId','1'),(46,'registration.noCaptcha','ON'),(47,'registration.noConfirmation','ON'),(48,'registration.noAdditionalData','ON'),(49,'landevice.rtspStreaming','ON');
/*!40000 ALTER TABLE `parameter` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product`
--

DROP TABLE IF EXISTS `product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product` (
  `product_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(45) NOT NULL,
  `valid_from` datetime NOT NULL,
  `valid_to` datetime NOT NULL,
  `code` varchar(45) NOT NULL,
  PRIMARY KEY (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product`
--

LOCK TABLES `product` WRITE;
/*!40000 ALTER TABLE `product` DISABLE KEYS */;
INSERT INTO `product` VALUES (1,'test','2011-01-01 00:00:00','2011-12-31 23:59:59',''),(2,'basic','2011-01-01 00:00:00','2011-01-01 00:00:00','smartapps_basic'),(3,'trial','2011-01-01 00:00:00','2011-01-01 00:00:00','smartapps_trial'),(4,'premium','2011-01-01 00:00:00','2011-01-01 00:00:00','smartapps_premium');
/*!40000 ALTER TABLE `product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `productfeature`
--

DROP TABLE IF EXISTS `productfeature`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `productfeature` (
  `productfeature_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned NOT NULL,
  `feature_id` int(10) unsigned NOT NULL,
  `feature_value` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`productfeature_id`),
  KEY `productfeature_product_id_fkey` (`product_id`),
  KEY `productfeature_feature_id_fkey` (`feature_id`),
  CONSTRAINT `productfeature_feature_id_fkey` FOREIGN KEY (`feature_id`) REFERENCES `feature` (`feature_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `productfeature_product_id_fkey` FOREIGN KEY (`product_id`) REFERENCES `product` (`product_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `productfeature`
--

LOCK TABLES `productfeature` WRITE;
/*!40000 ALTER TABLE `productfeature` DISABLE KEYS */;
INSERT INTO `productfeature` VALUES (1,1,1,NULL),(2,1,2,NULL),(3,1,3,'value'),(4,1,4,NULL),(5,1,5,'1'),(6,1,6,'10'),(7,1,7,'999'),(8,1,8,'3m'),(9,1,9,'2m'),(10,1,10,'CHF'),(11,1,11,'49.00'),(12,1,12,'ON'),(13,1,13,'ANY'),(14,1,14,'100'),(16,1,15,'OFF'),(22,1,20,'smartapps_basic'),(23,1,21,'smartapps_trial'),(24,1,22,'smartapps_premium'),(25,1,23,'OFF'),(26,2,1,'OFF'),(27,2,3,'OFF'),(28,2,4,'OFF'),(29,2,5,'5'),(30,2,14,'20'),(31,3,1,'ON'),(32,3,3,'ON'),(33,3,4,'ON'),(34,3,16,'120m'),(35,3,17,'DOWNGRADE'),(36,3,5,'100'),(37,3,14,'1000'),(38,4,1,'ON'),(39,4,3,'ON'),(40,4,4,'ON'),(41,4,16,'12m'),(42,4,17,'DOWNGRADE'),(43,4,11,'49.00'),(44,4,5,'100'),(45,4,14,'1000'),(46,3,18,'TRIAL_CAMERA_VALIDITY_EXPIRY_APPROACH'),(47,4,18,'PREMIUM_CAMERA_VALIDITY_EXPIRY_APPROACH'),(48,3,19,'TRIAL_CAMERA_VALIDITY_EXPIRED'),(49,4,19,'PREMIUM_CAMERA_VALIDITY_EXPIRED'),(50,4,25,'PAYMENT_CONFIRMATION_NEW'),(51,4,26,'PAYMENT_CONFIRMATION_CONT'),(52,3,24,'TRIAL_WELCOME'),(53,2,27,'GOOD'),(54,2,28,'OFF'),(55,3,28,'ON'),(56,4,28,'ON'),(57,2,29,'OFF'),(58,3,29,'ON'),(59,4,29,'ON'),(60,2,30,'OFF'),(61,3,30,'ON'),(62,4,30,'ON'),(63,2,31,'ON'),(64,3,31,'ON'),(65,4,31,'ON');
/*!40000 ALTER TABLE `productfeature` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reportingdate`
--

DROP TABLE IF EXISTS `reportingdate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reportingdate` (
  `date_id` int(11) NOT NULL AUTO_INCREMENT,
  `date_date` date NOT NULL,
  PRIMARY KEY (`date_id`)
) ENGINE=InnoDB AUTO_INCREMENT=580 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reportingdate`
--

LOCK TABLES `reportingdate` WRITE;
/*!40000 ALTER TABLE `reportingdate` DISABLE KEYS */;
INSERT INTO `reportingdate` VALUES (1,'2011-06-01'),(2,'2011-06-02'),(3,'2011-06-03'),(4,'2011-06-04'),(5,'2011-06-05'),(6,'2011-06-06'),(7,'2011-06-07'),(8,'2011-06-08'),(9,'2011-06-09'),(10,'2011-06-10'),(11,'2011-06-11'),(12,'2011-06-12'),(13,'2011-06-13'),(14,'2011-06-14'),(15,'2011-06-15'),(16,'2011-06-16'),(17,'2011-06-17'),(18,'2011-06-18'),(19,'2011-06-19'),(20,'2011-06-20'),(21,'2011-06-21'),(22,'2011-06-22'),(23,'2011-06-23'),(24,'2011-06-24'),(25,'2011-06-25'),(26,'2011-06-26'),(27,'2011-06-27'),(28,'2011-06-28'),(29,'2011-06-29'),(30,'2011-06-30'),(31,'2011-07-01'),(32,'2011-07-02'),(33,'2011-07-03'),(34,'2011-07-04'),(35,'2011-07-05'),(36,'2011-07-06'),(37,'2011-07-07'),(38,'2011-07-08'),(39,'2011-07-09'),(40,'2011-07-10'),(41,'2011-07-11'),(42,'2011-07-12'),(43,'2011-07-13'),(44,'2011-07-14'),(45,'2011-07-15'),(46,'2011-07-16'),(47,'2011-07-17'),(48,'2011-07-18'),(49,'2011-07-19'),(50,'2011-07-20'),(51,'2011-07-21'),(52,'2011-07-22'),(53,'2011-07-23'),(54,'2011-07-24'),(55,'2011-07-25'),(56,'2011-07-26'),(57,'2011-07-27'),(58,'2011-07-28'),(59,'2011-07-29'),(60,'2011-07-30'),(61,'2011-07-31'),(62,'2011-08-01'),(63,'2011-08-02'),(64,'2011-08-03'),(65,'2011-08-04'),(66,'2011-08-05'),(67,'2011-08-06'),(68,'2011-08-07'),(69,'2011-08-08'),(70,'2011-08-09'),(71,'2011-08-10'),(72,'2011-08-11'),(73,'2011-08-12'),(74,'2011-08-13'),(75,'2011-08-14'),(76,'2011-08-15'),(77,'2011-08-16'),(78,'2011-08-17'),(79,'2011-08-18'),(80,'2011-08-19'),(81,'2011-08-20'),(82,'2011-08-21'),(83,'2011-08-22'),(84,'2011-08-23'),(85,'2011-08-24'),(86,'2011-08-25'),(87,'2011-08-26'),(88,'2011-08-27'),(89,'2011-08-28'),(90,'2011-08-29'),(91,'2011-08-30'),(92,'2011-08-31'),(93,'2011-09-01'),(94,'2011-09-02'),(95,'2011-09-03'),(96,'2011-09-04'),(97,'2011-09-05'),(98,'2011-09-06'),(99,'2011-09-07'),(100,'2011-09-08'),(101,'2011-09-09'),(102,'2011-09-10'),(103,'2011-09-11'),(104,'2011-09-12'),(105,'2011-09-13'),(106,'2011-09-14'),(107,'2011-09-15'),(108,'2011-09-16'),(109,'2011-09-17'),(110,'2011-09-18'),(111,'2011-09-19'),(112,'2011-09-20'),(113,'2011-09-21'),(114,'2011-09-22'),(115,'2011-09-23'),(116,'2011-09-24'),(117,'2011-09-25'),(118,'2011-09-26'),(119,'2011-09-27'),(120,'2011-09-28'),(121,'2011-09-29'),(122,'2011-09-30'),(123,'2011-10-01'),(124,'2011-10-02'),(125,'2011-10-03'),(126,'2011-10-04'),(127,'2011-10-05'),(128,'2011-10-06'),(129,'2011-10-07'),(130,'2011-10-08'),(131,'2011-10-09'),(132,'2011-10-10'),(133,'2011-10-11'),(134,'2011-10-12'),(135,'2011-10-13'),(136,'2011-10-14'),(137,'2011-10-15'),(138,'2011-10-16'),(139,'2011-10-17'),(140,'2011-10-18'),(141,'2011-10-19'),(142,'2011-10-20'),(143,'2011-10-21'),(144,'2011-10-22'),(145,'2011-10-23'),(146,'2011-10-24'),(147,'2011-10-25'),(148,'2011-10-26'),(149,'2011-10-27'),(150,'2011-10-28'),(151,'2011-10-29'),(152,'2011-10-30'),(153,'2011-10-31'),(154,'2011-11-01'),(155,'2011-11-02'),(156,'2011-11-03'),(157,'2011-11-04'),(158,'2011-11-05'),(159,'2011-11-06'),(160,'2011-11-07'),(161,'2011-11-08'),(162,'2011-11-09'),(163,'2011-11-10'),(164,'2011-11-11'),(165,'2011-11-12'),(166,'2011-11-13'),(167,'2011-11-14'),(168,'2011-11-15'),(169,'2011-11-16'),(170,'2011-11-17'),(171,'2011-11-18'),(172,'2011-11-19'),(173,'2011-11-20'),(174,'2011-11-21'),(175,'2011-11-22'),(176,'2011-11-23'),(177,'2011-11-24'),(178,'2011-11-25'),(179,'2011-11-26'),(180,'2011-11-27'),(181,'2011-11-28'),(182,'2011-11-29'),(183,'2011-11-30'),(184,'2011-12-01'),(185,'2011-12-02'),(186,'2011-12-03'),(187,'2011-12-04'),(188,'2011-12-05'),(189,'2011-12-06'),(190,'2011-12-07'),(191,'2011-12-08'),(192,'2011-12-09'),(193,'2011-12-10'),(194,'2011-12-11'),(195,'2011-12-12'),(196,'2011-12-13'),(197,'2011-12-14'),(198,'2011-12-15'),(199,'2011-12-16'),(200,'2011-12-17'),(201,'2011-12-18'),(202,'2011-12-19'),(203,'2011-12-20'),(204,'2011-12-21'),(205,'2011-12-22'),(206,'2011-12-23'),(207,'2011-12-25'),(208,'2011-12-26'),(209,'2011-12-27'),(210,'2011-12-28'),(211,'2011-12-29'),(212,'2011-12-30'),(213,'2011-12-31'),(214,'2012-01-01'),(215,'2012-01-02'),(216,'2012-01-03'),(217,'2012-01-04'),(218,'2012-01-05'),(219,'2012-01-06'),(220,'2012-01-07'),(221,'2012-01-08'),(222,'2012-01-09'),(223,'2012-01-10'),(224,'2012-01-11'),(225,'2012-01-12'),(226,'2012-01-13'),(227,'2012-01-14'),(228,'2012-01-15'),(229,'2012-01-16'),(230,'2012-01-17'),(231,'2012-01-18'),(232,'2012-01-19'),(233,'2012-01-20'),(234,'2012-01-21'),(235,'2012-01-22'),(236,'2012-01-23'),(237,'2012-01-24'),(238,'2012-01-25'),(239,'2012-01-26'),(240,'2012-01-27'),(241,'2012-01-28'),(242,'2012-01-29'),(243,'2012-01-30'),(244,'2012-01-31'),(245,'2012-02-01'),(246,'2012-02-02'),(247,'2012-02-03'),(248,'2012-02-04'),(249,'2012-02-05'),(250,'2012-02-06'),(251,'2012-02-07'),(252,'2012-02-08'),(253,'2012-02-09'),(254,'2012-02-10'),(255,'2012-02-11'),(256,'2012-02-12'),(257,'2012-02-13'),(258,'2012-02-14'),(259,'2012-02-15'),(260,'2012-02-16'),(261,'2012-02-17'),(262,'2012-02-18'),(263,'2012-02-19'),(264,'2012-02-20'),(265,'2012-02-21'),(266,'2012-02-22'),(267,'2012-02-23'),(268,'2012-02-24'),(269,'2012-02-25'),(270,'2012-02-26'),(271,'2012-02-27'),(272,'2012-02-28'),(273,'2012-02-29'),(274,'2012-03-01'),(275,'2012-03-02'),(276,'2012-03-03'),(277,'2012-03-04'),(278,'2012-03-05'),(279,'2012-03-06'),(280,'2012-03-07'),(281,'2012-03-08'),(282,'2012-03-09'),(283,'2012-03-10'),(284,'2012-03-11'),(285,'2012-03-12'),(286,'2012-03-13'),(287,'2012-03-14'),(288,'2012-03-15'),(289,'2012-03-16'),(290,'2012-03-17'),(291,'2012-03-18'),(292,'2012-03-19'),(293,'2012-03-20'),(294,'2012-03-21'),(295,'2012-03-22'),(296,'2012-03-23'),(297,'2012-03-24'),(298,'2012-03-25'),(299,'2012-03-26'),(300,'2012-03-27'),(301,'2012-03-28'),(302,'2012-03-29'),(303,'2012-03-30'),(304,'2012-03-31'),(305,'2012-04-01'),(306,'2012-04-02'),(307,'2012-04-03'),(308,'2012-04-04'),(309,'2012-04-05'),(310,'2012-04-06'),(311,'2012-04-07'),(312,'2012-04-08'),(313,'2012-04-09'),(314,'2012-04-10'),(315,'2012-04-11'),(316,'2012-04-12'),(317,'2012-04-13'),(318,'2012-04-14'),(319,'2012-04-15'),(320,'2012-04-16'),(321,'2012-04-17'),(322,'2012-04-18'),(323,'2012-04-19'),(324,'2012-04-20'),(325,'2012-04-21'),(326,'2012-04-22'),(327,'2012-04-23'),(328,'2012-04-24'),(329,'2012-04-25'),(330,'2012-04-26'),(331,'2012-04-27'),(332,'2012-04-28'),(333,'2012-04-29'),(334,'2012-04-30'),(335,'2012-05-01'),(336,'2012-05-02'),(337,'2012-05-03'),(338,'2012-05-04'),(339,'2012-05-05'),(340,'2012-05-06'),(341,'2012-05-07'),(342,'2012-05-08'),(343,'2012-05-09'),(344,'2012-05-10'),(345,'2012-05-11'),(346,'2012-05-12'),(347,'2012-05-13'),(348,'2012-05-14'),(349,'2012-05-15'),(350,'2012-05-16'),(351,'2012-05-17'),(352,'2012-05-18'),(353,'2012-05-19'),(354,'2012-05-20'),(355,'2012-05-21'),(356,'2012-05-22'),(357,'2012-05-23'),(358,'2012-05-24'),(359,'2012-05-25'),(360,'2012-05-26'),(361,'2012-05-27'),(362,'2012-05-28'),(363,'2012-05-29'),(364,'2012-05-30'),(365,'2012-05-31'),(366,'2012-06-01'),(367,'2012-06-02'),(368,'2012-06-03'),(369,'2012-06-04'),(370,'2012-06-05'),(371,'2012-06-06'),(372,'2012-06-07'),(373,'2012-06-08'),(374,'2012-06-09'),(375,'2012-06-10'),(376,'2012-06-11'),(377,'2012-06-12'),(378,'2012-06-13'),(379,'2012-06-14'),(380,'2012-06-15'),(381,'2012-06-16'),(382,'2012-06-17'),(383,'2012-06-18'),(384,'2012-06-19'),(385,'2012-06-20'),(386,'2012-06-21'),(387,'2012-06-22'),(388,'2012-06-23'),(389,'2012-06-24'),(390,'2012-06-25'),(391,'2012-06-26'),(392,'2012-06-27'),(393,'2012-06-28'),(394,'2012-06-29'),(395,'2012-06-30'),(396,'2012-07-01'),(397,'2012-07-02'),(398,'2012-07-03'),(399,'2012-07-04'),(400,'2012-07-05'),(401,'2012-07-06'),(402,'2012-07-07'),(403,'2012-07-08'),(404,'2012-07-09'),(405,'2012-07-10'),(406,'2012-07-11'),(407,'2012-07-12'),(408,'2012-07-13'),(409,'2012-07-14'),(410,'2012-07-15'),(411,'2012-07-16'),(412,'2012-07-17'),(413,'2012-07-18'),(414,'2012-07-19'),(415,'2012-07-20'),(416,'2012-07-21'),(417,'2012-07-22'),(418,'2012-07-23'),(419,'2012-07-24'),(420,'2012-07-25'),(421,'2012-07-26'),(422,'2012-07-27'),(423,'2012-07-28'),(424,'2012-07-29'),(425,'2012-07-30'),(426,'2012-07-31'),(427,'2012-08-01'),(428,'2012-08-02'),(429,'2012-08-03'),(430,'2012-08-04'),(431,'2012-08-05'),(432,'2012-08-06'),(433,'2012-08-07'),(434,'2012-08-08'),(435,'2012-08-09'),(436,'2012-08-10'),(437,'2012-08-11'),(438,'2012-08-12'),(439,'2012-08-13'),(440,'2012-08-14'),(441,'2012-08-15'),(442,'2012-08-16'),(443,'2012-08-17'),(444,'2012-08-18'),(445,'2012-08-19'),(446,'2012-08-20'),(447,'2012-08-21'),(448,'2012-08-22'),(449,'2012-08-23'),(450,'2012-08-24'),(451,'2012-08-25'),(452,'2012-08-26'),(453,'2012-08-27'),(454,'2012-08-28'),(455,'2012-08-29'),(456,'2012-08-30'),(457,'2012-08-31'),(458,'2012-09-01'),(459,'2012-09-02'),(460,'2012-09-03'),(461,'2012-09-04'),(462,'2012-09-05'),(463,'2012-09-06'),(464,'2012-09-07'),(465,'2012-09-08'),(466,'2012-09-09'),(467,'2012-09-10'),(468,'2012-09-11'),(469,'2012-09-12'),(470,'2012-09-13'),(471,'2012-09-14'),(472,'2012-09-15'),(473,'2012-09-16'),(474,'2012-09-17'),(475,'2012-09-18'),(476,'2012-09-19'),(477,'2012-09-20'),(478,'2012-09-21'),(479,'2012-09-22'),(480,'2012-09-23'),(481,'2012-09-24'),(482,'2012-09-25'),(483,'2012-09-26'),(484,'2012-09-27'),(485,'2012-09-28'),(486,'2012-09-29'),(487,'2012-09-30'),(488,'2012-10-01'),(489,'2012-10-02'),(490,'2012-10-03'),(491,'2012-10-04'),(492,'2012-10-05'),(493,'2012-10-06'),(494,'2012-10-07'),(495,'2012-10-08'),(496,'2012-10-09'),(497,'2012-10-10'),(498,'2012-10-11'),(499,'2012-10-12'),(500,'2012-10-13'),(501,'2012-10-14'),(502,'2012-10-15'),(503,'2012-10-16'),(504,'2012-10-17'),(505,'2012-10-18'),(506,'2012-10-19'),(507,'2012-10-20'),(508,'2012-10-21'),(509,'2012-10-22'),(510,'2012-10-23'),(511,'2012-10-24'),(512,'2012-10-25'),(513,'2012-10-26'),(514,'2012-10-27'),(515,'2012-10-28'),(516,'2012-10-29'),(517,'2012-10-30'),(518,'2012-10-31'),(519,'2012-11-01'),(520,'2012-11-02'),(521,'2012-11-03'),(522,'2012-11-04'),(523,'2012-11-05'),(524,'2012-11-06'),(525,'2012-11-07'),(526,'2012-11-08'),(527,'2012-11-09'),(528,'2012-11-10'),(529,'2012-11-11'),(530,'2012-11-12'),(531,'2012-11-13'),(532,'2012-11-14'),(533,'2012-11-15'),(534,'2012-11-16'),(535,'2012-11-17'),(536,'2012-11-18'),(537,'2012-11-19'),(538,'2012-11-20'),(539,'2012-11-21'),(540,'2012-11-22'),(541,'2012-11-23'),(542,'2012-11-24'),(543,'2012-11-25'),(544,'2012-11-26'),(545,'2012-11-27'),(546,'2012-11-28'),(547,'2012-11-29'),(548,'2012-11-30'),(549,'2012-12-01'),(550,'2012-12-02'),(551,'2012-12-03'),(552,'2012-12-04'),(553,'2012-12-05'),(554,'2012-12-06'),(555,'2012-12-07'),(556,'2012-12-08'),(557,'2012-12-09'),(558,'2012-12-10'),(559,'2012-12-11'),(560,'2012-12-12'),(561,'2012-12-13'),(562,'2012-12-14'),(563,'2012-12-15'),(564,'2012-12-16'),(565,'2012-12-17'),(566,'2012-12-18'),(567,'2012-12-19'),(568,'2012-12-20'),(569,'2012-12-21'),(570,'2012-12-22'),(571,'2012-12-23'),(572,'2012-12-24'),(573,'2012-12-25'),(574,'2012-12-26'),(575,'2012-12-27'),(576,'2012-12-28'),(577,'2012-12-29'),(578,'2012-12-30'),(579,'2012-12-31');
/*!40000 ALTER TABLE `reportingdate` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reportinghour`
--

DROP TABLE IF EXISTS `reportinghour`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reportinghour` (
  `hour_id` int(11) NOT NULL AUTO_INCREMENT,
  `hour` int(11) NOT NULL,
  PRIMARY KEY (`hour_id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reportinghour`
--

LOCK TABLES `reportinghour` WRITE;
/*!40000 ALTER TABLE `reportinghour` DISABLE KEYS */;
INSERT INTO `reportinghour` VALUES (1,0),(2,1),(3,2),(4,3),(5,4),(6,5),(7,6),(8,7),(9,8),(10,9),(11,10),(12,11),(13,12),(14,13),(15,14),(16,15),(17,16),(18,16),(19,18),(20,19),(21,20),(22,21),(23,22),(24,23);
/*!40000 ALTER TABLE `reportinghour` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `role` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(45) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name_UNIQUE` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` VALUES (1,'admin'),(2,'integration'),(3,'operator');
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_`
--

DROP TABLE IF EXISTS `share_`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `share_` (
  `share_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `landevice_id` int(11) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `name_` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`share_id`),
  KEY `fk_share_landevice` (`landevice_id`),
  KEY `fk_user_has_landevice_user1` (`user_id`),
  CONSTRAINT `fk_share_landevice` FOREIGN KEY (`landevice_id`) REFERENCES `landevice` (`landevice_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_share_user` FOREIGN KEY (`user_id`) REFERENCES `user_` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_`
--

LOCK TABLES `share_` WRITE;
/*!40000 ALTER TABLE `share_` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ssoparameter`
--

DROP TABLE IF EXISTS `ssoparameter`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ssoparameter` (
  `ssoparameter_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ssoservice_id` int(10) unsigned NOT NULL,
  `code` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`ssoparameter_id`),
  KEY `ssoservice_id_fkey` (`ssoservice_id`),
  CONSTRAINT `ssoservice_id_fkey` FOREIGN KEY (`ssoservice_id`) REFERENCES `ssoservice` (`ssoservice_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ssoparameter`
--

LOCK TABLES `ssoparameter` WRITE;
/*!40000 ALTER TABLE `ssoparameter` DISABLE KEYS */;
/*!40000 ALTER TABLE `ssoparameter` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ssoservice`
--

DROP TABLE IF EXISTS `ssoservice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ssoservice` (
  `ssoservice_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`ssoservice_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ssoservice`
--

LOCK TABLES `ssoservice` WRITE;
/*!40000 ALTER TABLE `ssoservice` DISABLE KEYS */;
/*!40000 ALTER TABLE `ssoservice` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transaction`
--

DROP TABLE IF EXISTS `transaction`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction` (
  `transaction_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `currency` varchar(3) CHARACTER SET latin1 NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `reference_nr` varchar(255) CHARACTER SET latin1 DEFAULT NULL,
  `status` varchar(45) CHARACTER SET latin1 DEFAULT NULL,
  `landevice_id` int(10) unsigned DEFAULT NULL,
  `valid_to` datetime DEFAULT NULL,
  `raw_response` text CHARACTER SET latin1,
  `gateway` enum('POSTFINANCE','DATATRANS') NOT NULL,
  `payment_type` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `transaction_user_id_fkey` (`user_id`),
  KEY `transaction_landevice_id_fkey` (`landevice_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transaction`
--

LOCK TABLES `transaction` WRITE;
/*!40000 ALTER TABLE `transaction` DISABLE KEYS */;
/*!40000 ALTER TABLE `transaction` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_`
--

DROP TABLE IF EXISTS `user_`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `password` varchar(100) DEFAULT NULL,
  `password_salt` varchar(255) DEFAULT NULL,
  `deleted` int(11) NOT NULL DEFAULT '0',
  `added_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted_date` timestamp NULL DEFAULT NULL,
  `activation_code` varchar(16) DEFAULT NULL,
  `change_password_code` varchar(16) DEFAULT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `firstname` varchar(255) NOT NULL,
  `lastname` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `town` varchar(100) NOT NULL,
  `zip_code` varchar(20) NOT NULL,
  `state` varchar(45) DEFAULT NULL,
  `country` varchar(45) NOT NULL,
  `language` varchar(2) NOT NULL,
  `log_conf` text,
  `mailing` tinyint(1) NOT NULL DEFAULT '0',
  `sso_id` varchar(100) DEFAULT NULL,
  `ssoservice_id` int(10) unsigned DEFAULT NULL,
  `password_creation_date` datetime DEFAULT NULL,
  `phone_number` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_unique_idx` (`username`,`deleted`),
  UNIQUE KEY `user_unique_email_idx` (`email`,`deleted`),
  KEY `user_product_id_fkey` (`product_id`),
  KEY `user_ssoservice_id_fkey` (`ssoservice_id`),
  CONSTRAINT `user_product_id_fkey` FOREIGN KEY (`product_id`) REFERENCES `product` (`product_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `user_ssoservice_id_fkey` FOREIGN KEY (`ssoservice_id`) REFERENCES `ssoservice` (`ssoservice_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_`
--

LOCK TABLES `user_` WRITE;
/*!40000 ALTER TABLE `user_` DISABLE KEYS */;
INSERT INTO `user_` VALUES (1,'admin','admin@vestiacom.com','useQPxUZmS3BJtAtJPlOHX/ghJ4MXNCeKh2fhf8n/fY=','4E8FwGrB46JwWffjoppIjGvSZzUDOBBoH++0nANvZUWFZ9xfHxu4FaO9RMmNx6I+4SufLbnQBgs4YgT9wNsMDG8QHP5QqbpKuXSW/UfKNg/7PFyrL0x2rsMIrGiSADOALI5YFJHO8HqKBlNzjkxIqgBqg1ASjg0asPNjBCaOadw=',0,'2014-10-28 09:45:29',NULL,NULL,NULL,1,'admin','admin','','','','','','',NULL,0,NULL,NULL,'2014-10-28 10:45:29',NULL);
/*!40000 ALTER TABLE `user_` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `userproductlog`
--

DROP TABLE IF EXISTS `userproductlog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `userproductlog` (
  `userproductlog_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`userproductlog_id`),
  KEY `userproductlog_user_id_fkey` (`user_id`),
  KEY `userproductlog_product_id_fkey` (`product_id`),
  CONSTRAINT `userproductlog_product_id_fkey` FOREIGN KEY (`product_id`) REFERENCES `product` (`product_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `userproductlog_user_id_fkey` FOREIGN KEY (`user_id`) REFERENCES `user_` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `userproductlog`
--

LOCK TABLES `userproductlog` WRITE;
/*!40000 ALTER TABLE `userproductlog` DISABLE KEYS */;
/*!40000 ALTER TABLE `userproductlog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `userrole`
--

DROP TABLE IF EXISTS `userrole`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `userrole` (
  `user_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `userrole__user_id_fkey` (`user_id`),
  KEY `userrole__role_id_fkey` (`role_id`),
  CONSTRAINT `userrole__role_id_fkey` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `userrole__user_id_fkey` FOREIGN KEY (`user_id`) REFERENCES `user_` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `userrole`
--

LOCK TABLES `userrole` WRITE;
/*!40000 ALTER TABLE `userrole` DISABLE KEYS */;
INSERT INTO `userrole` VALUES (1,1);
/*!40000 ALTER TABLE `userrole` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2015-06-22  7:43:51
