#!/bin/sh

HMPATH="/opt/aladdin/GDTServer"
LOGPATH="/var/opt/aladdin/logs"
PIDFILE="$HMPATH/gdtserver.pid"

APPSERVER_REST_PORT="8080"
GC_UDP_PORT="8300"
CTRL_PORT="8500"
RELAY_PORT="1443"
GC_UDP_PORT_IFACE_NAME="eth0"
GDTSERVER_OPTS="--enable-streams --rest-port=$APPSERVER_REST_PORT --gc-port=$GC_UDP_PORT --ctrl-port=$CTRL_PORT --proxy-port=$RELAY_PORT $GC_UDP_PORT_IFACE_NAME"

case "$1" in
	start)
		cd $HMPATH/conf
		LD_LIBRARY_PATH="$HMPATH/lib/vlc_libs" nohup $HMPATH/bin/GDTServer $GDTSERVER_OPTS > $LOGPATH/gdtserver.log 2>&1 &
		echo $! > $PIDFILE
		;;

	stop)
		kill $(cat $PIDFILE)
		;;

	*)
		echo "Usage: $0 {start|stop}"
		;;
esac

exit 0

