/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client.validators.strings;

import java.util.List;

import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.TextBox;

import eu.maydu.gwt.validation.client.ValidationAction;
import eu.maydu.gwt.validation.client.ValidationResult;
import eu.maydu.gwt.validation.client.Validator;
import eu.maydu.gwt.validation.client.i18n.ValidationMessages;

/**
 * Validates names.
 * 
 * Names mustn't contain any of the following characters []()/&%$\"!^+#*',<>|.
 * 
 * @author Anatol Mayen
 *
 */
public class NameValidator extends Validator<NameValidator>{

	protected String forbidden = "[]()/&%$\"!^+#*',<>|\\?~";
	
	private CharacterValidator charValidator;
	
	public NameValidator(TextBox text) {
		charValidator = new CharacterValidator(text, forbidden, false);
	}
	
	public NameValidator(SuggestBox text) {
		charValidator = new CharacterValidator(text, forbidden, false);
	}
	
	@Override
	public void invokeActions(ValidationResult result) {
		charValidator.invokeActions(result);
	}

	@Override
	public <V extends ValidationMessages> ValidationResult validate(V messages) {
		return charValidator.validate(messages);
	}
	
	public NameValidator addActionForFailure(ValidationAction action) {
		charValidator.addActionForFailure(action);
		return this;
	}
	
	public List<ValidationAction> getFailureActions() {
		return charValidator.getFailureActions();
	}
	
	public void resetActions() {
		charValidator.resetActions();
	}
	

}
