package eu.maydu.gwt.validation.client.validators.standard;

import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.TextBox;

import eu.maydu.gwt.validation.client.ValidationAction;
import eu.maydu.gwt.validation.client.ValidationResult;
import eu.maydu.gwt.validation.client.Validator;
import eu.maydu.gwt.validation.client.i18n.ValidationMessages;

/**
 * A dummy validator that provides two modes:
 * 
 * - Always succeed
 * - Always fail
 * 
 * 
 * Useful for testing server side validations (use Always succeed mode).
 * 
 * 
 * @author Anatol Mayen
 *
 */
public class DummyValidator extends Validator<DummyValidator> {

	protected TextBox text;
	protected SuggestBox suggest;
	protected CheckBox check;
	private boolean alwaysFail;
	
	/**
	 * Always succeeding dummy validator
	 * 
	 * @param text
	 */
	public DummyValidator(TextBox text) {
		this(text, false);
	}
	
	/**
	 * Dummy validator that always succeeds or never succeeds depending
	 * on the <code>alwaysFail<code> flag.
	 * 
	 * @param text
	 * @param alwaysFail
	 */
	public DummyValidator(TextBox text, boolean alwaysFail) {
		this.text = text;
		this.alwaysFail = alwaysFail;
	}
	
	/**
	 * Always succeeding dummy validator
	 * 
	 * @param suggest
	 */
	public DummyValidator(SuggestBox suggest) {
		this(suggest, false);
	}
	
	/**
	 * Dummy validator that always succeeds or never succeeds depending
	 * on the <code>alwaysFail<code> flag.
	 * 
	 * @param suggest
	 * @param alwaysFail
	 */
	public DummyValidator(SuggestBox suggest, boolean alwaysFail) {
		this.suggest = suggest;
		this.alwaysFail = alwaysFail;
	}
	
	/**
	 * Dummy validator that always succeeds or never succeeds depending
	 * on the <code>alwaysFail<code> flag.
	 * 
	 * @param suggest
	 * @param alwaysFail
	 */
	public DummyValidator(CheckBox check, boolean alwaysFail) {
		this.check = check;
		this.alwaysFail = alwaysFail;
	}
	
	
	/**
	 * Always succeeding dummy validator
	 * 
	 * @param suggest
	 */
	public DummyValidator(CheckBox check) {
		this(check, false);
	}
	

	
	@Override
	public void invokeActions(ValidationResult result) {
		for(ValidationAction action : failureActions) {
			if(text != null)
				action.invoke(result, text);
			else if(suggest != null) action.invoke(result, suggest);
			else action.invoke(result, check);
		}
		
	}

	@Override
	public <V extends ValidationMessages> ValidationResult validate(V messages) {
		if(!alwaysFail)
			return null;
		else return new ValidationResult("Failed");
	}

}
