/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core.authority;

import java.util.Collections;
import java.util.List;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.MutableGrantedAuthoritiesContainer;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrantedAuthoritiesContainerImpl
implements MutableGrantedAuthoritiesContainer {
    private List<GrantedAuthority> authorities;

    @Override
    public void setGrantedAuthorities(List<GrantedAuthority> newAuthorities) {
        this.authorities = Collections.unmodifiableList(newAuthorities);
    }

    @Override
    public List<GrantedAuthority> getGrantedAuthorities() {
        Assert.notNull(this.authorities, (String)"Granted authorities have not been set");
        return this.authorities;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Authorities: ").append(this.authorities);
        return sb.toString();
    }
}

