/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.vote;

import java.util.Collection;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.vote.AbstractAccessDecisionManager;
import org.springframework.security.core.Authentication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsensusBased
extends AbstractAccessDecisionManager {
    private boolean allowIfEqualGrantedDeniedDecisions = true;

    @Override
    public void decide(Authentication authentication, Object object, Collection<ConfigAttribute> configAttributes) throws AccessDeniedException {
        int grant = 0;
        int deny = 0;
        int abstain = 0;
        block4: for (AccessDecisionVoter voter : this.getDecisionVoters()) {
            int result = voter.vote(authentication, object, configAttributes);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Voter: " + voter + ", returned: " + result));
            }
            switch (result) {
                case 1: {
                    ++grant;
                    continue block4;
                }
                case -1: {
                    ++deny;
                    continue block4;
                }
            }
            ++abstain;
        }
        if (grant > deny) {
            return;
        }
        if (deny > grant) {
            throw new AccessDeniedException(this.messages.getMessage("AbstractAccessDecisionManager.accessDenied", "Access is denied"));
        }
        if (grant == deny && grant != 0) {
            if (this.allowIfEqualGrantedDeniedDecisions) {
                return;
            }
            throw new AccessDeniedException(this.messages.getMessage("AbstractAccessDecisionManager.accessDenied", "Access is denied"));
        }
        this.checkAllowIfAllAbstainDecisions();
    }

    public boolean isAllowIfEqualGrantedDeniedDecisions() {
        return this.allowIfEqualGrantedDeniedDecisions;
    }

    public void setAllowIfEqualGrantedDeniedDecisions(boolean allowIfEqualGrantedDeniedDecisions) {
        this.allowIfEqualGrantedDeniedDecisions = allowIfEqualGrantedDeniedDecisions;
    }
}

