/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rsa;

import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.math.FlexiBigInt;

public class RSAKeyGenParameterSpec
extends java.security.spec.RSAKeyGenParameterSpec
implements AlgorithmParameterSpec {
    public static final int DEFAULT_KEY_SIZE = 1024;
    public static final FlexiBigInt DEFAULT_EXPONENT = new FlexiBigInt(java.security.spec.RSAKeyGenParameterSpec.F4);

    public RSAKeyGenParameterSpec() {
        this(1024, DEFAULT_EXPONENT);
    }

    public RSAKeyGenParameterSpec(int keySize) {
        this(keySize, DEFAULT_EXPONENT);
    }

    public RSAKeyGenParameterSpec(int keySize, FlexiBigInt e) {
        super(keySize, e.bigInt);
    }

    public int getKeySize() {
        int keySize = this.getKeysize();
        if (keySize < 512) {
            return 1024;
        }
        return keySize;
    }

    public FlexiBigInt getE() {
        FlexiBigInt e = new FlexiBigInt(this.getPublicExponent());
        if (!e.testBit(0)) {
            return DEFAULT_EXPONENT;
        }
        return e;
    }
}

