/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.mprsa;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.keys.KeyPair;
import de.flexiprovider.api.keys.KeyPairGenerator;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.core.mprsa.MpRSAKeyGenParameterSpec;
import de.flexiprovider.core.mprsa.MpRSAPrivateKey;
import de.flexiprovider.core.mprsa.RSAOtherPrimeInfo;
import de.flexiprovider.core.rsa.RSAPublicKey;
import java.util.Vector;

public class MpRSAKeyPairGenerator
extends KeyPairGenerator {
    private static final int CERTAINTY = 80;
    private int keySize;
    private FlexiBigInt e;
    private int k;
    private SecureRandom random;
    private boolean initialized;

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        MpRSAKeyGenParameterSpec rsaParams;
        if (params == null) {
            rsaParams = new MpRSAKeyGenParameterSpec();
        } else if (params instanceof MpRSAKeyGenParameterSpec) {
            rsaParams = (MpRSAKeyGenParameterSpec)params;
        } else {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        this.keySize = rsaParams.getKeySize();
        this.e = rsaParams.getE();
        this.k = rsaParams.getNumPrimes();
        this.random = random != null ? random : Registry.getSecureRandom();
        this.initialized = true;
    }

    public void initialize(int keySize, SecureRandom secureRand) {
        MpRSAKeyGenParameterSpec params = new MpRSAKeyGenParameterSpec();
        try {
            this.initialize(params, this.random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    private void initializeDefault() {
        MpRSAKeyGenParameterSpec defaultParams = new MpRSAKeyGenParameterSpec();
        try {
            this.initialize(defaultParams, Registry.getSecureRandom());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public KeyPair genKeyPair() {
        Vector<FlexiBigInt> v;
        FlexiBigInt q;
        FlexiBigInt p;
        FlexiBigInt n;
        int bitsp;
        if (!this.initialized) {
            this.initializeDefault();
        }
        FlexiBigInt[] otherPrime = new FlexiBigInt[this.k - 2];
        int bitsq = bitsp = (this.keySize + 1) / this.k;
        int bitrn = this.keySize - (this.k - 1) * bitsp;
        do {
            p = new FlexiBigInt(bitsp, 80, this.random);
            while (p.equals(q = new FlexiBigInt(bitsq, 80, this.random))) {
            }
            v = new Vector<FlexiBigInt>();
            v.addElement(p);
            v.addElement(q);
            int i = 0;
            while (i < otherPrime.length - 1) {
                otherPrime[i] = new FlexiBigInt(bitsp, 80, this.random);
                if (this.contains(v, otherPrime[i])) {
                    --i;
                } else {
                    v.addElement(otherPrime[i]);
                }
                ++i;
            }
            do {
                otherPrime[otherPrime.length - 1] = new FlexiBigInt(bitrn, 80, this.random);
            } while (this.contains(v, otherPrime[otherPrime.length - 1]));
            v.addElement(otherPrime[otherPrime.length - 1]);
            n = p.multiply(q);
            int i2 = 0;
            while (i2 < otherPrime.length) {
                n = n.multiply(otherPrime[i2]);
                ++i2;
            }
        } while (n.bitLength() != this.keySize);
        FlexiBigInt one = FlexiBigInt.ONE;
        FlexiBigInt[] pm = new FlexiBigInt[this.k];
        int i = 0;
        while (i < this.k) {
            pm[i] = ((FlexiBigInt)v.elementAt(i)).subtract(one);
            ++i;
        }
        FlexiBigInt phi = this.lcm(pm);
        FlexiBigInt two = FlexiBigInt.valueOf(2L);
        while (!phi.gcd(this.e).equals(one)) {
            this.e = this.e.add(two);
        }
        FlexiBigInt d = this.e.modInverse(phi);
        FlexiBigInt dp = d.mod(pm[0]);
        FlexiBigInt dq = d.mod(pm[1]);
        FlexiBigInt crt = q.modInverse(p);
        RSAOtherPrimeInfo[] otherPrimeInfo = new RSAOtherPrimeInfo[this.k - 2];
        FlexiBigInt R = (FlexiBigInt)v.elementAt(0);
        int i3 = 0;
        while (i3 < otherPrimeInfo.length) {
            R = R.multiply((FlexiBigInt)v.elementAt(i3 + 1));
            otherPrimeInfo[i3] = new RSAOtherPrimeInfo(otherPrime[i3], d.mod(pm[i3 + 2]), R.modInverse(otherPrime[i3]));
            ++i3;
        }
        RSAPublicKey pubKey = new RSAPublicKey(n, this.e);
        MpRSAPrivateKey privKey = new MpRSAPrivateKey(n, this.e, d, p, q, dp, dq, crt, otherPrimeInfo);
        return new KeyPair(pubKey, privKey);
    }

    private FlexiBigInt lcm(FlexiBigInt[] v) {
        FlexiBigInt product;
        FlexiBigInt gcd_ = product = v[0];
        int i = 1;
        while (i < v.length) {
            FlexiBigInt tmp = v[i];
            product = product.multiply(tmp);
            gcd_ = gcd_.gcd(tmp);
            ++i;
        }
        return product.divide(gcd_);
    }

    private boolean contains(Vector v, FlexiBigInt x) {
        int i = 0;
        while (i < v.size()) {
            if (x.equals(v.elementAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

