/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.md;

import de.flexiprovider.api.MessageDigest;
import de.flexiprovider.common.util.BigEndianConversions;

public abstract class SHA384_512
extends MessageDigest {
    private static final long[] K = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};
    private byte[] buffer = new byte[128];
    private long count;
    private int digestLength;
    private long[] H;
    private long[] W = new long[80];

    protected SHA384_512(int digestLength) {
        this.H = new long[8];
        this.digestLength = digestLength;
        this.reset();
    }

    protected void initMessageDigest(long[] initialState) {
        System.arraycopy(initialState, 0, this.H, 0, initialState.length);
        this.count = 0L;
    }

    private static long sigma0(long x) {
        return (x >>> 1 | x << 63) ^ (x >>> 8 | x << 56) ^ x >>> 7;
    }

    private static long sigma1(long x) {
        return (x >>> 19 | x << 45) ^ (x >>> 61 | x << 3) ^ x >>> 6;
    }

    private void processBlock() {
        long a = this.H[0];
        long b = this.H[1];
        long c = this.H[2];
        long d = this.H[3];
        long e = this.H[4];
        long f = this.H[5];
        long g = this.H[6];
        long h = this.H[7];
        int i = 0;
        while (i < 80) {
            this.W[i] = i < 16 ? BigEndianConversions.OS2LIP(this.buffer, i << 3) : SHA384_512.sigma1(this.W[i - 2]) + this.W[i - 7] + SHA384_512.sigma0(this.W[i - 15]) + this.W[i - 16];
            long T1 = ((e >>> 14 | e << 50) ^ (e >>> 18 | e << 46) ^ (e >>> 41 | e << 23)) + (e & f ^ (e ^ 0xFFFFFFFFFFFFFFFFL) & g) + h + K[i] + this.W[i];
            long T2 = ((a >>> 28 | a << 36) ^ (a >>> 34 | a << 30) ^ (a >>> 39 | a << 25)) + (a & b ^ a & c ^ b & c);
            h = g;
            g = f;
            f = e;
            e = d + T1;
            d = c;
            c = b;
            b = a;
            a = T1 + T2;
            ++i;
        }
        this.H[0] = this.H[0] + a;
        this.H[1] = this.H[1] + b;
        this.H[2] = this.H[2] + c;
        this.H[3] = this.H[3] + d;
        this.H[4] = this.H[4] + e;
        this.H[5] = this.H[5] + f;
        this.H[6] = this.H[6] + g;
        this.H[7] = this.H[7] + h;
    }

    private void pad() {
        int i;
        long bitLength = this.count << 3;
        this.buffer[(int)this.count & 0x7F] = -128;
        ++this.count;
        if ((this.count & 0x7FL) > 112L) {
            i = (int)this.count & 0x7F;
            while (i < 128) {
                this.buffer[i] = 0;
                ++this.count;
                ++i;
            }
            this.processBlock();
        } else if ((this.count & 0x7FL) == 0L) {
            this.processBlock();
        }
        i = (int)this.count & 0x7F;
        while (i < 112) {
            this.buffer[i] = 0;
            ++i;
        }
        this.buffer[112] = 0;
        this.buffer[113] = 0;
        this.buffer[114] = 0;
        this.buffer[115] = 0;
        this.buffer[116] = 0;
        this.buffer[117] = 0;
        this.buffer[118] = 0;
        this.buffer[119] = 0;
        BigEndianConversions.I2OSP(bitLength, this.buffer, 120);
        this.processBlock();
    }

    public int getDigestLength() {
        return this.digestLength;
    }

    public synchronized void update(byte input) {
        this.buffer[(int)this.count & 0x7F] = input;
        if ((int)(this.count & 0x7FL) == 127) {
            this.processBlock();
        }
        ++this.count;
    }

    public synchronized void update(byte[] input, int inOff, int inLen) {
        int bufOffset = (int)this.count & 0x7F;
        while (inLen > 0) {
            int copyLen = 128 - bufOffset;
            copyLen = inLen > copyLen ? copyLen : inLen;
            System.arraycopy(input, inOff, this.buffer, bufOffset, copyLen);
            inLen -= copyLen;
            inOff += copyLen;
            this.count += (long)copyLen;
            bufOffset = bufOffset + copyLen & 0x7F;
            if (bufOffset != 0) continue;
            this.processBlock();
        }
    }

    public synchronized byte[] digest() {
        this.pad();
        byte[] digestValue = new byte[this.digestLength];
        int i = this.digestLength >> 3;
        while (--i >= 0) {
            BigEndianConversions.I2OSP(this.H[i], digestValue, i << 3);
        }
        this.reset();
        return digestValue;
    }
}

