/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.md;

import de.flexiprovider.common.util.LittleEndianConversions;
import de.flexiprovider.core.md.MDFamilyDigest;

public final class RIPEMD160
extends MDFamilyDigest {
    public static final String ALG_NAME = "RIPEMD160";
    public static final String OID = "1.3.36.3.2.1";
    private static final int[] initState = new int[]{1732584193, -271733879, -1732584194, 271733878, -1009589776};
    private static final int RIPEMD160_DIGEST_LENGTH = 20;

    public RIPEMD160() {
        super(20);
    }

    public void reset() {
        this.initMessageDigest(initState);
    }

    public synchronized byte[] digest() {
        byte[] digest = new byte[20];
        this.padMessageDigest();
        LittleEndianConversions.I2OSP(this.state[0], digest, 0);
        LittleEndianConversions.I2OSP(this.state[1], digest, 4);
        LittleEndianConversions.I2OSP(this.state[2], digest, 8);
        LittleEndianConversions.I2OSP(this.state[3], digest, 12);
        LittleEndianConversions.I2OSP(this.state[4], digest, 16);
        this.reset();
        return digest;
    }

    protected synchronized void processBlock() {
        int Al = this.state[0];
        int Bl = this.state[1];
        int Cl = this.state[2];
        int Dl = this.state[3];
        int El = this.state[4];
        int Ar = this.state[0];
        int Br = this.state[1];
        int Cr = this.state[2];
        int Dr = this.state[3];
        int Er = this.state[4];
        Al = MDFamilyDigest.rotateLeft(Al + RIPEMD160.F(Bl, Cl, Dl) + this.x[0], 11) + El;
        Cl = MDFamilyDigest.rotateLeft(Cl, 10);
        El = MDFamilyDigest.rotateLeft(El + RIPEMD160.F(Al, Bl, Cl) + this.x[1], 14) + Dl;
        Bl = MDFamilyDigest.rotateLeft(Bl, 10);
        Dl = MDFamilyDigest.rotateLeft(Dl + RIPEMD160.F(El, Al, Bl) + this.x[2], 15) + Cl;
        Al = MDFamilyDigest.rotateLeft(Al, 10);
        Cl = MDFamilyDigest.rotateLeft(Cl + RIPEMD160.F(Dl, El, Al) + this.x[3], 12) + Bl;
        El = MDFamilyDigest.rotateLeft(El, 10);
        Bl = MDFamilyDigest.rotateLeft(Bl + RIPEMD160.F(Cl, Dl, El) + this.x[4], 5) + Al;
        Dl = MDFamilyDigest.rotateLeft(Dl, 10);
        Al = MDFamilyDigest.rotateLeft(Al + RIPEMD160.F(Bl, Cl, Dl) + this.x[5], 8) + El;
        Cl = MDFamilyDigest.rotateLeft(Cl, 10);
        El = MDFamilyDigest.rotateLeft(El + RIPEMD160.F(Al, Bl, Cl) + this.x[6], 7) + Dl;
        Bl = MDFamilyDigest.rotateLeft(Bl, 10);
        Dl = MDFamilyDigest.rotateLeft(Dl + RIPEMD160.F(El, Al, Bl) + this.x[7], 9) + Cl;
        Al = MDFamilyDigest.rotateLeft(Al, 10);
        Cl = MDFamilyDigest.rotateLeft(Cl + RIPEMD160.F(Dl, El, Al) + this.x[8], 11) + Bl;
        El = MDFamilyDigest.rotateLeft(El, 10);
        Bl = MDFamilyDigest.rotateLeft(Bl + RIPEMD160.F(Cl, Dl, El) + this.x[9], 13) + Al;
        Dl = MDFamilyDigest.rotateLeft(Dl, 10);
        Al = MDFamilyDigest.rotateLeft(Al + RIPEMD160.F(Bl, Cl, Dl) + this.x[10], 14) + El;
        Cl = MDFamilyDigest.rotateLeft(Cl, 10);
        El = MDFamilyDigest.rotateLeft(El + RIPEMD160.F(Al, Bl, Cl) + this.x[11], 15) + Dl;
        Bl = MDFamilyDigest.rotateLeft(Bl, 10);
        Dl = MDFamilyDigest.rotateLeft(Dl + RIPEMD160.F(El, Al, Bl) + this.x[12], 6) + Cl;
        Al = MDFamilyDigest.rotateLeft(Al, 10);
        Cl = MDFamilyDigest.rotateLeft(Cl + RIPEMD160.F(Dl, El, Al) + this.x[13], 7) + Bl;
        El = MDFamilyDigest.rotateLeft(El, 10);
        Bl = MDFamilyDigest.rotateLeft(Bl + RIPEMD160.F(Cl, Dl, El) + this.x[14], 9) + Al;
        Dl = MDFamilyDigest.rotateLeft(Dl, 10);
        Al = MDFamilyDigest.rotateLeft(Al + RIPEMD160.F(Bl, Cl, Dl) + this.x[15], 8) + El;
        Cl = MDFamilyDigest.rotateLeft(Cl, 10);
        Ar = MDFamilyDigest.rotateLeft(Ar + RIPEMD160.L(Br, Cr, Dr) + this.x[5] + 1352829926, 8) + Er;
        Cr = MDFamilyDigest.rotateLeft(Cr, 10);
        Er = MDFamilyDigest.rotateLeft(Er + RIPEMD160.L(Ar, Br, Cr) + this.x[14] + 1352829926, 9) + Dr;
        Br = MDFamilyDigest.rotateLeft(Br, 10);
        Dr = MDFamilyDigest.rotateLeft(Dr + RIPEMD160.L(Er, Ar, Br) + this.x[7] + 1352829926, 9) + Cr;
        Ar = MDFamilyDigest.rotateLeft(Ar, 10);
        Cr = MDFamilyDigest.rotateLeft(Cr + RIPEMD160.L(Dr, Er, Ar) + this.x[0] + 1352829926, 11) + Br;
        Er = MDFamilyDigest.rotateLeft(Er, 10);
        Br = MDFamilyDigest.rotateLeft(Br + RIPEMD160.L(Cr, Dr, Er) + this.x[9] + 1352829926, 13) + Ar;
        Dr = MDFamilyDigest.rotateLeft(Dr, 10);
        Ar = MDFamilyDigest.rotateLeft(Ar + RIPEMD160.L(Br, Cr, Dr) + this.x[2] + 1352829926, 15) + Er;
        Cr = MDFamilyDigest.rotateLeft(Cr, 10);
        Er = MDFamilyDigest.rotateLeft(Er + RIPEMD160.L(Ar, Br, Cr) + this.x[11] + 1352829926, 15) + Dr;
        Br = MDFamilyDigest.rotateLeft(Br, 10);
        Dr = MDFamilyDigest.rotateLeft(Dr + RIPEMD160.L(Er, Ar, Br) + this.x[4] + 1352829926, 5) + Cr;
        Ar = MDFamilyDigest.rotateLeft(Ar, 10);
        Cr = MDFamilyDigest.rotateLeft(Cr + RIPEMD160.L(Dr, Er, Ar) + this.x[13] + 1352829926, 7) + Br;
        Er = MDFamilyDigest.rotateLeft(Er, 10);
        Br = MDFamilyDigest.rotateLeft(Br + RIPEMD160.L(Cr, Dr, Er) + this.x[6] + 1352829926, 7) + Ar;
        Dr = MDFamilyDigest.rotateLeft(Dr, 10);
        Ar = MDFamilyDigest.rotateLeft(Ar + RIPEMD160.L(Br, Cr, Dr) + this.x[15] + 1352829926, 8) + Er;
        Cr = MDFamilyDigest.rotateLeft(Cr, 10);
        Er = MDFamilyDigest.rotateLeft(Er + RIPEMD160.L(Ar, Br, Cr) + this.x[8] + 1352829926, 11) + Dr;
        Br = MDFamilyDigest.rotateLeft(Br, 10);
        Dr = MDFamilyDigest.rotateLeft(Dr + RIPEMD160.L(Er, Ar, Br) + this.x[1] + 1352829926, 14) + Cr;
        Ar = MDFamilyDigest.rotateLeft(Ar, 10);
        Cr = MDFamilyDigest.rotateLeft(Cr + RIPEMD160.L(Dr, Er, Ar) + this.x[10] + 1352829926, 14) + Br;
        Er = MDFamilyDigest.rotateLeft(Er, 10);
        Br = MDFamilyDigest.rotateLeft(Br + RIPEMD160.L(Cr, Dr, Er) + this.x[3] + 1352829926, 12) + Ar;
        Dr = MDFamilyDigest.rotateLeft(Dr, 10);
        Ar = MDFamilyDigest.rotateLeft(Ar + RIPEMD160.L(Br, Cr, Dr) + this.x[12] + 1352829926, 6) + Er;
        Cr = MDFamilyDigest.rotateLeft(Cr, 10);
        El = MDFamilyDigest.rotateLeft(El + RIPEMD160.G(Al, Bl, Cl) + this.x[7] + 1518500249, 7) + Dl;
        Bl = MDFamilyDigest.rotateLeft(Bl, 10);
        Dl = MDFamilyDigest.rotateLeft(Dl + RIPEMD160.G(El, Al, Bl) + this.x[4] + 1518500249, 6) + Cl;
        Al = MDFamilyDigest.rotateLeft(Al, 10);
        Cl = MDFamilyDigest.rotateLeft(Cl + RIPEMD160.G(Dl, El, Al) + this.x[13] + 1518500249, 8) + Bl;
        El = MDFamilyDigest.rotateLeft(El, 10);
        Bl = MDFamilyDigest.rotateLeft(Bl + RIPEMD160.G(Cl, Dl, El) + this.x[1] + 1518500249, 13) + Al;
        Dl = MDFamilyDigest.rotateLeft(Dl, 10);
        Al = MDFamilyDigest.rotateLeft(Al + RIPEMD160.G(Bl, Cl, Dl) + this.x[10] + 1518500249, 11) + El;
        Cl = MDFamilyDigest.rotateLeft(Cl, 10);
        El = MDFamilyDigest.rotateLeft(El + RIPEMD160.G(Al, Bl, Cl) + this.x[6] + 1518500249, 9) + Dl;
        Bl = MDFamilyDigest.rotateLeft(Bl, 10);
        Dl = MDFamilyDigest.rotateLeft(Dl + RIPEMD160.G(El, Al, Bl) + this.x[15] + 1518500249, 7) + Cl;
        Al = MDFamilyDigest.rotateLeft(Al, 10);
        Cl = MDFamilyDigest.rotateLeft(Cl + RIPEMD160.G(Dl, El, Al) + this.x[3] + 1518500249, 15) + Bl;
        El = MDFamilyDigest.rotateLeft(El, 10);
        Bl = MDFamilyDigest.rotateLeft(Bl + RIPEMD160.G(Cl, Dl, El) + this.x[12] + 1518500249, 7) + Al;
        Dl = MDFamilyDigest.rotateLeft(Dl, 10);
        Al = MDFamilyDigest.rotateLeft(Al + RIPEMD160.G(Bl, Cl, Dl) + this.x[0] + 1518500249, 12) + El;
        Cl = MDFamilyDigest.rotateLeft(Cl, 10);
        El = MDFamilyDigest.rotateLeft(El + RIPEMD160.G(Al, Bl, Cl) + this.x[9] + 1518500249, 15) + Dl;
        Bl = MDFamilyDigest.rotateLeft(Bl, 10);
        Dl = MDFamilyDigest.rotateLeft(Dl + RIPEMD160.G(El, Al, Bl) + this.x[5] + 1518500249, 9) + Cl;
        Al = MDFamilyDigest.rotateLeft(Al, 10);
        Cl = MDFamilyDigest.rotateLeft(Cl + RIPEMD160.G(Dl, El, Al) + this.x[2] + 1518500249, 11) + Bl;
        El = MDFamilyDigest.rotateLeft(El, 10);
        Bl = MDFamilyDigest.rotateLeft(Bl + RIPEMD160.G(Cl, Dl, El) + this.x[14] + 1518500249, 7) + Al;
        Dl = MDFamilyDigest.rotateLeft(Dl, 10);
        Al = MDFamilyDigest.rotateLeft(Al + RIPEMD160.G(Bl, Cl, Dl) + this.x[11] + 1518500249, 13) + El;
        Cl = MDFamilyDigest.rotateLeft(Cl, 10);
        El = MDFamilyDigest.rotateLeft(El + RIPEMD160.G(Al, Bl, Cl) + this.x[8] + 1518500249, 12) + Dl;
        Bl = MDFamilyDigest.rotateLeft(Bl, 10);
        Er = MDFamilyDigest.rotateLeft(Er + RIPEMD160.K(Ar, Br, Cr) + this.x[6] + 1548603684, 9) + Dr;
        Br = MDFamilyDigest.rotateLeft(Br, 10);
        Dr = MDFamilyDigest.rotateLeft(Dr + RIPEMD160.K(Er, Ar, Br) + this.x[11] + 1548603684, 13) + Cr;
        Ar = MDFamilyDigest.rotateLeft(Ar, 10);
        Cr = MDFamilyDigest.rotateLeft(Cr + RIPEMD160.K(Dr, Er, Ar) + this.x[3] + 1548603684, 15) + Br;
        Er = MDFamilyDigest.rotateLeft(Er, 10);
        Br = MDFamilyDigest.rotateLeft(Br + RIPEMD160.K(Cr, Dr, Er) + this.x[7] + 1548603684, 7) + Ar;
        Dr = MDFamilyDigest.rotateLeft(Dr, 10);
        Ar = MDFamilyDigest.rotateLeft(Ar + RIPEMD160.K(Br, Cr, Dr) + this.x[0] + 1548603684, 12) + Er;
        Cr = MDFamilyDigest.rotateLeft(Cr, 10);
        Er = MDFamilyDigest.rotateLeft(Er + RIPEMD160.K(Ar, Br, Cr) + this.x[13] + 1548603684, 8) + Dr;
        Br = MDFamilyDigest.rotateLeft(Br, 10);
        Dr = MDFamilyDigest.rotateLeft(Dr + RIPEMD160.K(Er, Ar, Br) + this.x[5] + 1548603684, 9) + Cr;
        Ar = MDFamilyDigest.rotateLeft(Ar, 10);
        Cr = MDFamilyDigest.rotateLeft(Cr + RIPEMD160.K(Dr, Er, Ar) + this.x[10] + 1548603684, 11) + Br;
        Er = MDFamilyDigest.rotateLeft(Er, 10);
        Br = MDFamilyDigest.rotateLeft(Br + RIPEMD160.K(Cr, Dr, Er) + this.x[14] + 1548603684, 7) + Ar;
        Dr = MDFamilyDigest.rotateLeft(Dr, 10);
        Ar = MDFamilyDigest.rotateLeft(Ar + RIPEMD160.K(Br, Cr, Dr) + this.x[15] + 1548603684, 7) + Er;
        Cr = MDFamilyDigest.rotateLeft(Cr, 10);
        Er = MDFamilyDigest.rotateLeft(Er + RIPEMD160.K(Ar, Br, Cr) + this.x[8] + 1548603684, 12) + Dr;
        Br = MDFamilyDigest.rotateLeft(Br, 10);
        Dr = MDFamilyDigest.rotateLeft(Dr + RIPEMD160.K(Er, Ar, Br) + this.x[12] + 1548603684, 7) + Cr;
        Ar = MDFamilyDigest.rotateLeft(Ar, 10);
        Cr = MDFamilyDigest.rotateLeft(Cr + RIPEMD160.K(Dr, Er, Ar) + this.x[4] + 1548603684, 6) + Br;
        Er = MDFamilyDigest.rotateLeft(Er, 10);
        Br = MDFamilyDigest.rotateLeft(Br + RIPEMD160.K(Cr, Dr, Er) + this.x[9] + 1548603684, 15) + Ar;
        Dr = MDFamilyDigest.rotateLeft(Dr, 10);
        Ar = MDFamilyDigest.rotateLeft(Ar + RIPEMD160.K(Br, Cr, Dr) + this.x[1] + 1548603684, 13) + Er;
        Cr = MDFamilyDigest.rotateLeft(Cr, 10);
        Er = MDFamilyDigest.rotateLeft(Er + RIPEMD160.K(Ar, Br, Cr) + this.x[2] + 1548603684, 11) + Dr;
        Br = MDFamilyDigest.rotateLeft(Br, 10);
        Dl = MDFamilyDigest.rotateLeft(Dl + RIPEMD160.H(El, Al, Bl) + this.x[3] + 1859775393, 11) + Cl;
        Al = MDFamilyDigest.rotateLeft(Al, 10);
        Cl = MDFamilyDigest.rotateLeft(Cl + RIPEMD160.H(Dl, El, Al) + this.x[10] + 1859775393, 13) + Bl;
        El = MDFamilyDigest.rotateLeft(El, 10);
        Bl = MDFamilyDigest.rotateLeft(Bl + RIPEMD160.H(Cl, Dl, El) + this.x[14] + 1859775393, 6) + Al;
        Dl = MDFamilyDigest.rotateLeft(Dl, 10);
        Al = MDFamilyDigest.rotateLeft(Al + RIPEMD160.H(Bl, Cl, Dl) + this.x[4] + 1859775393, 7) + El;
        Cl = MDFamilyDigest.rotateLeft(Cl, 10);
        El = MDFamilyDigest.rotateLeft(El + RIPEMD160.H(Al, Bl, Cl) + this.x[9] + 1859775393, 14) + Dl;
        Bl = MDFamilyDigest.rotateLeft(Bl, 10);
        Dl = MDFamilyDigest.rotateLeft(Dl + RIPEMD160.H(El, Al, Bl) + this.x[15] + 1859775393, 9) + Cl;
        Al = MDFamilyDigest.rotateLeft(Al, 10);
        Cl = MDFamilyDigest.rotateLeft(Cl + RIPEMD160.H(Dl, El, Al) + this.x[8] + 1859775393, 13) + Bl;
        El = MDFamilyDigest.rotateLeft(El, 10);
        Bl = MDFamilyDigest.rotateLeft(Bl + RIPEMD160.H(Cl, Dl, El) + this.x[1] + 1859775393, 15) + Al;
        Dl = MDFamilyDigest.rotateLeft(Dl, 10);
        Al = MDFamilyDigest.rotateLeft(Al + RIPEMD160.H(Bl, Cl, Dl) + this.x[2] + 1859775393, 14) + El;
        Cl = MDFamilyDigest.rotateLeft(Cl, 10);
        El = MDFamilyDigest.rotateLeft(El + RIPEMD160.H(Al, Bl, Cl) + this.x[7] + 1859775393, 8) + Dl;
        Bl = MDFamilyDigest.rotateLeft(Bl, 10);
        Dl = MDFamilyDigest.rotateLeft(Dl + RIPEMD160.H(El, Al, Bl) + this.x[0] + 1859775393, 13) + Cl;
        Al = MDFamilyDigest.rotateLeft(Al, 10);
        Cl = MDFamilyDigest.rotateLeft(Cl + RIPEMD160.H(Dl, El, Al) + this.x[6] + 1859775393, 6) + Bl;
        El = MDFamilyDigest.rotateLeft(El, 10);
        Bl = MDFamilyDigest.rotateLeft(Bl + RIPEMD160.H(Cl, Dl, El) + this.x[13] + 1859775393, 5) + Al;
        Dl = MDFamilyDigest.rotateLeft(Dl, 10);
        Al = MDFamilyDigest.rotateLeft(Al + RIPEMD160.H(Bl, Cl, Dl) + this.x[11] + 1859775393, 12) + El;
        Cl = MDFamilyDigest.rotateLeft(Cl, 10);
        El = MDFamilyDigest.rotateLeft(El + RIPEMD160.H(Al, Bl, Cl) + this.x[5] + 1859775393, 7) + Dl;
        Bl = MDFamilyDigest.rotateLeft(Bl, 10);
        Dl = MDFamilyDigest.rotateLeft(Dl + RIPEMD160.H(El, Al, Bl) + this.x[12] + 1859775393, 5) + Cl;
        Al = MDFamilyDigest.rotateLeft(Al, 10);
        Dr = MDFamilyDigest.rotateLeft(Dr + RIPEMD160.H(Er, Ar, Br) + this.x[15] + 1836072691, 9) + Cr;
        Ar = MDFamilyDigest.rotateLeft(Ar, 10);
        Cr = MDFamilyDigest.rotateLeft(Cr + RIPEMD160.H(Dr, Er, Ar) + this.x[5] + 1836072691, 7) + Br;
        Er = MDFamilyDigest.rotateLeft(Er, 10);
        Br = MDFamilyDigest.rotateLeft(Br + RIPEMD160.H(Cr, Dr, Er) + this.x[1] + 1836072691, 15) + Ar;
        Dr = MDFamilyDigest.rotateLeft(Dr, 10);
        Ar = MDFamilyDigest.rotateLeft(Ar + RIPEMD160.H(Br, Cr, Dr) + this.x[3] + 1836072691, 11) + Er;
        Cr = MDFamilyDigest.rotateLeft(Cr, 10);
        Er = MDFamilyDigest.rotateLeft(Er + RIPEMD160.H(Ar, Br, Cr) + this.x[7] + 1836072691, 8) + Dr;
        Br = MDFamilyDigest.rotateLeft(Br, 10);
        Dr = MDFamilyDigest.rotateLeft(Dr + RIPEMD160.H(Er, Ar, Br) + this.x[14] + 1836072691, 6) + Cr;
        Ar = MDFamilyDigest.rotateLeft(Ar, 10);
        Cr = MDFamilyDigest.rotateLeft(Cr + RIPEMD160.H(Dr, Er, Ar) + this.x[6] + 1836072691, 6) + Br;
        Er = MDFamilyDigest.rotateLeft(Er, 10);
        Br = MDFamilyDigest.rotateLeft(Br + RIPEMD160.H(Cr, Dr, Er) + this.x[9] + 1836072691, 14) + Ar;
        Dr = MDFamilyDigest.rotateLeft(Dr, 10);
        Ar = MDFamilyDigest.rotateLeft(Ar + RIPEMD160.H(Br, Cr, Dr) + this.x[11] + 1836072691, 12) + Er;
        Cr = MDFamilyDigest.rotateLeft(Cr, 10);
        Er = MDFamilyDigest.rotateLeft(Er + RIPEMD160.H(Ar, Br, Cr) + this.x[8] + 1836072691, 13) + Dr;
        Br = MDFamilyDigest.rotateLeft(Br, 10);
        Dr = MDFamilyDigest.rotateLeft(Dr + RIPEMD160.H(Er, Ar, Br) + this.x[12] + 1836072691, 5) + Cr;
        Ar = MDFamilyDigest.rotateLeft(Ar, 10);
        Cr = MDFamilyDigest.rotateLeft(Cr + RIPEMD160.H(Dr, Er, Ar) + this.x[2] + 1836072691, 14) + Br;
        Er = MDFamilyDigest.rotateLeft(Er, 10);
        Br = MDFamilyDigest.rotateLeft(Br + RIPEMD160.H(Cr, Dr, Er) + this.x[10] + 1836072691, 13) + Ar;
        Dr = MDFamilyDigest.rotateLeft(Dr, 10);
        Ar = MDFamilyDigest.rotateLeft(Ar + RIPEMD160.H(Br, Cr, Dr) + this.x[0] + 1836072691, 13) + Er;
        Cr = MDFamilyDigest.rotateLeft(Cr, 10);
        Er = MDFamilyDigest.rotateLeft(Er + RIPEMD160.H(Ar, Br, Cr) + this.x[4] + 1836072691, 7) + Dr;
        Br = MDFamilyDigest.rotateLeft(Br, 10);
        Dr = MDFamilyDigest.rotateLeft(Dr + RIPEMD160.H(Er, Ar, Br) + this.x[13] + 1836072691, 5) + Cr;
        Ar = MDFamilyDigest.rotateLeft(Ar, 10);
        Cl = MDFamilyDigest.rotateLeft(Cl + RIPEMD160.K(Dl, El, Al) + this.x[1] + -1894007588, 11) + Bl;
        El = MDFamilyDigest.rotateLeft(El, 10);
        Bl = MDFamilyDigest.rotateLeft(Bl + RIPEMD160.K(Cl, Dl, El) + this.x[9] + -1894007588, 12) + Al;
        Dl = MDFamilyDigest.rotateLeft(Dl, 10);
        Al = MDFamilyDigest.rotateLeft(Al + RIPEMD160.K(Bl, Cl, Dl) + this.x[11] + -1894007588, 14) + El;
        Cl = MDFamilyDigest.rotateLeft(Cl, 10);
        El = MDFamilyDigest.rotateLeft(El + RIPEMD160.K(Al, Bl, Cl) + this.x[10] + -1894007588, 15) + Dl;
        Bl = MDFamilyDigest.rotateLeft(Bl, 10);
        Dl = MDFamilyDigest.rotateLeft(Dl + RIPEMD160.K(El, Al, Bl) + this.x[0] + -1894007588, 14) + Cl;
        Al = MDFamilyDigest.rotateLeft(Al, 10);
        Cl = MDFamilyDigest.rotateLeft(Cl + RIPEMD160.K(Dl, El, Al) + this.x[8] + -1894007588, 15) + Bl;
        El = MDFamilyDigest.rotateLeft(El, 10);
        Bl = MDFamilyDigest.rotateLeft(Bl + RIPEMD160.K(Cl, Dl, El) + this.x[12] + -1894007588, 9) + Al;
        Dl = MDFamilyDigest.rotateLeft(Dl, 10);
        Al = MDFamilyDigest.rotateLeft(Al + RIPEMD160.K(Bl, Cl, Dl) + this.x[4] + -1894007588, 8) + El;
        Cl = MDFamilyDigest.rotateLeft(Cl, 10);
        El = MDFamilyDigest.rotateLeft(El + RIPEMD160.K(Al, Bl, Cl) + this.x[13] + -1894007588, 9) + Dl;
        Bl = MDFamilyDigest.rotateLeft(Bl, 10);
        Dl = MDFamilyDigest.rotateLeft(Dl + RIPEMD160.K(El, Al, Bl) + this.x[3] + -1894007588, 14) + Cl;
        Al = MDFamilyDigest.rotateLeft(Al, 10);
        Cl = MDFamilyDigest.rotateLeft(Cl + RIPEMD160.K(Dl, El, Al) + this.x[7] + -1894007588, 5) + Bl;
        El = MDFamilyDigest.rotateLeft(El, 10);
        Bl = MDFamilyDigest.rotateLeft(Bl + RIPEMD160.K(Cl, Dl, El) + this.x[15] + -1894007588, 6) + Al;
        Dl = MDFamilyDigest.rotateLeft(Dl, 10);
        Al = MDFamilyDigest.rotateLeft(Al + RIPEMD160.K(Bl, Cl, Dl) + this.x[14] + -1894007588, 8) + El;
        Cl = MDFamilyDigest.rotateLeft(Cl, 10);
        El = MDFamilyDigest.rotateLeft(El + RIPEMD160.K(Al, Bl, Cl) + this.x[5] + -1894007588, 6) + Dl;
        Bl = MDFamilyDigest.rotateLeft(Bl, 10);
        Dl = MDFamilyDigest.rotateLeft(Dl + RIPEMD160.K(El, Al, Bl) + this.x[6] + -1894007588, 5) + Cl;
        Al = MDFamilyDigest.rotateLeft(Al, 10);
        Cl = MDFamilyDigest.rotateLeft(Cl + RIPEMD160.K(Dl, El, Al) + this.x[2] + -1894007588, 12) + Bl;
        El = MDFamilyDigest.rotateLeft(El, 10);
        Cr = MDFamilyDigest.rotateLeft(Cr + RIPEMD160.G(Dr, Er, Ar) + this.x[8] + 2053994217, 15) + Br;
        Er = MDFamilyDigest.rotateLeft(Er, 10);
        Br = MDFamilyDigest.rotateLeft(Br + RIPEMD160.G(Cr, Dr, Er) + this.x[6] + 2053994217, 5) + Ar;
        Dr = MDFamilyDigest.rotateLeft(Dr, 10);
        Ar = MDFamilyDigest.rotateLeft(Ar + RIPEMD160.G(Br, Cr, Dr) + this.x[4] + 2053994217, 8) + Er;
        Cr = MDFamilyDigest.rotateLeft(Cr, 10);
        Er = MDFamilyDigest.rotateLeft(Er + RIPEMD160.G(Ar, Br, Cr) + this.x[1] + 2053994217, 11) + Dr;
        Br = MDFamilyDigest.rotateLeft(Br, 10);
        Dr = MDFamilyDigest.rotateLeft(Dr + RIPEMD160.G(Er, Ar, Br) + this.x[3] + 2053994217, 14) + Cr;
        Ar = MDFamilyDigest.rotateLeft(Ar, 10);
        Cr = MDFamilyDigest.rotateLeft(Cr + RIPEMD160.G(Dr, Er, Ar) + this.x[11] + 2053994217, 14) + Br;
        Er = MDFamilyDigest.rotateLeft(Er, 10);
        Br = MDFamilyDigest.rotateLeft(Br + RIPEMD160.G(Cr, Dr, Er) + this.x[15] + 2053994217, 6) + Ar;
        Dr = MDFamilyDigest.rotateLeft(Dr, 10);
        Ar = MDFamilyDigest.rotateLeft(Ar + RIPEMD160.G(Br, Cr, Dr) + this.x[0] + 2053994217, 14) + Er;
        Cr = MDFamilyDigest.rotateLeft(Cr, 10);
        Er = MDFamilyDigest.rotateLeft(Er + RIPEMD160.G(Ar, Br, Cr) + this.x[5] + 2053994217, 6) + Dr;
        Br = MDFamilyDigest.rotateLeft(Br, 10);
        Dr = MDFamilyDigest.rotateLeft(Dr + RIPEMD160.G(Er, Ar, Br) + this.x[12] + 2053994217, 9) + Cr;
        Ar = MDFamilyDigest.rotateLeft(Ar, 10);
        Cr = MDFamilyDigest.rotateLeft(Cr + RIPEMD160.G(Dr, Er, Ar) + this.x[2] + 2053994217, 12) + Br;
        Er = MDFamilyDigest.rotateLeft(Er, 10);
        Br = MDFamilyDigest.rotateLeft(Br + RIPEMD160.G(Cr, Dr, Er) + this.x[13] + 2053994217, 9) + Ar;
        Dr = MDFamilyDigest.rotateLeft(Dr, 10);
        Ar = MDFamilyDigest.rotateLeft(Ar + RIPEMD160.G(Br, Cr, Dr) + this.x[9] + 2053994217, 12) + Er;
        Cr = MDFamilyDigest.rotateLeft(Cr, 10);
        Er = MDFamilyDigest.rotateLeft(Er + RIPEMD160.G(Ar, Br, Cr) + this.x[7] + 2053994217, 5) + Dr;
        Br = MDFamilyDigest.rotateLeft(Br, 10);
        Dr = MDFamilyDigest.rotateLeft(Dr + RIPEMD160.G(Er, Ar, Br) + this.x[10] + 2053994217, 15) + Cr;
        Ar = MDFamilyDigest.rotateLeft(Ar, 10);
        Cr = MDFamilyDigest.rotateLeft(Cr + RIPEMD160.G(Dr, Er, Ar) + this.x[14] + 2053994217, 8) + Br;
        Er = MDFamilyDigest.rotateLeft(Er, 10);
        Bl = MDFamilyDigest.rotateLeft(Bl + RIPEMD160.L(Cl, Dl, El) + this.x[4] + -1454113458, 9) + Al;
        Dl = MDFamilyDigest.rotateLeft(Dl, 10);
        Al = MDFamilyDigest.rotateLeft(Al + RIPEMD160.L(Bl, Cl, Dl) + this.x[0] + -1454113458, 15) + El;
        Cl = MDFamilyDigest.rotateLeft(Cl, 10);
        El = MDFamilyDigest.rotateLeft(El + RIPEMD160.L(Al, Bl, Cl) + this.x[5] + -1454113458, 5) + Dl;
        Bl = MDFamilyDigest.rotateLeft(Bl, 10);
        Dl = MDFamilyDigest.rotateLeft(Dl + RIPEMD160.L(El, Al, Bl) + this.x[9] + -1454113458, 11) + Cl;
        Al = MDFamilyDigest.rotateLeft(Al, 10);
        Cl = MDFamilyDigest.rotateLeft(Cl + RIPEMD160.L(Dl, El, Al) + this.x[7] + -1454113458, 6) + Bl;
        El = MDFamilyDigest.rotateLeft(El, 10);
        Bl = MDFamilyDigest.rotateLeft(Bl + RIPEMD160.L(Cl, Dl, El) + this.x[12] + -1454113458, 8) + Al;
        Dl = MDFamilyDigest.rotateLeft(Dl, 10);
        Al = MDFamilyDigest.rotateLeft(Al + RIPEMD160.L(Bl, Cl, Dl) + this.x[2] + -1454113458, 13) + El;
        Cl = MDFamilyDigest.rotateLeft(Cl, 10);
        El = MDFamilyDigest.rotateLeft(El + RIPEMD160.L(Al, Bl, Cl) + this.x[10] + -1454113458, 12) + Dl;
        Bl = MDFamilyDigest.rotateLeft(Bl, 10);
        Dl = MDFamilyDigest.rotateLeft(Dl + RIPEMD160.L(El, Al, Bl) + this.x[14] + -1454113458, 5) + Cl;
        Al = MDFamilyDigest.rotateLeft(Al, 10);
        Cl = MDFamilyDigest.rotateLeft(Cl + RIPEMD160.L(Dl, El, Al) + this.x[1] + -1454113458, 12) + Bl;
        El = MDFamilyDigest.rotateLeft(El, 10);
        Bl = MDFamilyDigest.rotateLeft(Bl + RIPEMD160.L(Cl, Dl, El) + this.x[3] + -1454113458, 13) + Al;
        Dl = MDFamilyDigest.rotateLeft(Dl, 10);
        Al = MDFamilyDigest.rotateLeft(Al + RIPEMD160.L(Bl, Cl, Dl) + this.x[8] + -1454113458, 14) + El;
        Cl = MDFamilyDigest.rotateLeft(Cl, 10);
        El = MDFamilyDigest.rotateLeft(El + RIPEMD160.L(Al, Bl, Cl) + this.x[11] + -1454113458, 11) + Dl;
        Bl = MDFamilyDigest.rotateLeft(Bl, 10);
        Dl = MDFamilyDigest.rotateLeft(Dl + RIPEMD160.L(El, Al, Bl) + this.x[6] + -1454113458, 8) + Cl;
        Al = MDFamilyDigest.rotateLeft(Al, 10);
        Cl = MDFamilyDigest.rotateLeft(Cl + RIPEMD160.L(Dl, El, Al) + this.x[15] + -1454113458, 5) + Bl;
        El = MDFamilyDigest.rotateLeft(El, 10);
        Bl = MDFamilyDigest.rotateLeft(Bl + RIPEMD160.L(Cl, Dl, El) + this.x[13] + -1454113458, 6) + Al;
        Dl = MDFamilyDigest.rotateLeft(Dl, 10);
        Br = MDFamilyDigest.rotateLeft(Br + RIPEMD160.F(Cr, Dr, Er) + this.x[12], 8) + Ar;
        Dr = MDFamilyDigest.rotateLeft(Dr, 10);
        Ar = MDFamilyDigest.rotateLeft(Ar + RIPEMD160.F(Br, Cr, Dr) + this.x[15], 5) + Er;
        Cr = MDFamilyDigest.rotateLeft(Cr, 10);
        Er = MDFamilyDigest.rotateLeft(Er + RIPEMD160.F(Ar, Br, Cr) + this.x[10], 12) + Dr;
        Br = MDFamilyDigest.rotateLeft(Br, 10);
        Dr = MDFamilyDigest.rotateLeft(Dr + RIPEMD160.F(Er, Ar, Br) + this.x[4], 9) + Cr;
        Ar = MDFamilyDigest.rotateLeft(Ar, 10);
        Cr = MDFamilyDigest.rotateLeft(Cr + RIPEMD160.F(Dr, Er, Ar) + this.x[1], 12) + Br;
        Er = MDFamilyDigest.rotateLeft(Er, 10);
        Br = MDFamilyDigest.rotateLeft(Br + RIPEMD160.F(Cr, Dr, Er) + this.x[5], 5) + Ar;
        Dr = MDFamilyDigest.rotateLeft(Dr, 10);
        Ar = MDFamilyDigest.rotateLeft(Ar + RIPEMD160.F(Br, Cr, Dr) + this.x[8], 14) + Er;
        Cr = MDFamilyDigest.rotateLeft(Cr, 10);
        Er = MDFamilyDigest.rotateLeft(Er + RIPEMD160.F(Ar, Br, Cr) + this.x[7], 6) + Dr;
        Br = MDFamilyDigest.rotateLeft(Br, 10);
        Dr = MDFamilyDigest.rotateLeft(Dr + RIPEMD160.F(Er, Ar, Br) + this.x[6], 8) + Cr;
        Ar = MDFamilyDigest.rotateLeft(Ar, 10);
        Cr = MDFamilyDigest.rotateLeft(Cr + RIPEMD160.F(Dr, Er, Ar) + this.x[2], 13) + Br;
        Er = MDFamilyDigest.rotateLeft(Er, 10);
        Br = MDFamilyDigest.rotateLeft(Br + RIPEMD160.F(Cr, Dr, Er) + this.x[13], 6) + Ar;
        Dr = MDFamilyDigest.rotateLeft(Dr, 10);
        Ar = MDFamilyDigest.rotateLeft(Ar + RIPEMD160.F(Br, Cr, Dr) + this.x[14], 5) + Er;
        Cr = MDFamilyDigest.rotateLeft(Cr, 10);
        Er = MDFamilyDigest.rotateLeft(Er + RIPEMD160.F(Ar, Br, Cr) + this.x[0], 15) + Dr;
        Br = MDFamilyDigest.rotateLeft(Br, 10);
        Dr = MDFamilyDigest.rotateLeft(Dr + RIPEMD160.F(Er, Ar, Br) + this.x[3], 13) + Cr;
        Ar = MDFamilyDigest.rotateLeft(Ar, 10);
        Cr = MDFamilyDigest.rotateLeft(Cr + RIPEMD160.F(Dr, Er, Ar) + this.x[9], 11) + Br;
        Er = MDFamilyDigest.rotateLeft(Er, 10);
        Br = MDFamilyDigest.rotateLeft(Br + RIPEMD160.F(Cr, Dr, Er) + this.x[11], 11) + Ar;
        Dr = MDFamilyDigest.rotateLeft(Dr, 10);
        this.state[0] = this.state[1] + Cl + Dr;
        this.state[1] = this.state[2] + Dl + Er;
        this.state[2] = this.state[3] + El + Ar;
        this.state[3] = this.state[4] + Al + Br;
        this.state[4] = Bl += this.state[0] + Cr;
    }

    private static int F(int u, int v, int w) {
        return u ^ v ^ w;
    }

    private static int G(int u, int v, int w) {
        return u & v | ~u & w;
    }

    private static int H(int u, int v, int w) {
        return (u | ~v) ^ w;
    }

    private static int K(int u, int v, int w) {
        return u & w | v & ~w;
    }

    private static int L(int u, int v, int w) {
        return u ^ (v | ~w);
    }
}

