/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.kdf;

import codec.asn1.ASN1Choice;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Null;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import de.flexiprovider.api.exceptions.InvalidParameterSpecException;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.api.parameters.AlgorithmParameters;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.common.util.ByteUtils;
import de.flexiprovider.core.kdf.PBKDF2ParameterSpec;
import de.flexiprovider.pki.AlgorithmIdentifier;
import java.io.IOException;
import java.util.ArrayList;

public class PBKDF2Parameters
extends AlgorithmParameters {
    public static final String OID = "1.2.840.113549.1.5.12";
    private byte[] salt;
    private int iterationCount = 1000;
    private int keySize;
    static /* synthetic */ Class class$de$flexiprovider$core$kdf$PBKDF2ParameterSpec;

    public void init(AlgorithmParameterSpec params) throws InvalidParameterSpecException {
        if (!(params instanceof PBKDF2ParameterSpec)) {
            throw new InvalidParameterSpecException("unsupported type");
        }
        PBKDF2ParameterSpec pbkdf2Params = (PBKDF2ParameterSpec)params;
        this.salt = pbkdf2Params.getSalt();
        this.iterationCount = pbkdf2Params.getIterationCount();
        this.keySize = pbkdf2Params.getKeySize();
    }

    public void init(byte[] encParams) throws IOException {
        PBKDF2ASN1Params asn1params;
        try {
            asn1params = new PBKDF2ASN1Params();
            ASN1Tools.derDecode(encParams, (ASN1Type)asn1params);
        }
        catch (ASN1Exception ae) {
            throw new IOException("ASN1Exception: " + ae.getMessage());
        }
        this.salt = asn1params.getSalt();
        this.iterationCount = asn1params.getIterationCount();
        this.keySize = asn1params.getKeyLength();
    }

    public void init(byte[] encParams, String format) throws IOException {
        if (format != null && !format.equals("ASN.1")) {
            throw new IOException("unsupported format");
        }
        this.init(encParams);
    }

    public byte[] getEncoded() throws IOException {
        PBKDF2ASN1Params asn1pbeParams = new PBKDF2ASN1Params(this.salt, this.iterationCount, this.keySize);
        try {
            return ASN1Tools.derEncode((ASN1Type)asn1pbeParams);
        }
        catch (RuntimeException re) {
            throw new IOException(re.getMessage());
        }
    }

    public byte[] getEncoded(String format) throws IOException {
        if (format != null && !format.equals("ASN.1")) {
            throw new IOException("unsupported format");
        }
        return this.getEncoded();
    }

    public AlgorithmParameterSpec getParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (!paramSpec.isAssignableFrom(class$de$flexiprovider$core$kdf$PBKDF2ParameterSpec == null ? (class$de$flexiprovider$core$kdf$PBKDF2ParameterSpec = PBKDF2Parameters.class$("de.flexiprovider.core.kdf.PBKDF2ParameterSpec")) : class$de$flexiprovider$core$kdf$PBKDF2ParameterSpec)) {
            throw new InvalidParameterSpecException("unsupported type");
        }
        return new PBKDF2ParameterSpec(this.salt, this.iterationCount, this.keySize);
    }

    public String toString() {
        String result = "salt             : " + ByteUtils.toHexString(this.salt);
        result = result + "\niteration count: " + this.iterationCount;
        result = result + "\nkey size       : " + this.keySize;
        result = result + "\nprf OID        : 1.3.6.1.5.5.8.1.2";
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PBKDF2ASN1Params
    extends ASN1Sequence {
        private ASN1Choice salt = new ASN1Choice();
        private ASN1Integer iterationCount;
        private ASN1Integer keySize;
        private AlgorithmIdentifier prf;

        public PBKDF2ASN1Params() {
            super(4);
            this.salt.addType((ASN1Type)new ASN1OctetString());
            this.salt.addType((ASN1Type)new AlgorithmIdentifier());
            this.iterationCount = new ASN1Integer();
            this.keySize = new ASN1Integer();
            this.keySize.setOptional(true);
            this.prf = new AlgorithmIdentifier();
            this.prf.setOptional(true);
            ((ArrayList)((Object)this)).add(this.salt);
            ((ArrayList)((Object)this)).add(this.iterationCount);
            ((ArrayList)((Object)this)).add(this.keySize);
            ((ArrayList)((Object)this)).add(this.prf);
        }

        public PBKDF2ASN1Params(byte[] salt, int iterationCount, int keySize) {
            super(4);
            this.salt.setInnerType((ASN1Type)new ASN1OctetString(salt));
            this.iterationCount = new ASN1Integer(iterationCount);
            this.keySize = new ASN1Integer(keySize);
            try {
                this.prf = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.3.6.1.5.5.8.1.2"), (ASN1Type)new ASN1Null());
            }
            catch (ASN1Exception ae) {
                throw new RuntimeException("internal error");
            }
            ((ArrayList)((Object)this)).add(this.salt);
            ((ArrayList)((Object)this)).add(this.iterationCount);
            ((ArrayList)((Object)this)).add(this.keySize);
            ((ArrayList)((Object)this)).add(this.prf);
        }

        public int getIterationCount() {
            return ASN1Tools.getFlexiBigInt(this.iterationCount).intValue();
        }

        public int getKeyLength() {
            if (this.keySize.isOptional()) {
                return 0;
            }
            return ASN1Tools.getFlexiBigInt(this.keySize).intValue();
        }

        public AlgorithmIdentifier getPRFAlgorithmIdentifier() {
            if (this.prf.isOptional()) {
                try {
                    AlgorithmIdentifier hmacWithSHA1 = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.113549.2.7"), (ASN1Type)new ASN1Null());
                    return hmacWithSHA1;
                }
                catch (ASN1Exception ae) {
                    ae.printStackTrace();
                    return null;
                }
            }
            return this.prf;
        }

        public byte[] getSalt() {
            ASN1Type inner = this.salt.getInnerType();
            if (inner != null && inner instanceof ASN1OctetString) {
                ASN1OctetString os = (ASN1OctetString)inner;
                return os.getByteArray();
            }
            return null;
        }
    }
}

