/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.elgamal.semanticallysecure;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.keys.KeyPair;
import de.flexiprovider.api.keys.KeyPairGenerator;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.math.IntegerFunctions;
import de.flexiprovider.core.elgamal.semanticallysecure.SSVElGamalKeyGenParameterSpec;
import de.flexiprovider.core.elgamal.semanticallysecure.SSVElGamalPrivateKey;
import de.flexiprovider.core.elgamal.semanticallysecure.SSVElGamalPublicKey;

public class SSVElGamalKeyPairGenerator
extends KeyPairGenerator {
    private static final int CERTAINTY = 80;
    private static final FlexiBigInt TWO = FlexiBigInt.valueOf(2L);
    private static final FlexiBigInt MINUSONE = FlexiBigInt.valueOf(-1L);
    private int keySize = 1024;
    private SecureRandom random;
    private boolean initialized;

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        SSVElGamalKeyGenParameterSpec elGamalParams;
        if (params == null) {
            elGamalParams = new SSVElGamalKeyGenParameterSpec();
        } else if (params instanceof SSVElGamalKeyGenParameterSpec) {
            elGamalParams = (SSVElGamalKeyGenParameterSpec)params;
        } else {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        this.keySize = elGamalParams.getKeySize();
        this.random = random != null ? random : Registry.getSecureRandom();
        this.initialized = true;
    }

    public void initialize(int keySize, SecureRandom random) {
        SSVElGamalKeyGenParameterSpec params = new SSVElGamalKeyGenParameterSpec(keySize);
        try {
            this.initialize(params, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    private void initializeDefault() {
        SSVElGamalKeyGenParameterSpec defaultParams = new SSVElGamalKeyGenParameterSpec();
        try {
            this.initialize(defaultParams, Registry.getSecureRandom());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public KeyPair genKeyPair() {
        FlexiBigInt a;
        FlexiBigInt g;
        FlexiBigInt gPowQ;
        FlexiBigInt gPowTwo;
        FlexiBigInt two2GermainPrime;
        FlexiBigInt germainPrime;
        FlexiBigInt strongPrime;
        if (!this.initialized) {
            this.initializeDefault();
        }
        while (!((strongPrime = (germainPrime = new FlexiBigInt(this.keySize - 1, this.random)).shiftLeft(1).add(FlexiBigInt.ONE)).bitLength() == this.keySize && IntegerFunctions.passesSmallPrimeTest(germainPrime) && IntegerFunctions.passesSmallPrimeTest(strongPrime) && germainPrime.isProbablePrime(80) && ((two2GermainPrime = TWO.modPow(germainPrime, strongPrime)).equals(FlexiBigInt.ONE) || two2GermainPrime.subtract(strongPrime).equals(MINUSONE)) && germainPrime.isProbablePrime(80))) {
        }
        FlexiBigInt p = strongPrime;
        FlexiBigInt q = germainPrime;
        do {
            g = new FlexiBigInt(this.keySize - 1, this.random);
            gPowTwo = g.modPow(TWO, p);
            gPowQ = g.modPow(q, p);
        } while (gPowTwo.equals(FlexiBigInt.ONE) || gPowQ.equals(FlexiBigInt.ONE) || g.equals(FlexiBigInt.ZERO) || g.equals(FlexiBigInt.ONE));
        g = gPowTwo;
        FlexiBigInt pMinusOne = p.subtract(FlexiBigInt.ONE);
        while ((a = new FlexiBigInt(this.keySize, this.random)).compareTo(pMinusOne) >= 0) {
        }
        FlexiBigInt A = g.modPow(a, p);
        SSVElGamalPublicKey pub = new SSVElGamalPublicKey(p, q, g, A);
        SSVElGamalPrivateKey priv = new SSVElGamalPrivateKey(p, q, g, A, a);
        return new KeyPair(pub, priv);
    }
}

