/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.elgamal;

import codec.CorruptedCodeException;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import codec.pkcs8.PrivateKeyInfo;
import codec.x509.SubjectPublicKeyInfo;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.InvalidKeySpecException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.KeyFactory;
import de.flexiprovider.api.keys.KeySpec;
import de.flexiprovider.api.keys.PrivateKey;
import de.flexiprovider.api.keys.PublicKey;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.core.elgamal.ElGamalPrivateKey;
import de.flexiprovider.core.elgamal.ElGamalPrivateKeySpec;
import de.flexiprovider.core.elgamal.ElGamalPublicKey;
import de.flexiprovider.core.elgamal.ElGamalPublicKeySpec;
import de.flexiprovider.pki.PKCS8EncodedKeySpec;
import de.flexiprovider.pki.X509EncodedKeySpec;

public class ElGamalKeyFactory
extends KeyFactory {
    public static final String OID = "1.3.14.7.2.1.1";
    static /* synthetic */ Class class$de$flexiprovider$pki$X509EncodedKeySpec;
    static /* synthetic */ Class class$de$flexiprovider$core$elgamal$ElGamalPublicKeySpec;
    static /* synthetic */ Class class$de$flexiprovider$pki$PKCS8EncodedKeySpec;
    static /* synthetic */ Class class$de$flexiprovider$core$elgamal$ElGamalPrivateKeySpec;

    public PrivateKey generatePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof ElGamalPrivateKeySpec) {
            return new ElGamalPrivateKey((ElGamalPrivateKeySpec)keySpec);
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            byte[] enc = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
            PrivateKeyInfo pki = new PrivateKeyInfo();
            try {
                ASN1Tools.derDecode(enc, (ASN1Type)pki);
            }
            catch (Exception ce) {
                throw new InvalidKeySpecException("Unable to decode PKCS8EncodedKeySpec.");
            }
            try {
                ASN1Sequence encPrivKey = (ASN1Sequence)pki.getDecodedRawKey();
                FlexiBigInt modulus = ASN1Tools.getFlexiBigInt((ASN1Integer)encPrivKey.get(0));
                FlexiBigInt generator = ASN1Tools.getFlexiBigInt((ASN1Integer)encPrivKey.get(1));
                FlexiBigInt publicA = ASN1Tools.getFlexiBigInt((ASN1Integer)encPrivKey.get(2));
                FlexiBigInt a = ASN1Tools.getFlexiBigInt((ASN1Integer)encPrivKey.get(3));
                return new ElGamalPrivateKey(modulus, generator, publicA, a);
            }
            catch (CorruptedCodeException cce) {
                throw new InvalidKeySpecException("Unable to decode PKCS8EncodedKeySpec.");
            }
        }
        throw new InvalidKeySpecException("Unknown key specification: " + keySpec + ".");
    }

    public PublicKey generatePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof ElGamalPublicKeySpec) {
            return new ElGamalPublicKey((ElGamalPublicKeySpec)keySpec);
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            byte[] enc = ((X509EncodedKeySpec)keySpec).getEncoded();
            SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo();
            try {
                ASN1Tools.derDecode(enc, (ASN1Type)spki);
            }
            catch (Exception ce) {
                throw new InvalidKeySpecException("Unable to decode X509EncodedKeySpec.");
            }
            try {
                ASN1Sequence encPubKey = (ASN1Sequence)spki.getDecodedRawKey();
                FlexiBigInt modulus = ASN1Tools.getFlexiBigInt((ASN1Integer)encPubKey.get(0));
                FlexiBigInt generator = ASN1Tools.getFlexiBigInt((ASN1Integer)encPubKey.get(1));
                FlexiBigInt publicA = ASN1Tools.getFlexiBigInt((ASN1Integer)encPubKey.get(2));
                return new ElGamalPublicKey(modulus, generator, publicA);
            }
            catch (CorruptedCodeException cce) {
                throw new InvalidKeySpecException("Unable to decode X509EncodedKeySpec.");
            }
        }
        throw new InvalidKeySpecException("Unknown key specification: " + keySpec + ".");
    }

    public KeySpec getKeySpec(Key key, Class keySpec) throws InvalidKeySpecException {
        if (key instanceof ElGamalPublicKey) {
            if ((class$de$flexiprovider$pki$X509EncodedKeySpec == null ? (class$de$flexiprovider$pki$X509EncodedKeySpec = ElGamalKeyFactory.class$("de.flexiprovider.pki.X509EncodedKeySpec")) : class$de$flexiprovider$pki$X509EncodedKeySpec).isAssignableFrom(keySpec)) {
                return new X509EncodedKeySpec(key.getEncoded());
            }
            if ((class$de$flexiprovider$core$elgamal$ElGamalPublicKeySpec == null ? (class$de$flexiprovider$core$elgamal$ElGamalPublicKeySpec = ElGamalKeyFactory.class$("de.flexiprovider.core.elgamal.ElGamalPublicKeySpec")) : class$de$flexiprovider$core$elgamal$ElGamalPublicKeySpec).isAssignableFrom(keySpec)) {
                ElGamalPublicKey elGamalPubKey = (ElGamalPublicKey)key;
                return new ElGamalPublicKeySpec(elGamalPubKey.getModulus(), elGamalPubKey.getGenerator(), elGamalPubKey.getPublicA());
            }
        } else if (key instanceof ElGamalPrivateKey) {
            if ((class$de$flexiprovider$pki$PKCS8EncodedKeySpec == null ? (class$de$flexiprovider$pki$PKCS8EncodedKeySpec = ElGamalKeyFactory.class$("de.flexiprovider.pki.PKCS8EncodedKeySpec")) : class$de$flexiprovider$pki$PKCS8EncodedKeySpec).isAssignableFrom(keySpec)) {
                return new PKCS8EncodedKeySpec(key.getEncoded());
            }
            if ((class$de$flexiprovider$core$elgamal$ElGamalPrivateKeySpec == null ? (class$de$flexiprovider$core$elgamal$ElGamalPrivateKeySpec = ElGamalKeyFactory.class$("de.flexiprovider.core.elgamal.ElGamalPrivateKeySpec")) : class$de$flexiprovider$core$elgamal$ElGamalPrivateKeySpec).isAssignableFrom(keySpec)) {
                ElGamalPrivateKey elGamalPrivKey = (ElGamalPrivateKey)key;
                return new ElGamalPrivateKeySpec(elGamalPrivKey.getModulus(), elGamalPrivKey.getGenerator(), elGamalPrivKey.getPublicA(), elGamalPrivKey.getA());
            }
        } else {
            throw new InvalidKeySpecException("Unsupported key type: " + key.getClass() + ".");
        }
        throw new InvalidKeySpecException("Unknown key specification: " + keySpec + ".");
    }

    public Key translateKey(Key key) throws InvalidKeyException {
        if (key instanceof ElGamalPublicKey || key instanceof ElGamalPrivateKey) {
            return key;
        }
        throw new InvalidKeyException("Unsupported key type.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

