/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.dsa;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.parameters.AlgorithmParameterGenerator;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.api.parameters.AlgorithmParameters;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.core.dsa.DSAParamGenParameterSpec;
import de.flexiprovider.core.dsa.DSAParameterSpec;
import de.flexiprovider.core.dsa.DSAParameters;

public class DSAParameterGenerator
extends AlgorithmParameterGenerator {
    public static final String OID = "1.2.840.10040.4.1";
    public static final String OID2 = "1.3.14.3.2.12";
    private static final int LO_CERTAINTY = 20;
    private static final int HI_CERTAINTY = 80;
    private static final FlexiBigInt TWO = FlexiBigInt.valueOf(2L);
    private SecureRandom random;
    private int L;
    private int N;
    private boolean initialized;

    protected AlgorithmParameters getAlgorithmParameters() {
        return new DSAParameters();
    }

    public void init(AlgorithmParameterSpec genParams, SecureRandom random) throws InvalidAlgorithmParameterException {
        DSAParamGenParameterSpec dsaGenParams;
        if (genParams == null) {
            dsaGenParams = new DSAParamGenParameterSpec();
        } else if (genParams instanceof DSAParamGenParameterSpec) {
            dsaGenParams = (DSAParamGenParameterSpec)genParams;
        } else {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        this.L = dsaGenParams.getL();
        this.N = dsaGenParams.getN();
        this.random = random != null ? random : Registry.getSecureRandom();
        this.initialized = true;
    }

    public void init(int size, SecureRandom random) {
        DSAParamGenParameterSpec genParams = new DSAParamGenParameterSpec(size);
        try {
            this.init(genParams, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    private void initDefault() {
        DSAParamGenParameterSpec defaultGenParams = new DSAParamGenParameterSpec();
        try {
            this.init(defaultGenParams, Registry.getSecureRandom());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public AlgorithmParameterSpec generateParameters() {
        FlexiBigInt g;
        FlexiBigInt h;
        FlexiBigInt p;
        FlexiBigInt q;
        if (!this.initialized) {
            this.initDefault();
        }
        block0: while (true) {
            FlexiBigInt qMultTwo;
            FlexiBigInt c;
            FlexiBigInt x;
            int maxTries = 4096;
            q = new FlexiBigInt(this.N, 80, this.random);
            while ((p = (x = this.generateX()).subtract(c = x.mod(qMultTwo = q.multiply(TWO))).add(FlexiBigInt.ONE)).bitLength() < this.L || !p.isProbablePrime(20) || !p.isProbablePrime(80)) {
                if (--maxTries > 0) continue;
                continue block0;
            }
            break;
        }
        FlexiBigInt pMinusOne = p.subtract(FlexiBigInt.ONE);
        FlexiBigInt pMinusOneModQ = pMinusOne.divide(q);
        do {
            h = new FlexiBigInt(this.L - 1, this.random);
            g = h.modPow(pMinusOneModQ, p);
        } while (h.compareTo(FlexiBigInt.ONE) <= 0 || h.compareTo(pMinusOne) >= 0 || g.compareTo(FlexiBigInt.ONE) <= 0);
        return new DSAParameterSpec(p, q, g);
    }

    private FlexiBigInt generateX() {
        byte[] xBytes = new byte[this.L >> 3];
        this.random.nextBytes(xBytes);
        xBytes[0] = (byte)(xBytes[0] | 0x80);
        return new FlexiBigInt(1, xBytes);
    }
}

