/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.math.finitefields;

import de.flexiprovider.common.exceptions.DifferentFieldsException;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.math.finitefields.GFElement;

public class GFPElement
implements GFElement {
    private FlexiBigInt mValue;
    private FlexiBigInt mP;

    public GFPElement(FlexiBigInt value, FlexiBigInt p) {
        this.mValue = value.mod(p);
        this.mP = p;
    }

    public GFPElement(byte[] encValue, FlexiBigInt p) {
        this.mValue = new FlexiBigInt(1, encValue).mod(p);
        this.mP = p;
    }

    public GFPElement(GFPElement other) {
        this.mValue = other.mValue;
        this.mP = other.mP;
    }

    public Object clone() {
        return new GFPElement(this);
    }

    public static GFPElement ZERO(FlexiBigInt p) {
        return new GFPElement(FlexiBigInt.ZERO, p);
    }

    public static GFPElement ONE(FlexiBigInt p) {
        return new GFPElement(FlexiBigInt.ONE, p);
    }

    public boolean isZero() {
        return this.mValue.equals(FlexiBigInt.ZERO);
    }

    public boolean isOne() {
        return this.mValue.equals(FlexiBigInt.ONE);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof GFPElement)) {
            return false;
        }
        GFPElement otherElement = (GFPElement)other;
        return this.mP.equals(otherElement.mP) && this.mValue.equals(otherElement.mValue);
    }

    public int hashCode() {
        return this.mP.hashCode() + this.mValue.hashCode();
    }

    public GFElement add(GFElement addend) throws DifferentFieldsException {
        GFPElement result = new GFPElement(this);
        result.addToThis(addend);
        return result;
    }

    public void addToThis(GFElement addend) throws DifferentFieldsException {
        if (!(addend instanceof GFPElement)) {
            throw new DifferentFieldsException();
        }
        if (!this.mP.equals(((GFPElement)addend).mP)) {
            throw new DifferentFieldsException("Elements are of different fields.");
        }
        this.mValue = this.mValue.add(((GFPElement)addend).mValue).mod(this.mP);
    }

    public GFElement subtract(GFElement minuend) throws DifferentFieldsException {
        GFPElement result = new GFPElement(this);
        result.subtractFromThis(minuend);
        return result;
    }

    public void subtractFromThis(GFElement minuend) throws DifferentFieldsException {
        if (!(minuend instanceof GFPElement)) {
            throw new DifferentFieldsException();
        }
        this.mValue = this.mValue.subtract(((GFPElement)minuend).mValue).mod(this.mP);
    }

    public GFPElement negate() {
        return new GFPElement(this.mValue.negate(), this.mP);
    }

    public GFElement multiply(GFElement factor) throws DifferentFieldsException {
        GFPElement result = new GFPElement(this);
        result.multiplyThisBy(factor);
        return result;
    }

    public void multiplyThisBy(GFElement factor) throws DifferentFieldsException {
        if (!(factor instanceof GFPElement)) {
            throw new DifferentFieldsException();
        }
        if (!this.mP.equals(((GFPElement)factor).mP)) {
            throw new DifferentFieldsException("Elements are of different fields.");
        }
        this.mValue = this.mValue.multiply(((GFPElement)factor).mValue).mod(this.mP);
    }

    public GFElement invert() throws ArithmeticException {
        if (this.isZero()) {
            throw new ArithmeticException();
        }
        return new GFPElement(this.mValue.modInverse(this.mP), this.mP);
    }

    public byte[] toByteArray() {
        return this.mValue.toByteArray();
    }

    public FlexiBigInt toFlexiBigInt() {
        return this.mValue;
    }

    public String toString() {
        return this.mValue.toString(16);
    }

    public String toString(int radix) {
        return this.mValue.toString(radix);
    }
}

